package com.instabug.apm.fragment.model

import androidx.annotation.StringDef

@Target(AnnotationTarget.PROPERTY, AnnotationTarget.VALUE_PARAMETER, AnnotationTarget.TYPE)
@StringDef(
    PRE_ATTACH,
    POST_ATTACH,
    ON_ATTACH,
    PRE_CREATE,
    POST_CREATE,
    ON_CREATE,
    PRE_CREATE_VIEW,
    POST_CREATE_VIEW,
    ON_CREATE_VIEW,
    PRE_VIEW_CREATED,
    POST_VIEW_CREATED,
    ON_VIEW_CREATED,
    ON_ACTIVITY_CREATED,
    PRE_VIEW_STATE_RESTORED,
    POST_VIEW_STATE_RESTORED,
    ON_VIEW_STATE_RESTORED,
    PRE_START,
    POST_START,
    ON_START,
    PRE_RESUME,
    POST_RESUME,
    ON_RESUME
)
annotation class FragmentSpansEvents

const val PRE_ATTACH = "preAttach"
const val POST_ATTACH = "postAttach"
const val ON_ATTACH = "onAttach"

const val PRE_CREATE = "preCreate"
const val POST_CREATE = "postCreate"
const val ON_CREATE = "onCreate"

const val PRE_CREATE_VIEW = "preCreateView"
const val POST_CREATE_VIEW = "postCreateView"
const val ON_CREATE_VIEW = "onCreateView"

const val PRE_VIEW_CREATED = "preViewCreated"
const val POST_VIEW_CREATED = "postViewCreated"
const val ON_VIEW_CREATED = "onViewCreated"

const val PRE_ACTIVITY_CREATED = "preActivityCreated"
const val POST_ACTIVITY_CREATED = "postActivityCreated"
const val ON_ACTIVITY_CREATED = "onActivityCreated"

const val PRE_VIEW_STATE_RESTORED = "preViewStateRestored"
const val POST_VIEW_STATE_RESTORED = "postViewStateRestored"
const val ON_VIEW_STATE_RESTORED = "onViewStateRestored"

const val PRE_START = "preStart"
const val POST_START = "postStart"
const val ON_START = "onStart"

const val PRE_RESUME = "preResume"
const val POST_RESUME = "postResume"
const val ON_RESUME = "onResume"