package com.instabug.apm.di;

import static android.os.Process.THREAD_PRIORITY_BACKGROUND;
import static com.instabug.apm.constants.APMConfigurationKeys.KEY_APM_SHARED_PREFERENCES;
import static com.instabug.apm.webview.dispatch.ConstantKt.WebViewEventExecutorId;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.DisplayMetrics;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

import com.instabug.apm.APMImplementation;
import com.instabug.apm.APMSessionDataController;
import com.instabug.apm.appStateDispacher.AppStateEventDispatcher;
import com.instabug.apm.cache.handler.applaunch.AppLaunchCacheHandler;
import com.instabug.apm.cache.handler.applaunch.AppLaunchCacheHandlerImpl;
import com.instabug.apm.cache.handler.executiontraces.DanglingExecutionTracesCacheHandler;
import com.instabug.apm.cache.handler.executiontraces.DanglingExecutionTracesCacheHandlerImpl;
import com.instabug.apm.cache.handler.executiontraces.ExecutionTracesCacheHandler;
import com.instabug.apm.cache.handler.executiontraces.ExecutionTracesCacheHandlerImpl;
import com.instabug.apm.cache.handler.executiontraces.ExecutionTracesMigrationHandler;
import com.instabug.apm.cache.handler.executiontraces.ExecutionTracesMigrationHandlerImpl;
import com.instabug.apm.cache.handler.experiment.ExperimentCacheHandler;
import com.instabug.apm.cache.handler.experiment.ExperimentCacheHandlerImpl;
import com.instabug.apm.cache.handler.experiment.mapping.ExperimentsCacheTwoWayMapper;
import com.instabug.apm.cache.handler.fragments.FragmentSpansCacheHandler;
import com.instabug.apm.cache.handler.fragments.FragmentSpansCacheHandlerImpl;
import com.instabug.apm.cache.handler.fragments.FragmentSpansEventsCacheHandler;
import com.instabug.apm.cache.handler.fragments.FragmentSpansEventsCacheHandlerImpl;
import com.instabug.apm.cache.handler.networklog.DanglingNetworkLogCacheHandler;
import com.instabug.apm.cache.handler.networklog.DanglingNetworkLogCacheHandlerImpl;
import com.instabug.apm.cache.handler.networklog.NetworkLogCacheHandler;
import com.instabug.apm.cache.handler.networklog.NetworkLogCacheHandlerImpl;
import com.instabug.apm.cache.handler.networklog.NetworkLogMigrationHandler;
import com.instabug.apm.cache.handler.networklog.NetworkLogMigrationHandlerImpl;
import com.instabug.apm.cache.handler.session.SessionCacheHandler;
import com.instabug.apm.cache.handler.session.SessionCacheHandlerImpl;
import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandler;
import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandlerImpl;
import com.instabug.apm.cache.handler.uitrace.UiLoadingMetricCacheHandler;
import com.instabug.apm.cache.handler.uitrace.UiLoadingMetricCacheHandlerImpl;
import com.instabug.apm.cache.handler.uitrace.UiTraceCacheHandler;
import com.instabug.apm.cache.handler.uitrace.UiTraceCacheHandlerImpl;
import com.instabug.apm.cache.model.ExecutionTraceCacheModel;
import com.instabug.apm.common.concurrent.OrderedExecutor;
import com.instabug.apm.configuration.APMConfigurationHandler;
import com.instabug.apm.configuration.APMConfigurationHandlerImpl;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.configuration.APMConfigurationProviderImpl;
import com.instabug.apm.configuration.APMPerSessionConfigurationProvider;
import com.instabug.apm.configuration.APMPerSessionConfigurationProviderImpl;
import com.instabug.apm.configuration.APMPreferencePropertyFactory;
import com.instabug.apm.configuration.APMPreferencePropertyFactoryImpl;
import com.instabug.apm.configuration.APMStateProvider;
import com.instabug.apm.configuration.ConfigurationHandler;
import com.instabug.apm.configuration.ReadOnceAPMPreferencePropertyFactoryImpl;
import com.instabug.apm.constants.Constants;
import com.instabug.apm.fragment.FragmentLifecycleEventListener;
import com.instabug.apm.fragment.FragmentLifecycleEventListenerImpl;
import com.instabug.apm.fragment.FragmentSpansHelper;
import com.instabug.apm.fragment.FragmentSpansHelperImpl;
import com.instabug.apm.handler.applaunch.AppLaunchesHandler;
import com.instabug.apm.handler.applaunch.AppLaunchesHandlerImpl;
import com.instabug.apm.handler.attributes.NetworkTraceAttributesHandler;
import com.instabug.apm.handler.attributes.NetworkTraceAttributesHandlerImpl;
import com.instabug.apm.handler.executiontraces.ExecutionTracesHandler;
import com.instabug.apm.handler.executiontraces.ExecutionTracesHandlerImpl;
import com.instabug.apm.handler.experiment.ExperimentHandler;
import com.instabug.apm.handler.experiment.ExperimentHandlerImpl;
import com.instabug.apm.handler.fragment.FragmentSpansHandler;
import com.instabug.apm.handler.fragment.FragmentSpansHandlerImpl;
import com.instabug.apm.handler.networklog.NetworkLogHandler;
import com.instabug.apm.handler.networklog.NetworkLogHandlerImpl;
import com.instabug.apm.handler.networklog.NetworkLogHandlerSanitizationDecorator;
import com.instabug.apm.handler.session.SessionHandler;
import com.instabug.apm.handler.session.SessionHandlerImpl;
import com.instabug.apm.handler.session.SessionObserverRegistry;
import com.instabug.apm.handler.session.SessionObserverRegistryImpl;
import com.instabug.apm.handler.uitrace.customuitraces.CustomUiTraceHandler;
import com.instabug.apm.handler.uitrace.customuitraces.CustomUiTraceHandlerImpl;
import com.instabug.apm.handler.uitrace.uiloading.ActivityEventToUiLoadingModelMapper;
import com.instabug.apm.handler.uitrace.uiloading.AdvancedActivityEventToUiLoadingModelMapper;
import com.instabug.apm.handler.uitrace.uiloading.DefaultActivityEventToUiLoadingModelMapper;
import com.instabug.apm.handler.uitrace.uiloading.UiLoadingMetricHandler;
import com.instabug.apm.handler.uitrace.uiloading.UiLoadingMetricHandlerImpl;
import com.instabug.apm.lifecycle.ActivityCallbacks;
import com.instabug.apm.lifecycle.AppLaunchDataRepository;
import com.instabug.apm.lifecycle.AppLaunchLifeCycleCallbacks;
import com.instabug.apm.lifecycle.AppLaunchLifeCycleCallbacksImpl;
import com.instabug.apm.lifecycle.AppLaunchModelFactory;
import com.instabug.apm.lifecycle.AppLaunchModelFactoryImpl;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.apm.networking.handler.SyncManagerNetworkHandler;
import com.instabug.apm.networking.handler.SyncManagerNetworkHandlerImpl;
import com.instabug.apm.networking.mapping.applaunch.AppLaunchMapper;
import com.instabug.apm.networking.mapping.applaunch.AppLaunchMapperImpl;
import com.instabug.apm.networking.mapping.executiontraces.ExecutionTraceMapperImpl;
import com.instabug.apm.networking.mapping.experiment.ExperimentMapper;
import com.instabug.apm.networking.mapping.experiment.ExperimentMapperImpl;
import com.instabug.apm.networking.mapping.fragment_span.FragmentSpanMapper;
import com.instabug.apm.networking.mapping.fragment_span.FragmentSpanMapperImpl;
import com.instabug.apm.networking.mapping.networklog.APMNetworkLogMapper;
import com.instabug.apm.networking.mapping.networklog.APMNetworkLogMapperImpl;
import com.instabug.apm.networking.mapping.sessions.SessionFeatureJsonFiller;
import com.instabug.apm.networking.mapping.sessions.SessionMapper;
import com.instabug.apm.networking.mapping.sessions.SessionMapperImpl;
import com.instabug.apm.networking.mapping.sessions.SessionModelFiller;
import com.instabug.apm.networking.mapping.uiloading.UiLoadingMapper;
import com.instabug.apm.networking.mapping.uiloading.UiLoadingMapperImpl;
import com.instabug.apm.networking.mapping.uitrace.UiTraceMapper;
import com.instabug.apm.networking.mapping.uitrace.UiTraceMapperImpl;
import com.instabug.apm.networkinterception.NetworkLogToTraceMapper;
import com.instabug.apm.networkinterception.configuration.NetworkInterceptionConfigurationProvider;
import com.instabug.apm.networkinterception.configuration.NetworkInterceptionConfigurationProviderImpl;
import com.instabug.apm.networkinterception.external_network_trace.RandomUIntProvider;
import com.instabug.apm.networkinterception.external_network_trace.TimestampProviderSeconds;
import com.instabug.apm.networkinterception.external_network_trace.W3CExternalNetworkTraceIdFactory;
import com.instabug.apm.networkinterception.external_network_trace.W3CExternalNetworkTraceIdInfo;
import com.instabug.apm.networkinterception.external_network_trace.W3CFormatProvider;
import com.instabug.apm.networkinterception.map.ApmNetworkLogNetworkSnapshotMapper;
import com.instabug.apm.networkinterception.repository.NetworkInterceptionRepository;
import com.instabug.apm.networkinterception.repository.NetworkInterceptionRepositoryImpl;
import com.instabug.apm.networkinterception.sanitization.InstabugRequestSanitizerFactory;
import com.instabug.apm.networkinterception.sanitization.NetworkInterceptionSanitizerFactory;
import com.instabug.apm.networkinterception.sanitization.UserDefinedSanitizerFactory;
import com.instabug.apm.preferences.APMPrefPropertyKt;
import com.instabug.apm.sanitization.Sanitizer;
import com.instabug.apm.sync.APMSyncManager;
import com.instabug.apm.sync.APMSyncManagerImpl;
import com.instabug.apm.uitrace.UiTraceSessionFeatureJsonFiller;
import com.instabug.apm.uitrace.activitycallbacks.APMUiTraceActivityCallbacks;
import com.instabug.apm.uitrace.uihangs.FrameDropsCalculatorImpl;
import com.instabug.apm.util.ContextKtxKt;
import com.instabug.apm.util.debug.DebugUtils;
import com.instabug.apm.util.debug.DebugUtilsImpl;
import com.instabug.apm.util.device.APMDeviceStateProvider;
import com.instabug.apm.util.device.APMDeviceStateProviderImpl;
import com.instabug.apm.util.logging.APMLogPenaltyHandler;
import com.instabug.apm.util.powermanagement.BatteryLevelChangeBroadcast;
import com.instabug.apm.util.powermanagement.PowerSaveModeBroadcast;
import com.instabug.apm.v3_session_data_readiness.APMSessionReadinessManager;
import com.instabug.apm.v3_session_data_readiness.APMSessionLazyDataProvider;
import com.instabug.apm.v3_session_data_readiness.APMV3SessionSyncNotifier;
import com.instabug.apm.v3_session_data_readiness.APMV3SessionSyncNotifierImpl;
import com.instabug.apm.webview.vital.InstabugWebViewVitalJSInterface;
import com.instabug.apm.webview.vital.InstabugWebVitalsEventListener;
import com.instabug.apm.webview.webview_trace.WebViewCacheModelToJsonMapper;
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationHandler;
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider;
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProviderImpl;
import com.instabug.apm.webview.webview_trace.flow.WebViewCompositeFlow;
import com.instabug.apm.webview.webview_trace.flow.WebViewEventFlow;
import com.instabug.apm.webview.webview_trace.flow.WebViewNewTraceFlow;
import com.instabug.apm.webview.webview_trace.flow.WebViewTimeThresholdFlow;
import com.instabug.apm.webview.webview_trace.flow.WebViewVitalCapturingFlow;
import com.instabug.apm.webview.webview_trace.handler.APMWebViewTraceCacheHandler;
import com.instabug.apm.webview.webview_trace.handler.APMWebViewTraceCacheHandlerImpl;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceEventListener;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceEventListenerImpl;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceHandler;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceHandlerImpl;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceModelWrapper;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceRepository;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceRepositoryImpl;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceVitalListenerFactory;
import com.instabug.apm.webview.webview_trace.manager.WebViewTraceManager;
import com.instabug.apm.webview.webview_trace.manager.WebViewTraceManagerImpl;
import com.instabug.apm.webview.webview_trace.model.WebViewCacheModel;
import com.instabug.apm.webview.webview_trace.model.WebViewTraceModel;
import com.instabug.apm.webview.webview_trace.model.WebViewTraceModelToCacheModelMapper;
import com.instabug.apm.webview.webview_trace.model.WebViewVitalsToJsonStringMapper;
import com.instabug.apm.webview.webview_trace.util.WebViewSizeEventResolver;
import com.instabug.apm.webview.webview_trace.util.WebViewTraceUrlSanitizer;
import com.instabug.apm.webview.webview_trace.util.WebViewTraceUrlSanitizerImpl;
import com.instabug.library.AppLaunchIDProvider;
import com.instabug.library.Instabug;
import com.instabug.library.SpanIDProvider;
import com.instabug.library.core.eventbus.OnSessionCrashedEventBus;
import com.instabug.library.factory.ParameterizedFactory;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;
import com.instabug.library.logging.listeners.networklogs.NetworkLogSnapshot;
import com.instabug.library.map.Mapper;
import com.instabug.library.map.TwoWayMapper;
import com.instabug.library.networkinterception.NetworkInterceptionServiceLocator;
import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.utils.IBGDomainProvider;
import com.instabug.library.sessionV3.providers.FeatureSessionDataController;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.LimitConstraintApplier;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.util.threading.PriorityThreadFactory;

import org.json.JSONArray;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * This class is providing all dependencies for APM module
 */
@SuppressWarnings("squid:S3077") // supresses sonarcube warnings on volatile fields
public class ServiceLocator {

    private static Context appContext;
    private static APMConfigurationProviderImpl apmConfigurationProvider;
    @Nullable
    private static NetworkInterceptionConfigurationProvider networkInterceptionConfigurationProvider;
    private static APMConfigurationHandler apmConfigurationHandler;
    @Nullable
    private static APMSyncManager apmSyncManager;
    @Nullable
    private static Map<String, ThreadPoolExecutor> threadPoolExecutorMap;

    @Nullable
    private static ExecutionTracesHandler executionTracesHandler;
    @Nullable
    private static ExecutionTracesCacheHandler executionTracesCacheHandler;
    @Nullable
    private static DanglingExecutionTracesCacheHandler danglingExecutionTracesCacheHandler;
    @Nullable
    private static AppLaunchesHandler appLaunchesHandler;
    @Nullable
    private static AppLaunchCacheHandler appLaunchCacheHandler;
    @Nullable
    private static SessionHandler sessionHandler;
    @Nullable
    private static WeakReference<SessionMetaDataCacheHandler> sessionMetaDataCacheHandler;
    @Nullable
    private static WeakReference<SyncManagerNetworkHandler> syncManagerNetworkHandler;
    @Nullable
    private static WeakReference<SessionMapper> sessionMapper;
    @Nullable
    private static WeakReference<UiTraceMapper> uiTraceMapper;

    @Nullable
    private static UiTraceCacheHandler uiTraceCacheHandler;

    @Nullable
    private static UiLoadingMetricCacheHandler uiLoadingMetricCacheHandler;

    @Nullable
    private static WeakReference<DatabaseManager> databaseManager;
    @Nullable
    private static SessionObserverRegistry sessionObserverRegistry;

    @Nullable
    private static CustomUiTraceHandlerImpl customUiTraceHandler;

    @Nullable
    private static NetworkTraceAttributesHandler networkTraceAttributesHandler;

    @Nullable
    private static ActivityCallbacks activityCallbacks;

    private static AppLaunchDataRepository appLaunchDataRepository;

    @Nullable
    private static ExperimentHandler experimentHandler;

    @Nullable
    private static AppLaunchLifeCycleCallbacks appLaunchLifeCycleCallbacks;

    @Nullable
    private static NetworkInterceptionRepository networkInterceptionRepository;

    @Nullable
    private static volatile FragmentSpansCacheHandler fragmentSpansCacheHandler;

    @Nullable
    private static volatile FragmentSpansEventsCacheHandler fragmentSpansEventsCacheHandler;

    @Nullable
    private static volatile FragmentSpansHandler fragmentSpansHandler;

    @Nullable
    private static volatile FragmentSpansHelper fragmentSpansHelper;

    @Nullable
    private static volatile FragmentLifecycleEventListener fragmentLifecycleEventListener;

    @Nullable
    private static volatile FeatureSessionDataController apmSessionDataController;

    @Nullable
    private static BatteryLevelChangeBroadcast batteryLevelChangeBroadcastReceiver;
    @Nullable
    private static PowerSaveModeBroadcast powerSaveModeBroadcastReceiver;

    @Nullable
    private static volatile ParameterizedFactory<W3CExternalNetworkTraceIdInfo, String> ExternalNetworkTraceIdFactory;

    @Nullable
    private static volatile WebViewTraceConfigurationProvider webViewTraceConfigurationProvider;
    @Nullable
    private static volatile WeakReference<APMWebViewTraceCacheHandler> webViewTraceCacheHandler;
    @Nullable
    private static volatile WeakReference<WebViewTraceHandler> webViewTraceHandler;
    @Nullable
    private static volatile WebViewTraceManager webViewTraceManager;
    @Nullable
    private static volatile WeakReference<WebViewSizeEventResolver> webViewSizeEventResolverWaekReference;
    @Nullable
    private static volatile AppStateEventDispatcher appStateEventDispatcher;
    private static final String APP_STATE_DISPATCHER_EXECUTOR_ID = "app_state_dispatcher_executor";
    @Nullable
    private static volatile APMSessionLazyDataProvider apmSessionLazyDataProvider;
    @Nullable
    private static volatile WeakReference<APMV3SessionSyncNotifier> apmv3SessionSyncNotifierWeakReference;

    public static void setContext(Context appContext) {
        ServiceLocator.appContext = appContext;
    }

    @Nullable
    public synchronized static Context getContext() {
        if (appContext != null) {
            return appContext;
        } else {
            if (Instabug.isBuilt()) {
                return Instabug.getApplicationContext();
            } else {
                return null;
            }
        }
    }

    public static APMImplementation getApmImplementation() {
        return new APMImplementation(getApmLogger());
    }

    public static Logger getApmLogger() {
        return new Logger(getApmConfigurationProvider());
    }

    @Nullable
    public synchronized static SharedPreferences getSharedPreferences() {
        return APMPrefPropertyKt.getApmPreferences();
    }

    public synchronized static APMConfigurationHandler getApmConfigurationHandler() {
        if (apmConfigurationHandler == null) {
            apmConfigurationHandler = new APMConfigurationHandlerImpl(
                    getApmConfigurationProvider(),
                    getNetworkInterceptionConfigurationProvider(),
                    getSDKConfigurationHandlersProvider(),
                    getAPMConfigurationHandlersProvider()
            );
        }
        return apmConfigurationHandler;
    }

    @NonNull
    public static APMConfigurationProvider getApmConfigurationProvider() {
        return getApmConfigurationProviderImpl();
    }

    @NonNull
    public static APMStateProvider getApmStateProvider() {
        return getApmConfigurationProviderImpl();
    }

    @NonNull
    private synchronized static APMConfigurationProviderImpl getApmConfigurationProviderImpl() {
        if (apmConfigurationProvider == null) {
            apmConfigurationProvider = new APMConfigurationProviderImpl(
                    getLimitConstraintApplier(),
                    getCoreNetworkInterceptionConfigurationProvider()
            );
        }
        return apmConfigurationProvider;
    }

    @NonNull
    public static LimitConstraintApplier getLimitConstraintApplier() {
        return CoreServiceLocator.getLimitConstraintApplier();
    }

    @Nullable
    @SuppressLint("RESOURCE_LEAK")
    public synchronized static DatabaseManager getDatabaseManager() {
        if (databaseManager == null || databaseManager.get() == null) {
            if (getContext() != null) {
                try {
                    databaseManager = new WeakReference<>(DatabaseManager.getInstance());
                    return databaseManager.get();
                } catch (Exception e) {
                    getApmLogger().e("Error while getting database manager: " + e.getMessage());
                    return null;
                }
            } else {
                return null;
            }
        }
        return databaseManager.get();
    }

    public static NetworkManager getNetworkManager() {
        return new NetworkManager();
    }

    public synchronized static ExecutionTracesHandler getExecutionTracesHandler() {
        if (executionTracesHandler == null) {
            executionTracesHandler = new ExecutionTracesHandlerImpl();
        }
        return executionTracesHandler;
    }

    public synchronized static Executor getSingleThreadPoolExecutor(String name) {
        // Use a local allocation to overcome SpotBugs false possible NPE warnings
        Map<String, ThreadPoolExecutor> localThreadPoolExecutorMap = threadPoolExecutorMap;
        if (localThreadPoolExecutorMap == null) {
            localThreadPoolExecutorMap = new ConcurrentHashMap<>();
        }
        ThreadPoolExecutor threadPoolExecutor = localThreadPoolExecutorMap.get(name);
        if (threadPoolExecutor == null) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1,
                    1,
                    30L,
                    TimeUnit.MINUTES,
                    new LinkedBlockingQueue<>(),
                    new PriorityThreadFactory(name, THREAD_PRIORITY_BACKGROUND));
            localThreadPoolExecutorMap.put(name, executor);
            threadPoolExecutorMap = localThreadPoolExecutorMap;
            return executor;
        }
        return threadPoolExecutor;
    }

    public synchronized static ExecutionTracesCacheHandler getExecutionTracesCacheHandler() {
        if (executionTracesCacheHandler == null) {
            executionTracesCacheHandler = new ExecutionTracesCacheHandlerImpl();
        }
        return executionTracesCacheHandler;
    }

    public synchronized static DanglingExecutionTracesCacheHandler getDanglingExecutionTracesCacheHandler() {
        if (danglingExecutionTracesCacheHandler == null) {
            danglingExecutionTracesCacheHandler = new DanglingExecutionTracesCacheHandlerImpl(getDatabaseManager(), getApmLogger());
        }
        return danglingExecutionTracesCacheHandler;
    }

    public synchronized static void reset() {
        threadPoolExecutorMap = null;
        apmSyncManager = null;
        executionTracesHandler = null;
        executionTracesCacheHandler = null;
        appLaunchesHandler = null;
        appLaunchCacheHandler = null;
        uiTraceCacheHandler = null;
        customUiTraceHandler = null;
        uiLoadingMetricCacheHandler = null;
        experimentHandler = null;
    }

    public static synchronized Mapper<List<ExecutionTraceCacheModel>, JSONArray> getExecutionTracesMapper() {
        return ExecutionTraceMapperImpl.create();
    }

    public synchronized static APMSyncManager getApmSyncManager() {
        if (apmSyncManager == null) {
            apmSyncManager = new APMSyncManagerImpl();
        }
        return apmSyncManager;
    }

    public synchronized static AppLaunchesHandler getAppLaunchesHandler() {
        if (appLaunchesHandler == null) {
            appLaunchesHandler = new AppLaunchesHandlerImpl();
        }
        return appLaunchesHandler;
    }

    public synchronized static AppLaunchCacheHandler getAppLaunchCacheHandler() {
        if (appLaunchCacheHandler == null) {
            appLaunchCacheHandler = new AppLaunchCacheHandlerImpl();
        }
        return appLaunchCacheHandler;
    }

    public static AppLaunchMapper getAppLaunchMapper() {
        return new AppLaunchMapperImpl();
    }

    public static APMPerSessionConfigurationProvider getApmPerSessionConfigurationProvider() {
        return new APMPerSessionConfigurationProviderImpl();
    }

    public static NetworkLogHandler getNetworkLogHandler() {
        return new NetworkLogHandlerImpl();
    }

    public static NetworkLogHandler getNetworkLogHandler(Sanitizer<APMNetworkLog> sanitizer) {
        return new NetworkLogHandlerSanitizationDecorator(
                getNetworkLogHandler(),
                sanitizer,
                getApmLogger()
        );
    }

    public static NetworkLogCacheHandler getNetworkLogCacheHandler() {
        return new NetworkLogCacheHandlerImpl();
    }

    public static DanglingNetworkLogCacheHandler getDanglingNetworkLogCacheHandler() {
        return new DanglingNetworkLogCacheHandlerImpl(getDatabaseManager());
    }

    public static APMNetworkLogMapper getNetworkLogMapper() {
        return new APMNetworkLogMapperImpl();
    }

    public static ExceptionHandler getExceptionHandler() {
        return new ExceptionHandler().withPenalty(new APMLogPenaltyHandler(getApmLogger()));
    }

    @NonNull
    public synchronized static SessionHandler getSessionHandler() {
        // Use a local allocation to overcome SpotBugs false possible NPE warnings
        SessionHandler localSessionHandler = sessionHandler;
        if (localSessionHandler == null) {
            // dependencies
            ExceptionHandler exceptionHandler = getExceptionHandler();
            Logger logger = getApmLogger();
            //instances
            SessionCacheHandler cacheHandler = new SessionCacheHandlerImpl(exceptionHandler, logger);
            localSessionHandler = new SessionHandlerImpl(
                    getApmConfigurationProvider(),
                    getApmStateProvider(),
                    cacheHandler,
                    exceptionHandler,
                    logger
            );
            sessionHandler = localSessionHandler;
        }
        return localSessionHandler;
    }

    public static synchronized AppLaunchLifeCycleCallbacks getAppLaunchLifeCycleCallbacks(
            Context context,
            boolean isRegisteredBeforeFirstActivityLaunch
    ) {
        if (appLaunchLifeCycleCallbacks == null) {
            appLaunchLifeCycleCallbacks = new AppLaunchLifeCycleCallbacksImpl(
                    () -> ContextKtxKt.didAppStartInBackground(context),
                    isRegisteredBeforeFirstActivityLaunch,
                    getAppLaunchModelFactory()
            );
        }
        return appLaunchLifeCycleCallbacks;
    }

    public static synchronized AppLaunchModelFactory getAppLaunchModelFactory() {
        return new AppLaunchModelFactoryImpl();
    }

    @Nullable
    public static synchronized AppLaunchLifeCycleCallbacks getAppLaunchLifeCycleCallbacks() {
        return appLaunchLifeCycleCallbacks;
    }

    public static synchronized UiTraceCacheHandler getUiTraceCacheHandler() {
        if (uiTraceCacheHandler == null) {
            uiTraceCacheHandler = new UiTraceCacheHandlerImpl();
        }
        return uiTraceCacheHandler;
    }

    @NonNull
    public static synchronized UiLoadingMetricCacheHandler getUiLoadingMetricCacheHandler() {
        // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
        UiLoadingMetricCacheHandler localUiLoadingMetricCacheHandlerImpl = uiLoadingMetricCacheHandler;
        if (localUiLoadingMetricCacheHandlerImpl == null) {
            localUiLoadingMetricCacheHandlerImpl = new UiLoadingMetricCacheHandlerImpl();
        }
        uiLoadingMetricCacheHandler = localUiLoadingMetricCacheHandlerImpl;
        return localUiLoadingMetricCacheHandlerImpl;
    }

    public static APMDeviceStateProvider getDeviceStateProvider() {
        return new APMDeviceStateProviderImpl();
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    @Nullable
    public synchronized static BatteryLevelChangeBroadcast getBatteryBroadcastReceiver() {
        if (batteryLevelChangeBroadcastReceiver == null) {
            Context context = getContext();
            if (context != null) {
                batteryLevelChangeBroadcastReceiver = new BatteryLevelChangeBroadcast(context);
            }
        }
        return batteryLevelChangeBroadcastReceiver;
    }

    @Nullable
    public synchronized static PowerSaveModeBroadcast getPowerSaveModeBroadcastReceiver() {
        if (powerSaveModeBroadcastReceiver == null) {
            Context context = getContext();
            if (context != null) {
                powerSaveModeBroadcastReceiver = new PowerSaveModeBroadcast(context);
            }
        }
        return powerSaveModeBroadcastReceiver;
    }

    @NonNull
    public static ActivityEventToUiLoadingModelMapper getActivityEventToUiLoadingModelMapper() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            return new AdvancedActivityEventToUiLoadingModelMapper();
        } else {
            return new DefaultActivityEventToUiLoadingModelMapper();
        }
    }

    @NonNull
    public static UiLoadingMetricHandler getUiLoadingMetricHandler() {
        return new UiLoadingMetricHandlerImpl(
                getActivityEventToUiLoadingModelMapper(),
                getApmLogger()
        );
    }

    @NonNull
    public static UiLoadingMapper getUiLoadingMetricMapper() {
        return new UiLoadingMapperImpl();
    }

    @Nullable
    public synchronized static SessionMetaDataCacheHandler getSessionMetaDataCacheHandler() {
        if (sessionMetaDataCacheHandler == null || sessionMetaDataCacheHandler.get() == null) {
            sessionMetaDataCacheHandler = new WeakReference<>
                    (new SessionMetaDataCacheHandlerImpl());
        }
        return sessionMetaDataCacheHandler.get();
    }

    @NonNull
    public synchronized static SessionMapper getSessionMapper() {
        SessionMapper sessionMapperImpl;
        if (sessionMapper == null || sessionMapper.get() == null) {
            sessionMapperImpl = new SessionMapperImpl(getSessionFeatureJsonFillersProvider());
            sessionMapper = new WeakReference<>(sessionMapperImpl);
        } else {
            sessionMapperImpl = sessionMapper.get();
        }
        return sessionMapperImpl;
    }

    @NonNull
    public synchronized static SyncManagerNetworkHandler getSyncManagerNetworkHandler() {
        SyncManagerNetworkHandler syncManagerNetworkHandlerImpl;
        if (syncManagerNetworkHandler == null || syncManagerNetworkHandler.get() == null) {
            syncManagerNetworkHandlerImpl = new SyncManagerNetworkHandlerImpl();
            syncManagerNetworkHandler = new WeakReference<>
                    (syncManagerNetworkHandlerImpl);
        } else {
            syncManagerNetworkHandlerImpl = syncManagerNetworkHandler.get();
        }
        return syncManagerNetworkHandlerImpl;
    }

    @NonNull
    public synchronized static UiTraceMapper getUiTraceMapper() {
        UiTraceMapper uiTraceMapperImpl;
        if (uiTraceMapper == null || uiTraceMapper.get() == null) {
            uiTraceMapperImpl = new UiTraceMapperImpl(getUiLoadingMetricMapper(), new WebViewCacheModelToJsonMapper());
            uiTraceMapper = new WeakReference<>(uiTraceMapperImpl);
        } else {
            uiTraceMapperImpl = uiTraceMapper.get();
        }
        return uiTraceMapperImpl;
    }

    @NonNull
    public static SessionFeatureJsonFiller getUiTracesSessionFeatureJsonFiller() {
        return new UiTraceSessionFeatureJsonFiller(getUiTraceMapper());
    }

    public static DebugUtils getDebugUtils() {
        return new DebugUtilsImpl();
    }

    @Nullable
    public static String getAppToken() {
        return SettingsManager.getInstance().getAppToken();
    }

    public static ExecutionTracesMigrationHandler getExecutionTracesMigrationHandler() {
        return new ExecutionTracesMigrationHandlerImpl(
                getExecutionTracesCacheHandler(),
                getDanglingExecutionTracesCacheHandler(),
                getApmConfigurationProvider(),
                PoolProvider.getSyncExecutor(),
                getSessionMetaDataCacheHandler());
    }

    public static NetworkLogMigrationHandler getNetworkLogMigrationHandler() {
        return new NetworkLogMigrationHandlerImpl(
                getNetworkLogCacheHandler(),
                getDanglingNetworkLogCacheHandler(),
                getApmConfigurationProvider(),
                getSessionMetaDataCacheHandler());
    }

    @NonNull
    public static synchronized SessionObserverRegistry getSessionObserverRegistry() {
        // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
        SessionObserverRegistry localSessionObserverRegistry = sessionObserverRegistry;
        if (localSessionObserverRegistry == null) {
            localSessionObserverRegistry = new SessionObserverRegistryImpl();
        }
        sessionObserverRegistry = localSessionObserverRegistry;
        return localSessionObserverRegistry;
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    @Nullable
    public static synchronized CustomUiTraceHandler getCustomUiTraceHandler() {
        return getCustomUiTraceHandlerImpl();
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    @Nullable
    public static synchronized APMUiTraceActivityCallbacks getCustomUiTraceHandlerActivityCallbacks() {
        return getCustomUiTraceHandlerImpl();
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    @Nullable
    private static CustomUiTraceHandlerImpl getCustomUiTraceHandlerImpl() {
        if (customUiTraceHandler == null) {
            BatteryLevelChangeBroadcast batteryBroadcastReceiver = getBatteryBroadcastReceiver();
            PowerSaveModeBroadcast powerSaveModeReceiver = getPowerSaveModeBroadcastReceiver();
            if (batteryBroadcastReceiver != null && powerSaveModeReceiver != null)
                customUiTraceHandler = new CustomUiTraceHandlerImpl(
                        batteryBroadcastReceiver,
                        powerSaveModeReceiver,
                        getDeviceStateProvider(),
                        getApmConfigurationProvider(),
                        getApmLogger(),
                        new FrameDropsCalculatorImpl()
                );
        }
        return customUiTraceHandler;
    }

    public static OnSessionCrashedEventBus getOnSessionCrashedEventBus() {
        return OnSessionCrashedEventBus.getInstance();
    }

    public static synchronized Executor getSyncThreadExecutor() {
        return PoolProvider.getSyncExecutor();
    }

    public static Executor getIOExecutor() {
        return PoolProvider.getInstance().getBackgroundExecutor();
    }

    public static synchronized Executor getSingleThreadExecutor(String identifier) {
        return PoolProvider.getSingleThreadExecutor(identifier);
    }

    public static synchronized NetworkTraceAttributesHandler getNetworkTraceAttributesHandler() {
        if (networkTraceAttributesHandler == null) {
            networkTraceAttributesHandler = new NetworkTraceAttributesHandlerImpl();
        }
        return networkTraceAttributesHandler;
    }

    // Create a new instance of ActivityCallbacks if it's not instantiated
    public static synchronized ActivityCallbacks getActivityCallbacks(
            Context context,
            boolean isRegisteredBeforeFirstActivityLaunch
    ) {
        if (activityCallbacks == null) {
            activityCallbacks = new ActivityCallbacks(
                    context,
                    isRegisteredBeforeFirstActivityLaunch
            );
        }
        return activityCallbacks;
    }

    public static synchronized AppLaunchDataRepository getAppLaunchDataRepository() {
        if (appLaunchDataRepository == null) {
            appLaunchDataRepository = new AppLaunchDataRepository();
        }
        return appLaunchDataRepository;
    }

    public static TwoWayMapper<List<String>, byte[]> getExperimentsCacheTwoWayMapper() {
        return ExperimentsCacheTwoWayMapper.createInstance();
    }

    @Nullable
    public static ExperimentCacheHandler getExperimentsCacheHandler() {
        DatabaseManager databaseManager = getDatabaseManager();
        Logger apmLogger = getApmLogger();
        TwoWayMapper<List<String>, byte[]> mapper = getExperimentsCacheTwoWayMapper();
        if (databaseManager != null && apmLogger != null && mapper != null) {
            return new ExperimentCacheHandlerImpl(databaseManager, apmLogger, mapper);
        }
        return null;
    }

    @Nullable
    public static synchronized ExperimentHandler getExperimentHandler() {
        ExperimentHandler localExperimentHandler = experimentHandler;
        if (localExperimentHandler == null) {
            ExperimentCacheHandler experimentsCacheHandler = getExperimentsCacheHandler();
            SessionMetaDataCacheHandler metaDataCacheHandler = getSessionMetaDataCacheHandler();
            APMConfigurationProvider configurationProvider = getApmConfigurationProvider();
            Logger apmLogger = getApmLogger();
            if (experimentsCacheHandler != null &&
                    metaDataCacheHandler != null &&
                    configurationProvider != null &&
                    apmLogger != null
            ) {
                localExperimentHandler = new ExperimentHandlerImpl(
                        experimentsCacheHandler,
                        metaDataCacheHandler,
                        configurationProvider,
                        apmLogger
                );
            }
        }
        experimentHandler = localExperimentHandler;
        return localExperimentHandler;
    }

    public static ExperimentMapper getExperimentMapper() {
        return new ExperimentMapperImpl();
    }

    public static FragmentSpanMapper getFragmentSpanMapper() {
        return new FragmentSpanMapperImpl();
    }

    public static FragmentSpansCacheHandler getFragmentSpansCacheManager() {
        if (fragmentSpansCacheHandler == null) {
            synchronized (ServiceLocator.class) {
                if (fragmentSpansCacheHandler == null)
                    fragmentSpansCacheHandler = new FragmentSpansCacheHandlerImpl();
            }
        }
        return fragmentSpansCacheHandler;
    }

    public static FragmentSpansEventsCacheHandler getFragmentSpansEventsCacheHandler() {
        if (fragmentSpansEventsCacheHandler == null) {
            synchronized (ServiceLocator.class) {
                if (fragmentSpansEventsCacheHandler == null)
                    fragmentSpansEventsCacheHandler = new FragmentSpansEventsCacheHandlerImpl();
            }
        }
        return fragmentSpansEventsCacheHandler;
    }

    public static FragmentSpansHandler getFragmentSpansHandler() {
        if (fragmentSpansHandler == null) {
            synchronized (ServiceLocator.class) {
                if (fragmentSpansHandler == null)
                    fragmentSpansHandler = new FragmentSpansHandlerImpl();
            }
        }
        return fragmentSpansHandler;
    }

    public static FeatureSessionDataController getSessionDataController() {
        if (apmSessionDataController == null) {
            synchronized (ServiceLocator.class) {
                if (apmSessionDataController == null)
                    apmSessionDataController = new APMSessionDataController(getSessionModelsFillerProvider());
            }
        }
        return apmSessionDataController;
    }

    public static FragmentSpansHelper getFragmentSpansHelper() {
        if (fragmentSpansHelper == null) {
            synchronized (ServiceLocator.class) {
                if (fragmentSpansHelper == null)
                    fragmentSpansHelper = new FragmentSpansHelperImpl();
            }
        }
        return fragmentSpansHelper;
    }

    public static FragmentLifecycleEventListener getFragmentLifecycleEventListener() {
        if (fragmentLifecycleEventListener == null) {
            synchronized (ServiceLocator.class) {
                if (fragmentLifecycleEventListener == null)
                    fragmentLifecycleEventListener = new FragmentLifecycleEventListenerImpl();
            }
        }
        return fragmentLifecycleEventListener;
    }

    @Nullable
    public static APMPreferencePropertyFactory getAPMPreferencePropertyFactory() {
        SharedPreferences apmSharedPrefs = getSharedPreferences();
        if (apmSharedPrefs != null) {
            return new APMPreferencePropertyFactoryImpl(apmSharedPrefs);
        }
        return null;
    }

    @Nullable
    public static APMPreferencePropertyFactory getReadOnceAPMPreferencePropertyFactory() {
        SharedPreferences apmSharedPrefs = getSharedPreferences();
        if (apmSharedPrefs != null) {
            return new ReadOnceAPMPreferencePropertyFactoryImpl(apmSharedPrefs);
        }
        return null;
    }

    @Nullable
    public static synchronized NetworkInterceptionConfigurationProvider getNetworkInterceptionConfigurationProvider() {
        if (networkInterceptionConfigurationProvider == null) {
            APMConfigurationProvider localApmConfigurationProvider = getApmConfigurationProvider();
            APMPreferencePropertyFactory factory = getAPMPreferencePropertyFactory();
            if (factory != null && localApmConfigurationProvider != null) {
                networkInterceptionConfigurationProvider =
                        new NetworkInterceptionConfigurationProviderImpl(
                                localApmConfigurationProvider, factory
                        );
            }
        }
        return networkInterceptionConfigurationProvider;
    }

    public static NetworkLogToTraceMapper getNetworkLogToTraceMapper() {
        return new NetworkLogToTraceMapper();
    }

    public static Mapper<APMNetworkLog, NetworkLogSnapshot> getAPMNetworkLogNetworkLogSnapshotMapper() {
        return new ApmNetworkLogNetworkSnapshotMapper();
    }

    public static Sanitizer<APMNetworkLog> getNetworkInterceptionSanitizer(int type) {
        return new NetworkInterceptionSanitizerFactory(
                getInstabugSanitizerFactory(),
                getUserDefinedSanitizerFactory()
        ).create(type);
    }

    @NonNull
    private static InstabugRequestSanitizerFactory getInstabugSanitizerFactory() {
        return new InstabugRequestSanitizerFactory(
                getNetworkInterceptionConfigurationProvider(),
                IBGDomainProvider.INSTANCE
        );
    }

    @NonNull
    private static UserDefinedSanitizerFactory getUserDefinedSanitizerFactory() {
        return new UserDefinedSanitizerFactory(
                getAPMNetworkLogNetworkLogSnapshotMapper(),
                getApmConfigurationProvider(),
                getNetworkInterceptionRepository(),
                getApmLogger()
        );
    }

    public static synchronized NetworkInterceptionRepository getNetworkInterceptionRepository() {
        if (networkInterceptionRepository == null) {
            networkInterceptionRepository = new NetworkInterceptionRepositoryImpl();
        }
        return networkInterceptionRepository;
    }

    public static void postNetworkLoggingTask(Runnable runnable) {
        PoolProvider.postOrderedIOTask(Constants.NETWORK_LOG_THREAD_EXECUTOR, runnable);
    }

    public static Provider<SessionFeatureJsonFiller[]> getSessionFeatureJsonFillersProvider() {
        return new SessionJSONFillersProvider();
    }

    public static Provider<ConfigurationHandler[]> getSDKConfigurationHandlersProvider() {
        return new SDKConfigurationHandlersProvider();
    }

    public static Provider<ConfigurationHandler[]> getAPMConfigurationHandlersProvider() {
        return new APMConfigurationHandlersProvider();
    }

    public static Provider<SessionModelFiller[]> getSessionModelsFillerProvider() {
        return new SessionModelFillersProvider();
    }

    public static Class<?> getServiceLocatorLock() {
        return ServiceLocator.class;
    }

    public static ParameterizedFactory<W3CExternalNetworkTraceIdInfo, String> getExternalNetworkTraceIdFactory(){
        if (ExternalNetworkTraceIdFactory == null)
            synchronized (ServiceLocator.class) {
                if (ExternalNetworkTraceIdFactory == null)
                    ExternalNetworkTraceIdFactory = new W3CExternalNetworkTraceIdFactory(
                            getApmConfigurationProvider(),
                            new W3CFormatProvider(new TimestampProviderSeconds(), new RandomUIntProvider())
                    );
            }
        return ExternalNetworkTraceIdFactory;
    }

    // WebViewTraces

    @Nullable
    public static WebViewTraceConfigurationProvider getWebViewTraceConfigurationProvider() {
        if (webViewTraceConfigurationProvider != null) {
            return webViewTraceConfigurationProvider;
        }
        synchronized (ServiceLocator.class) {
            if (webViewTraceConfigurationProvider != null) {
                return webViewTraceConfigurationProvider;
            }
            webViewTraceConfigurationProvider = createWebViewTraceConfigurationProvider();
            return webViewTraceConfigurationProvider;
        }
    }

    @Nullable
    private static WebViewTraceConfigurationProvider createWebViewTraceConfigurationProvider() {
        APMConfigurationProvider localApmConfigurationProvider = getApmConfigurationProvider();
        APMPreferencePropertyFactory apmPreferencePropertyFactory = getAPMPreferencePropertyFactory();
        LimitConstraintApplier limitConstraintApplier = getLimitConstraintApplier();
        if (apmPreferencePropertyFactory != null && localApmConfigurationProvider != null) {
            return new WebViewTraceConfigurationProviderImpl(
                    localApmConfigurationProvider,
                    limitConstraintApplier,
                    apmPreferencePropertyFactory
            );
        }
        return null;
    }

    @Nullable
    public static ConfigurationHandler getWebViewTraceConfigurationHandler() {
        WebViewTraceConfigurationProvider configurationProvider = getWebViewTraceConfigurationProvider();
        if (configurationProvider != null) {
            return new WebViewTraceConfigurationHandler(configurationProvider);
        } else {
            return null;
        }
    }

    @Nullable
    public static APMWebViewTraceCacheHandler getWebViewTraceCacheHandler() {
        if (unbox(webViewTraceCacheHandler) == null) {
            synchronized (ServiceLocator.class) {
                if (unbox(webViewTraceCacheHandler) == null) {
                    webViewTraceCacheHandler = createWebViewTraceCacheHandlerWeakReference();
                }
            }
        }
        return unbox(webViewTraceCacheHandler);
    }

    @Nullable
    private static WeakReference<APMWebViewTraceCacheHandler> createWebViewTraceCacheHandlerWeakReference() {
        DatabaseManager dbManager = getDatabaseManager();
        return dbManager == null ? null : new WeakReference<>(
                new APMWebViewTraceCacheHandlerImpl(dbManager, getApmLogger())
        );
    }

    @Nullable
    public static WebViewTraceHandler getWebViewTraceHandler() {
        if (unbox(webViewTraceHandler) == null) {
            synchronized (ServiceLocator.class) {
                if (unbox(webViewTraceHandler) == null) {
                    webViewTraceHandler = createWebViewTraceHandlerWeakReference();
                }
            }
        }
        return unbox(webViewTraceHandler);
    }

    @Nullable
    private static WeakReference<WebViewTraceHandler> createWebViewTraceHandlerWeakReference() {
        APMWebViewTraceCacheHandler cacheHandler = getWebViewTraceCacheHandler();
        SessionMetaDataCacheHandler metaDataCacheHandler = getSessionMetaDataCacheHandler();
        WebViewTraceConfigurationProvider configs = getWebViewTraceConfigurationProvider();
        if (cacheHandler == null || metaDataCacheHandler == null || configs == null) return null;
        return new WeakReference<>(new WebViewTraceHandlerImpl(
                cacheHandler,
                metaDataCacheHandler,
                configs,
                getApmLogger()
        ));
    }

    @Nullable
    public static WebViewTraceManager getWebViewTraceManager() {
        if (webViewTraceManager == null) {
            synchronized (ServiceLocator.class) {
                if (webViewTraceManager == null) {
                    webViewTraceManager = createWebViewTraceManager();
                }
            }
        }
        return webViewTraceManager;
    }

    @Nullable
    private static WebViewTraceManager createWebViewTraceManager() {
        WebViewTraceConfigurationProvider webViewTraceConfigurations = getWebViewTraceConfigurationProvider();
        APMConfigurationProvider apmConfigurations = getApmConfigurationProvider();
        if (webViewTraceConfigurations != null && apmConfigurations != null) {
            Provider<WebViewTraceHandler> handlerProvider = ServiceLocator::getWebViewTraceHandler;
            Provider<Logger> loggerProvider = ServiceLocator::getApmLogger;
            return new WebViewTraceManagerImpl(
                    webViewTraceConfigurations,
                    apmConfigurations,
                    handlerProvider,
                    loggerProvider,
                    getWebViewExecutor()
            );
        }
        return null;
    }

    public static Executor getWebViewExecutor() {
        return new OrderedExecutor(
                WebViewEventExecutorId,
                PoolProvider.getInstance().getOrderedExecutor()
        );
    }

    @Nullable
    private static <T> T unbox(@Nullable WeakReference<T> reference) {
        return reference != null ? reference.get() : null;
    }

    @Nullable
    public static Provider<DisplayMetrics> getAppWindowDeviceMetricProvider() {
        Context context = getContext();
        if (context != null) {
            return () -> DeviceStateProvider.getDisplayMetrics(context);
        }
        return null;
    }

    @Nullable
    public static WebViewSizeEventResolver getWebViewSizeEventResolver() {
        if (unbox(webViewSizeEventResolverWaekReference) == null) {
            synchronized (ServiceLocator.class) {
                if (unbox(webViewSizeEventResolverWaekReference) == null) {
                    webViewSizeEventResolverWaekReference = createWebViewSizeEventResolverWeakReference();
                }
            }
        }
        return unbox(webViewSizeEventResolverWaekReference);
    }

    @Nullable
    private static WeakReference<WebViewSizeEventResolver> createWebViewSizeEventResolverWeakReference() {
        Provider<DisplayMetrics> displayMetricsProvider = getAppWindowDeviceMetricProvider();
        WebViewTraceConfigurationProvider configurations = getWebViewTraceConfigurationProvider();
        return displayMetricsProvider != null && configurations != null
                ? new WeakReference<>(new WebViewSizeEventResolver(displayMetricsProvider, configurations))
                : null;
    }

    @Nullable
    public static WebViewEventFlow getWebViewTimeThresholdFLow() {
        WebViewTraceConfigurationProvider configurations = getWebViewTraceConfigurationProvider();
        if (configurations != null) {
            return new WebViewTimeThresholdFlow(configurations);
        }
        return null;
    }

    public static WebViewEventFlow getWebViewNewTraceFlow() {
        return new WebViewNewTraceFlow();
    }

    public static WebViewEventFlow getWebViewVitalCapturingFlow() {
        return new WebViewVitalCapturingFlow();
    }

    public static Provider<WebViewTraceModelWrapper> getWebViewTraceModelWrapperProvider() {
        return () -> {
            WebViewEventFlow webViewTimeThresholdFLow = getWebViewTimeThresholdFLow();
            if (webViewTimeThresholdFLow != null) {
                WebViewEventFlow webViewVitalCapturingFlow = getWebViewVitalCapturingFlow();
                ArrayList<WebViewEventFlow> flows = new ArrayList<>();
                flows.add(webViewTimeThresholdFLow);
                flows.add(getWebViewNewTraceFlow());
                flows.add(webViewVitalCapturingFlow);
                WebViewCompositeFlow compositeFLow = new WebViewCompositeFlow(flows);
                return new WebViewTraceModelWrapper(
                        compositeFLow,
                        webViewVitalCapturingFlow
                );
            }
            return null;
        };
    }

    @Nullable
    public static WebViewTraceRepository getWebViewTraceRepository() {
        WebViewTraceConfigurationProvider configurations = getWebViewTraceConfigurationProvider();
        WebViewTraceHandler handler = getWebViewTraceHandler();
        if (configurations != null
                && handler != null
        ) {
            return new WebViewTraceRepositoryImpl(
                    configurations,
                    handler,
                    getWebViewTraceModelWrapperProvider(),
                    getWebViewTraceModelToCacheMapper(),
                    new HashMap<>()
            );
        }
        return null;
    }

    public static Mapper<Map<String, Double>, String> getWebViewVitalsToJsonStringMapper() {
        return WebViewVitalsToJsonStringMapper.create();
    }

    public static Mapper<WebViewTraceModel, WebViewCacheModel> getWebViewTraceModelToCacheMapper() {
        return new WebViewTraceModelToCacheModelMapper(getWebViewVitalsToJsonStringMapper());
    }

    public static InstabugWebViewVitalJSInterface getInstabugWebViewVitalJSInterface() {
        return new InstabugWebViewVitalJSInterface();
    }

    private static ParameterizedFactory<InstabugWebVitalsEventListener, Long> getWebViewTraceVitalListenerFactory(
            WebViewTraceRepository repository
    ) {
        return new WebViewTraceVitalListenerFactory(repository, getWebViewExecutor());
    }

    @SuppressLint("NewApi")
    @Nullable
    public static WebViewTraceEventListener getWebViewTraceEventListener(Long uiTraceId) {
        if (DeviceStateProvider.getOSVersion() >= Build.VERSION_CODES.O) {
            WebViewTraceRepository repository = getWebViewTraceRepository();
            WebViewSizeEventResolver sizeResolver = getWebViewSizeEventResolver();
            if (repository != null && sizeResolver != null) {
                return new WebViewTraceEventListenerImpl(
                        uiTraceId,
                        repository,
                        sizeResolver,
                        getInstabugWebViewVitalJSInterface(),
                        getWebViewTraceVitalListenerFactory(repository),
                        getWebViewExecutor(),
                        PoolProvider.getInstance().getMainThreadExecutor(),
                        getWebViewTraceUrlSanitizer()
                );
            }
        }
        return null;
    }

    private static WebViewTraceUrlSanitizer getWebViewTraceUrlSanitizer() {
        return new WebViewTraceUrlSanitizerImpl();
    }

    public static ParameterizedFactory<WebViewTraceEventListener, Long> getWebViewTraceEventListenerFactory() {
        return ServiceLocator::getWebViewTraceEventListener;
    }

    public static SpanIDProvider getAppLaunchIdProvider() {
        return AppLaunchIDProvider.INSTANCE;
    }

    public static Executor getOrderedExecutor(String executorId) {
        return new OrderedExecutor(
                executorId,
                PoolProvider.getInstance().getOrderedExecutor()
        );
    }

    @NonNull
    public static AppStateEventDispatcher getAppStateEventDispatcher() {
        AppStateEventDispatcher localDispatcher = appStateEventDispatcher;
        if (localDispatcher == null) {
            synchronized (ServiceLocator.class) {
                localDispatcher = appStateEventDispatcher;
                if (localDispatcher == null) {
                    localDispatcher = new AppStateEventDispatcher(getOrderedExecutor(APP_STATE_DISPATCHER_EXECUTOR_ID));
                    appStateEventDispatcher = localDispatcher;
                    return localDispatcher;
                }
            }
        }
        return localDispatcher;
    }

    @NonNull
    public static APMSessionLazyDataProvider getAPMSessionLazyDataProvider() {
        APMSessionLazyDataProvider localLazySessionDataProvider = apmSessionLazyDataProvider;
        if (localLazySessionDataProvider == null) {
            synchronized (ServiceLocator.class) {
                localLazySessionDataProvider = apmSessionLazyDataProvider;
                if (localLazySessionDataProvider == null) {
                    localLazySessionDataProvider = new APMSessionLazyDataProvider();
                    apmSessionLazyDataProvider = localLazySessionDataProvider;
                }
            }
        }
        return localLazySessionDataProvider;
    }

    @NonNull
    public static APMV3SessionSyncNotifier getAPMV3SessionSyncNotifier() {
        APMV3SessionSyncNotifier notifier = unbox(apmv3SessionSyncNotifierWeakReference);
        if (notifier == null) {
            synchronized (ServiceLocator.class) {
                notifier = unbox(apmv3SessionSyncNotifierWeakReference);
                if (notifier == null) {
                    notifier = new APMV3SessionSyncNotifierImpl();
                    apmv3SessionSyncNotifierWeakReference = new WeakReference<>(notifier);
                }
            }
        }
        return notifier;
    }

    @NonNull
    public static Provider<APMSessionReadinessManager[]> getAPMSessionReadinessManagersProvider() {
        return new APMSessionReadinessManagersProvider();
    }

    public static IBGNetworkInterceptionConfigurationProvider getCoreNetworkInterceptionConfigurationProvider() {
        return NetworkInterceptionServiceLocator.getConfigurationProvider();
    }
}
