package com.instabug.apm.configuration;

import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;

import java.util.Map;

public class APMPerSessionConfigurationProviderImpl implements APMPerSessionConfigurationProvider {

    private Map<String, Object> configurationMap = new ArrayMap<>();

    @Override
    public void putConfiguration(String key, Object value) {
        configurationMap.put(key, value);
    }

    @Override
    public Object getConfiguration(String key, Object defValue) {
        Object returnedValue = configurationMap.get(key);

        if (returnedValue != null && returnedValue.getClass().isInstance(defValue)) {
            return returnedValue;
        }
        return defValue;
    }

    @Override
    @Nullable
    public Object getConfiguration(String key) {
        return configurationMap.get(key);
    }
}
