package com.instabug.apm.cache.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.constants.UiLoadingLaunches;
import com.instabug.apm.constants.UiLoadingMetric.Stages;

import java.util.HashMap;
import java.util.Map;

public class UiLoadingModel {

    private long id;
    private long durationInMicro = -1;
    private long startTimeStampMicro = -1;
    @Nullable
    private Map<String, Long> stages;

    @UiLoadingLaunches
    private String type;

    public UiLoadingModel() {
        type = UiLoadingLaunches.COLD;
        stages = new HashMap<>();
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getDurationInMicro() {
        return durationInMicro;
    }

    public void setDurationInMicro(long durationInMicro) {
        this.durationInMicro = durationInMicro;
    }

    public long getStartTimeStampMicro() {
        return startTimeStampMicro;
    }

    public void setStartTimeStampMicro(long startTimeStampMicro) {
        this.startTimeStampMicro = startTimeStampMicro;
    }

    @Nullable
    public Map<String, Long> getStages() {
        return stages;
    }

    public void setStages(@Nullable Map<String, Long> stages) {
        this.stages = stages;
    }

    public void addStage(@NonNull @Stages String stageName, Long durationInMicro) {
        if (stages != null) {
            stages.put(stageName, durationInMicro);
        }
    }

    @UiLoadingLaunches
    public String getType() {
        return type;
    }

    public void setType(@UiLoadingLaunches String type) {
        this.type = type;
    }

    public boolean isValid() {
        return durationInMicro > 0 && startTimeStampMicro > 0;
    }
}
