package com.instabug.apm.cache.handler.executiontraces;

import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;

import com.instabug.library.model.common.Session;

public interface ExecutionTracesMigrationHandler {

    /**
     * Associates dangling traces to the appropriate session
     *
     * @param runningSession the currently active session
     * @param lastSession    the most recent ended session
     */
    @WorkerThread
    void migrate(@NonNull Session runningSession, @NonNull Session lastSession);
}
