/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networkinterception;

import androidx.annotation.VisibleForTesting;
import com.instabug.apm.APMPlugin;
import com.instabug.apm.attributes.listeners.OnNetworkTraceListener;
import com.instabug.apm.di.d;
import com.instabug.apm.logger.APMLogger;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.apm.model.DefaultAPMNetworkLog;
import com.instabug.apm.model.NetworkTrace;
import com.instabug.apm.networkinterception.external_network_trace.a;
import com.instabug.apm.sanitization.Sanitizer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class APMNetworkLogWrapper
implements APMNetworkLog {
    @NotNull
    private final APMNetworkLog networkLog;
    private boolean addedAttributes;
    @Nullable
    private Long startTimeInMillis;

    public APMNetworkLogWrapper(@NotNull APMNetworkLog aPMNetworkLog) {
        Intrinsics.checkNotNullParameter((Object)aPMNetworkLog, (String)"networkLog");
        this.networkLog = aPMNetworkLog;
        d.a(() -> APMNetworkLogWrapper._init_$lambda-0(this));
    }

    public /* synthetic */ APMNetworkLogWrapper(APMNetworkLog aPMNetworkLog, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            DefaultAPMNetworkLog defaultAPMNetworkLog;
            aPMNetworkLog = defaultAPMNetworkLog;
            defaultAPMNetworkLog = new DefaultAPMNetworkLog();
        }
        this(aPMNetworkLog);
    }

    private final Long getStartTimeInMillis() {
        if (this.startTimeInMillis == null) {
            Long l2 = this.getStartTime();
            l2 = l2 == null ? null : Long.valueOf(TimeUnit.MICROSECONDS.toMillis(l2));
            this.startTimeInMillis = l2;
        }
        return this.startTimeInMillis;
    }

    private final void populateNetworkLog(APMNetworkLog aPMNetworkLog) {
        APMNetworkLog aPMNetworkLog2 = aPMNetworkLog;
        ((APMNetworkLogWrapper)((Object)string)).updateSessionIdIfPossible();
        aPMNetworkLog2.setRadio(com.instabug.apm.util.connection.a.b());
        aPMNetworkLog2.setCarrier(com.instabug.apm.util.connection.a.a());
        String string = aPMNetworkLog2.getSessionId();
        boolean bl = string == null || StringsKt.isBlank((CharSequence)string);
        aPMNetworkLog.setExecutedInBackground(bl);
    }

    private final void updateSessionIdIfPossible() {
        Object object = this.getSessionId();
        boolean bl = object == null || StringsKt.isBlank((CharSequence)object);
        if (bl) {
            object = d.l0();
            object = object == null ? null : object.b();
            object = object == null ? null : object.getId();
            this.setSessionId((String)object);
        }
    }

    private final void insertOrUpdate(Exception exception, com.instabug.apm.handler.networklog.a a2) {
        APMNetworkLogWrapper aPMNetworkLogWrapper = this;
        aPMNetworkLogWrapper.applyExternalTraceIdConstraints();
        if (aPMNetworkLogWrapper.getId() == -1L) {
            APMNetworkLogWrapper aPMNetworkLogWrapper2 = this;
            aPMNetworkLogWrapper2.updateSessionIdIfPossible();
            this.setId(a2.b(aPMNetworkLogWrapper2.networkLog));
        } else {
            a2.a(this.networkLog);
            APMLogger.d(this.getLogMessage(exception, a2));
        }
    }

    private final void applyExternalTraceIdConstraints() {
        String string = this.getErrorMessage();
        if (!(string == null || StringsKt.isBlank((CharSequence)string))) {
            APMNetworkLogWrapper aPMNetworkLogWrapper = this;
            aPMNetworkLogWrapper.setExternalTraceId(null);
            aPMNetworkLogWrapper.setExternalTraceStartTimestampMillis(null);
        } else if (Intrinsics.areEqual((Object)this.getExternalTraceStartTimestampMillis(), (Object)this.getStartTimeInMillis())) {
            this.setExternalTraceStartTimestampMillis(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean skipAddingAttribute(OnNetworkTraceListener object, Map<String, String> map) {
        boolean bl;
        if (this.getUrl() == null) return true;
        if ((object = ((OnNetworkTraceListener)object).getPredicate()) == null) {
            bl = false;
        } else {
            String string = this.getUrl();
            Intrinsics.checkNotNull((Object)string);
            bl = object.check(string) ^ true;
        }
        if (bl) return true;
        if (map != null) return false;
        return true;
    }

    private final void addSingleAttribute(String string, String string2, String string3, com.instabug.apm.handler.networklog.a a2) {
        if (!a2.a(string, string2, string3)) {
            return;
        }
        String string4 = string2;
        Intrinsics.checkNotNull((Object)string4);
        string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        string3 = string3 == null ? null : ((Object)StringsKt.trim((CharSequence)string3)).toString();
        APMNetworkLogWrapper aPMNetworkLogWrapper = this;
        long l2 = aPMNetworkLogWrapper.getId();
        boolean bl = aPMNetworkLogWrapper.getExecutedInBackground();
        a2.a(l2, string, bl, string2, string3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final String getLogMessage(final Exception exception, com.instabug.apm.handler.networklog.a a2) {
        Function1 function1;
        String string;
        void var2_4;
        Object object;
        if (exception == null) {
            object = this.getErrorMessage();
            boolean bl = object == null || object.length() == 0;
            if (bl) {
                Function1 function12;
                if (this.getResponseCode() >= 400) {
                    Function1 function13;
                    Function1 function14 = function13;
                    function13 = new Function1(){

                        @NotNull
                        public final String a(@NotNull String string) {
                            Intrinsics.checkNotNullParameter((Object)string, (String)"$this$prepareLogMessage");
                            return StringsKt.replace$default((String)string, (String)"$code", (String)String.valueOf(this.getResponseCode()), (boolean)false, (int)4, null);
                        }
                    };
                    string = this.prepareLogMessage("Request [$method] $url has failed after $duration ms status code $code.\nAttributes: $attr", (com.instabug.apm.handler.networklog.a)var2_4, (Function1<? super String, String>)function14);
                    return string;
                }
                Function1 function15 = function12;
                function12 = new Function1(){

                    @NotNull
                    public final String a(@NotNull String string) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"$this$prepareLogMessage");
                        return StringsKt.replace$default((String)string, (String)"$code", (String)String.valueOf(this.getResponseCode()), (boolean)false, (int)4, null);
                    }
                };
                string = this.prepareLogMessage("Request [$method] $url has succeeded.\nTotal duration: $duration ms\nStatus code: $code.\nAttributes: $attr", (com.instabug.apm.handler.networklog.a)var2_4, (Function1<? super String, String>)function15);
                return string;
            }
        }
        object = function1;
        function1 = new Function1(){

            @NotNull
            public final String a(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"$this$prepareLogMessage");
                String string2 = "$error";
                Object object = exception;
                object = object == null ? null : ((Throwable)object).toString();
                if (object == null) {
                    object = this.getErrorMessage();
                    Intrinsics.checkNotNull((Object)object);
                }
                return StringsKt.replace$default((String)string, (String)string2, (String)object, (boolean)false, (int)4, null);
            }
        };
        string = this.prepareLogMessage("Request [$method] $url has failed after $duration ms due to $error..\nAttributes: $attr", (com.instabug.apm.handler.networklog.a)var2_4, (Function1<? super String, String>)object);
        return string;
    }

    private final String prepareLogMessage(String string, com.instabug.apm.handler.networklog.a a2, Function1<? super String, String> object) {
        string = StringsKt.replace$default((String)string, (String)"$method", (String)String.valueOf(((APMNetworkLogWrapper)object2).getMethod()), (boolean)false, (int)4, null);
        String string2 = "$url";
        String string3 = ((APMNetworkLogWrapper)object2).getUrl();
        if (string3 == null) {
            string3 = "";
        }
        com.instabug.apm.handler.networklog.a a3 = a2;
        APMNetworkLogWrapper aPMNetworkLogWrapper = object2;
        Object object2 = (String)object.invoke((Object)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null), (String)"$duration", (String)String.valueOf(((APMNetworkLogWrapper)object2).getTotalDuration()), (boolean)false, (int)4, null));
        string = "$attr";
        object = a3.a(aPMNetworkLogWrapper.getId());
        if (object == null) {
            LinkedHashMap linkedHashMap;
            object = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
        }
        Object object3 = object2;
        com.instabug.apm.handler.networklog.a a4 = a2;
        a4((Map)object);
        object2 = a4.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"JSONObject(\n            \u2026             ).toString()");
        return StringsKt.replace$default((String)object3, (String)string, (String)object2, (boolean)false, (int)4, null);
    }

    private static final void _init_$lambda-0(APMNetworkLogWrapper aPMNetworkLogWrapper) {
        APMNetworkLogWrapper aPMNetworkLogWrapper2 = aPMNetworkLogWrapper;
        Intrinsics.checkNotNullParameter((Object)aPMNetworkLogWrapper2, (String)"this$0");
        aPMNetworkLogWrapper2.populateNetworkLog(aPMNetworkLogWrapper2.networkLog);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void insert$lambda-3(Sanitizer object, APMNetworkLogWrapper aPMNetworkLogWrapper, Exception object2) {
        APMNetworkLogWrapper aPMNetworkLogWrapper2 = aPMNetworkLogWrapper;
        Object object3 = object2;
        Object object4 = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"$sanitizer");
        Intrinsics.checkNotNullParameter((Object)aPMNetworkLogWrapper, (String)"this$0");
        object = APMPlugin.lock;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lock");
        synchronized (object) {
            object2 = d.a((Sanitizer)object4);
            {
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"handler");
                aPMNetworkLogWrapper2.insertOrUpdate((Exception)object3, (com.instabug.apm.handler.networklog.a)object2);
                if (!aPMNetworkLogWrapper2.addedAttributes) {
                    aPMNetworkLogWrapper.addAttributes(d.d0(), (com.instabug.apm.handler.networklog.a)object2);
                }
                Object object5 = object;
            }
            // ** MonitorExit[v4] (shouldn't be in output)
            return;
        }
    }

    public APMNetworkLogWrapper() {
        this(null, 1, null);
    }

    @Override
    @Nullable
    public Map<String, String> getAttributes() {
        return this.networkLog.getAttributes();
    }

    @Override
    public void setAttributes(@Nullable Map<String, String> map) {
        this.networkLog.setAttributes(map);
    }

    @Override
    @Nullable
    public String getCarrier() {
        return this.networkLog.getCarrier();
    }

    @Override
    public void setCarrier(@Nullable String string) {
        this.networkLog.setCarrier(string);
    }

    @Override
    public int getClientErrorCode() {
        return this.networkLog.getClientErrorCode();
    }

    @Override
    public void setClientErrorCode(int n2) {
        this.networkLog.setClientErrorCode(n2);
    }

    @Override
    @Nullable
    public String getErrorMessage() {
        return this.networkLog.getErrorMessage();
    }

    @Override
    public void setErrorMessage(@Nullable String string) {
        this.networkLog.setErrorMessage(string);
    }

    @Override
    public boolean getExecutedInBackground() {
        return this.networkLog.getExecutedInBackground();
    }

    @Override
    public void setExecutedInBackground(boolean bl) {
        this.networkLog.setExecutedInBackground(bl);
    }

    @Override
    @Nullable
    public Long getExternalTraceId() {
        return this.networkLog.getExternalTraceId();
    }

    @Override
    public void setExternalTraceId(@Nullable Long l2) {
        this.networkLog.setExternalTraceId(l2);
    }

    @Override
    @Nullable
    public Long getExternalTraceStartTimestampMillis() {
        return this.networkLog.getExternalTraceStartTimestampMillis();
    }

    @Override
    public void setExternalTraceStartTimestampMillis(@Nullable Long l2) {
        this.networkLog.setExternalTraceStartTimestampMillis(l2);
    }

    @Override
    @Nullable
    public String getGraphQlQueryName() {
        return this.networkLog.getGraphQlQueryName();
    }

    @Override
    public void setGraphQlQueryName(@Nullable String string) {
        this.networkLog.setGraphQlQueryName(string);
    }

    @Override
    @Nullable
    public String getGrpcMethodName() {
        return this.networkLog.getGrpcMethodName();
    }

    @Override
    public void setGrpcMethodName(@Nullable String string) {
        this.networkLog.setGrpcMethodName(string);
    }

    @Override
    public long getId() {
        return this.networkLog.getId();
    }

    @Override
    public void setId(long l2) {
        this.networkLog.setId(l2);
    }

    @Override
    public boolean isModified() {
        return this.networkLog.isModified();
    }

    @Override
    public void setModified(boolean bl) {
        this.networkLog.setModified(bl);
    }

    @Override
    @Nullable
    public String getLatencySpansJsonString() {
        return this.networkLog.getLatencySpansJsonString();
    }

    @Override
    public void setLatencySpansJsonString(@Nullable String string) {
        this.networkLog.setLatencySpansJsonString(string);
    }

    @Override
    @Nullable
    public String getMethod() {
        return this.networkLog.getMethod();
    }

    @Override
    public void setMethod(@Nullable String string) {
        this.networkLog.setMethod(string);
    }

    @Override
    @Nullable
    public String getRadio() {
        return this.networkLog.getRadio();
    }

    @Override
    public void setRadio(@Nullable String string) {
        this.networkLog.setRadio(string);
    }

    @Override
    @Nullable
    public String getRequestBody() {
        return this.networkLog.getRequestBody();
    }

    @Override
    public void setRequestBody(@Nullable String string) {
        this.networkLog.setRequestBody(string);
    }

    @Override
    public long getRequestBodySize() {
        return this.networkLog.getRequestBodySize();
    }

    @Override
    public void setRequestBodySize(long l2) {
        this.networkLog.setRequestBodySize(l2);
    }

    @Override
    @Nullable
    public String getRequestContentType() {
        return this.networkLog.getRequestContentType();
    }

    @Override
    public void setRequestContentType(@Nullable String string) {
        this.networkLog.setRequestContentType(string);
    }

    @Override
    @Nullable
    public String getRequestHeaders() {
        return this.networkLog.getRequestHeaders();
    }

    @Override
    public void setRequestHeaders(@Nullable String string) {
        this.networkLog.setRequestHeaders(string);
    }

    @Override
    @Nullable
    public String getResponseBody() {
        return this.networkLog.getResponseBody();
    }

    @Override
    public void setResponseBody(@Nullable String string) {
        this.networkLog.setResponseBody(string);
    }

    @Override
    public long getResponseBodySize() {
        return this.networkLog.getResponseBodySize();
    }

    @Override
    public void setResponseBodySize(long l2) {
        this.networkLog.setResponseBodySize(l2);
    }

    @Override
    public int getResponseCode() {
        return this.networkLog.getResponseCode();
    }

    @Override
    public void setResponseCode(int n2) {
        this.networkLog.setResponseCode(n2);
    }

    @Override
    @Nullable
    public String getResponseContentType() {
        return this.networkLog.getResponseContentType();
    }

    @Override
    public void setResponseContentType(@Nullable String string) {
        this.networkLog.setResponseContentType(string);
    }

    @Override
    @Nullable
    public String getResponseHeaders() {
        return this.networkLog.getResponseHeaders();
    }

    @Override
    public void setResponseHeaders(@Nullable String string) {
        this.networkLog.setResponseHeaders(string);
    }

    @Override
    @Nullable
    public String getServerSideErrorMessage() {
        return this.networkLog.getServerSideErrorMessage();
    }

    @Override
    public void setServerSideErrorMessage(@Nullable String string) {
        this.networkLog.setServerSideErrorMessage(string);
    }

    @Override
    @Nullable
    public String getSessionId() {
        return this.networkLog.getSessionId();
    }

    @Override
    public void setSessionId(@Nullable String string) {
        this.networkLog.setSessionId(string);
    }

    @Override
    @Nullable
    public Long getStartTime() {
        return this.networkLog.getStartTime();
    }

    @Override
    public void setStartTime(@Nullable Long l2) {
        this.networkLog.setStartTime(l2);
    }

    @Override
    public long getTotalDuration() {
        return this.networkLog.getTotalDuration();
    }

    @Override
    public void setTotalDuration(long l2) {
        this.networkLog.setTotalDuration(l2);
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.networkLog.getUrl();
    }

    @Override
    public void setUrl(@Nullable String string) {
        this.networkLog.setUrl(string);
    }

    @Override
    public boolean isValid() {
        return this.networkLog.isValid();
    }

    public final void insert(@Nullable Exception exception, @NotNull Sanitizer<APMNetworkLog> sanitizer) {
        Intrinsics.checkNotNullParameter(sanitizer, (String)"sanitizer");
        if (!this.isValid()) {
            return;
        }
        d.a(() -> APMNetworkLogWrapper.insert$lambda-3(sanitizer, this, exception));
    }

    @VisibleForTesting
    public final void addAttributes(@Nullable com.instabug.apm.handler.attributes.a object, @NotNull com.instabug.apm.handler.networklog.a a2) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"networkLogHandler");
        if (object != null) {
            Object object2 = object;
            object = '[' + this.getMethod() + "] " + this.getUrl();
            NetworkTrace networkTrace = d.b0().a(this.networkLog);
            Object object22 = object2.a();
            if (object22 == null) {
                return;
            }
            object22 = object22.iterator();
            while (object22.hasNext()) {
                OnNetworkTraceListener onNetworkTraceListener = (OnNetworkTraceListener)object22.next();
                Object object3 = onNetworkTraceListener.addAttributesOnFinish(networkTrace);
                Intrinsics.checkNotNullExpressionValue((Object)onNetworkTraceListener, (String)"onNetworkTraceListener");
                if (this.skipAddingAttribute(onNetworkTraceListener, (Map<String, String>)object3)) {
                    object3 = null;
                }
                if (object3 == null) continue;
                for (Map.Entry entry : object3.entrySet()) {
                    String string = (String)entry.getKey();
                    this.addSingleAttribute((String)object, string, (String)entry.getValue(), a2);
                }
            }
        }
        this.addedAttributes = true;
    }

    @NotNull
    public String toString() {
        return this.networkLog.toString();
    }

    @Nullable
    public final Pair<String, String> getInjectableHeader() {
        Pair pair;
        a a2 = (a)d.L().create((Object)this.getStartTimeInMillis());
        if (a2 == null) {
            pair = null;
        } else {
            this.setExternalTraceStartTimestampMillis(a2.c());
            this.setExternalTraceId(a2.d());
            pair = TuplesKt.to((Object)a2.a(), (Object)a2.b());
        }
        return pair;
    }
}

