/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.model;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.cache.model.b;
import com.instabug.apm.configuration.c;
import com.instabug.apm.di.d;
import com.instabug.apm.handler.executiontraces.a;
import com.instabug.library.apichecker.APIChecker;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import org.json.JSONObject;

public class ExecutionTrace
implements Parcelable {
    public static final Parcelable.Creator<ExecutionTrace> CREATOR = new Parcelable.Creator<ExecutionTrace>(){

        public ExecutionTrace a(Parcel parcel) {
            return new ExecutionTrace(parcel);
        }

        public ExecutionTrace[] a(int n2) {
            return new ExecutionTrace[n2];
        }
    };
    private final transient Executor executor;
    private final transient a executionTracesHandler;
    private final transient com.instabug.apm.logger.internal.a apmLogger;
    @NonNull
    private final Map<String, String> attrs;
    private final String name;
    private final long id;
    private boolean startedInBackground;
    private boolean endedInBackground;
    private final long startTime;
    private final long startTimeMicro;
    private long endTimeMicro;
    private boolean isEnded;

    public ExecutionTrace(String string) {
        com.instabug.apm.logger.internal.a a2;
        ExecutionTrace executionTrace = this;
        this.executor = d.b("execution_traces_thread_executor");
        this.executionTracesHandler = d.E();
        this.apmLogger = a2 = d.h();
        this.endTimeMicro = -1L;
        this.isEnded = false;
        this.id = new Random().nextLong();
        this.attrs = new LinkedHashMap<String, String>();
        executionTrace.name = string;
        executionTrace.startTimeMicro = System.nanoTime() / 1000L;
        executionTrace.startTime = System.currentTimeMillis() * 1000L;
        boolean bl = d.l0().b() == null;
        this.startedInBackground = bl;
        a2.d("Execution trace " + string + " has started.");
    }

    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    protected ExecutionTrace(Parcel parcel) {
        this.executor = d.b("execution_traces_thread_executor");
        this.executionTracesHandler = d.E();
        this.apmLogger = d.h();
        this.endTimeMicro = -1L;
        this.isEnded = false;
        this.id = parcel.readLong();
        int n2 = parcel.readInt();
        this.attrs = new LinkedHashMap<String, String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Parcel parcel2 = parcel;
            String string = parcel2.readString();
            String string2 = parcel2.readString();
            this.attrs.put(string, string2);
        }
        this.name = parcel.readString();
        this.startTime = parcel.readLong();
        this.startTimeMicro = parcel.readLong();
        this.endTimeMicro = parcel.readLong();
    }

    private boolean isAttributeValueValid(String string, String string2) {
        if ((string2 = string2.trim()).length() == 0) {
            this.apmLogger.b("Trace attribute \"$s1\" wasn't added to \"$s2\". Trace attribute value can't be empty string.".replace("$s1", string).replace("$s2", this.name));
            return false;
        }
        if (string2.length() > 60) {
            this.apmLogger.b("Trace attribute \"$s1\" wasn't added to \"$s2\" as its value was too long. Please limit trace attribute values to 60 characters.".replace("$s1", string).replace("$s2", this.name));
            return false;
        }
        if (this.isEnded) {
            this.apmLogger.b("Trace attribute \"$s1\" wasn't added to \"$s2\" because attribute was added after the trace had already ended.".replace("$s1", string).replace("$s2", this.name));
            return false;
        }
        return true;
    }

    private boolean isAtrributeKeyValid(String string) {
        if (string != null && !string.trim().isEmpty()) {
            if (string.trim().length() > 30) {
                ((ExecutionTrace)((Object)string2)).apmLogger.b("Trace attribute \"$s1\" wasn't added to \"$s2\" as it was too long. Please limit attribute key names to 30 characters.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string2)).name));
                return false;
            }
            return true;
        }
        String string2 = ((ExecutionTrace)((Object)string2)).name;
        ((ExecutionTrace)((Object)string2)).apmLogger.b("Trace attribute wasn't added to \"$s\". Trace attribute key can't be null or empty string.".replace("$s", string2));
        return false;
    }

    public void end() {
        this.endTimeMicro = System.nanoTime() / 1000L;
        boolean bl = d.l0().b() == null;
        this.endedInBackground = bl;
        APIChecker.checkAndRunInExecutor((String)"ExecutionTrace.end", () -> this.executor.execute(() -> {
            Object object;
            c c2 = d.e();
            if (!c2.U()) {
                object = ((ExecutionTrace)object).name;
                ((ExecutionTrace)object).apmLogger.b("Execution trace \"$s\" wasn't saved. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm".replace("$s", (CharSequence)object));
            } else if (!c2.d0()) {
                object = ((ExecutionTrace)object).name;
                ((ExecutionTrace)object).apmLogger.b("Execution trace \"$s\" wasn't saved as the feature seems to be disabled for your Instabug company account. Please contact support for more information.".replace("$s", (CharSequence)object));
            } else {
                ExecutionTrace executionTrace = object;
                long l2 = executionTrace.endTimeMicro - ((ExecutionTrace)object).startTimeMicro;
                Object object2 = object;
                Object object3 = ((ExecutionTrace)object2).name;
                long l3 = ((ExecutionTrace)object2).id;
                object3 = new b.a((String)object3, l3).b(((ExecutionTrace)object).startedInBackground).a(((ExecutionTrace)object).attrs).a(l2).a(((ExecutionTrace)object).endedInBackground).b(((ExecutionTrace)object).startTime).a(((ExecutionTrace)object).attrs).a();
                executionTrace.executionTracesHandler.a((b)object3);
                executionTrace.apmLogger.d("Execution trace " + ((ExecutionTrace)object).name + " has ended.\nTotal duration: " + l2 + " ms\nAttributes: " + new JSONObject(((ExecutionTrace)object).attrs));
                executionTrace.isEnded = true;
            }
        }));
    }

    @MainThread
    public synchronized void setAttribute(@NonNull String string, @Nullable String string2) {
        this.executor.execute(() -> {
            if (this.isAtrributeKeyValid(string)) {
                String string3 = string.trim();
                if (string2 != null) {
                    if (this.isAttributeValueValid(string3, string2)) {
                        int n2 = d.e().r();
                        if (this.attrs.size() == n2) {
                            this.apmLogger.b("Trace attribute \"$s1\" wasn't added to \"$s2\". Max allowed trace attributes reached. Please note that you can add up to \"$s3\" attributes to the same trace.".replace("$s1", string).replace("$s2", this.name).replace("$s3", n2 + ""));
                        } else {
                            this.attrs.put(string3, string2.trim());
                        }
                    }
                } else {
                    this.attrs.remove(string3);
                }
            }
        });
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeLong(this.id);
        parcel.writeInt(this.attrs.size());
        Iterator<Map.Entry<String, String>> iterator = this.attrs.entrySet().iterator();
        while (iterator.hasNext()) {
            Parcel parcel2 = parcel;
            Map.Entry<String, String> entry = iterator.next();
            parcel2.writeString(entry.getKey());
            parcel2.writeString(entry.getValue());
        }
        parcel.writeString(this.name);
        parcel.writeLong(this.startTime);
        parcel.writeLong(this.startTimeMicro);
        parcel.writeLong(this.endTimeMicro);
    }
}

