/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.model;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.handler.executiontraces.a;
import com.instabug.apm.model.d;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;

public class ExecutionTrace
implements Parcelable {
    public static final Parcelable.Creator<ExecutionTrace> CREATOR = new Parcelable.Creator<ExecutionTrace>(){

        public ExecutionTrace a(Parcel parcel) {
            return new ExecutionTrace(parcel);
        }

        public ExecutionTrace[] a(int n2) {
            return new ExecutionTrace[n2];
        }
    };
    private final transient Executor executor;
    private final transient a executionTracesHandler;
    private final transient com.instabug.apm.logger.internal.a apmLogger;
    private final Map<String, String> attrs;
    private final String name;
    private final long id;
    private long startTime;
    private long startTimeMicro;
    private long endTimeMicro;
    private Random randomSeed;

    public ExecutionTrace(String string) {
        Random random;
        Executor executor = com.instabug.apm.di.a.b("execution_traces_thread_executor");
        ExecutionTrace executionTrace = random2;
        ExecutionTrace executionTrace2 = random2;
        ExecutionTrace executionTrace3 = random2;
        executionTrace3.executor = executor;
        executionTrace3.executionTracesHandler = com.instabug.apm.di.a.z();
        executionTrace3.apmLogger = com.instabug.apm.di.a.g();
        executionTrace3.endTimeMicro = -1L;
        Random random2 = random;
        executionTrace3.randomSeed = new Random();
        executionTrace3.id = random2.nextLong();
        executionTrace3.startTime = System.currentTimeMillis() * 1000L;
        executionTrace3.startTimeMicro = System.nanoTime() / 1000L;
        executionTrace2.name = string;
        executionTrace2.attrs = new HashMap<String, String>();
        executor.execute(() -> {
            ExecutionTrace executionTrace = this;
            ExecutionTrace executionTrace2 = this;
            long l2 = executionTrace2.id;
            long l3 = executionTrace2.startTime;
            executionTrace.executionTracesHandler.a(l2, string, l3);
            executionTrace.apmLogger.d("Execution trace " + string + " has started.");
        });
    }

    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    protected ExecutionTrace(Parcel parcel) {
        this.executor = com.instabug.apm.di.a.b("execution_traces_thread_executor");
        this.executionTracesHandler = com.instabug.apm.di.a.z();
        this.apmLogger = com.instabug.apm.di.a.g();
        this.endTimeMicro = -1L;
        this.randomSeed = new Random();
        this.id = parcel.readLong();
        int n2 = parcel.readInt();
        this.attrs = new HashMap<String, String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Parcel parcel2 = parcel;
            String string = parcel2.readString();
            String string2 = parcel2.readString();
            this.attrs.put(string, string2);
        }
        this.name = parcel.readString();
        this.startTime = parcel.readLong();
        this.startTimeMicro = parcel.readLong();
        this.endTimeMicro = parcel.readLong();
    }

    static /* synthetic */ long access$002(ExecutionTrace executionTrace, long l2) {
        executionTrace.endTimeMicro = l2;
        return l2;
    }

    static /* synthetic */ long access$000(ExecutionTrace executionTrace) {
        return executionTrace.endTimeMicro;
    }

    static /* synthetic */ long access$100(ExecutionTrace executionTrace) {
        return executionTrace.startTimeMicro;
    }

    static /* synthetic */ Map access$500(ExecutionTrace executionTrace) {
        return executionTrace.attrs;
    }

    static /* synthetic */ com.instabug.apm.logger.internal.a access$600(ExecutionTrace executionTrace) {
        return executionTrace.apmLogger;
    }

    public void end() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                b b2 = this;
                ExecutionTrace.access$002(b2.ExecutionTrace.this, System.nanoTime() / 1000L);
                b2.ExecutionTrace.this.executor.execute(new d(this));
            }
        };
        APIChecker.checkAndRunInExecutor((String)"ExecutionTrace.end", (VoidRunnable)voidRunnable2);
    }

    public void setAttribute(@NonNull String string, final @Nullable String string2) {
        if (string != null && !string.trim().isEmpty()) {
            final String string3 = string.trim();
            if (string3.length() > 30) {
                ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\" as it was too long. Please limit attribute key names to 30 characters.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string6)).name));
                return;
            }
            if (string2 != null) {
                String string4 = string2.trim();
                if (string4.length() == 0) {
                    ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\". Trace attribute value can't be empty string.".replace("$s1", string3).replace("$s2", ((ExecutionTrace)((Object)string6)).name));
                    return;
                }
                if (string4.length() > 60) {
                    ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\" as its value was too long. Please limit trace attribute values to 60 characters.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string6)).name));
                    return;
                }
            }
            if (((ExecutionTrace)((Object)string6)).endTimeMicro != -1L) {
                ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\" because attribute was added after the trace had already ended.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string6)).name));
                return;
            }
            string = string2 == null ? null : string2.trim();
            String string5 = string6;
            ((ExecutionTrace)((Object)string5)).attrs.put(string3, string);
            ((ExecutionTrace)((Object)string5)).executor.execute(new Runnable(){

                @Override
                public void run() {
                    c c2 = a2;
                    a a2 = c2.ExecutionTrace.this.executionTracesHandler;
                    long l2 = c2.ExecutionTrace.this.id;
                    String string = c2.ExecutionTrace.this.name;
                    String string22 = c2.string3;
                    String string32 = c2.string2;
                    string32 = string32 == null ? null : string32.trim();
                    a2.a(l2, string, string22, string32);
                }
            });
            return;
        }
        String string6 = ((ExecutionTrace)((Object)string6)).name;
        ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute wasn't added to \"$s\". Trace attribute key can't be null or empty string.".replace("$s", string6));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeLong(this.id);
        parcel.writeInt(this.attrs.size());
        Iterator<Map.Entry<String, String>> iterator = this.attrs.entrySet().iterator();
        while (iterator.hasNext()) {
            Parcel parcel2 = parcel;
            Map.Entry<String, String> entry = iterator.next();
            parcel2.writeString(entry.getKey());
            parcel2.writeString(entry.getValue());
        }
        parcel.writeString(this.name);
        parcel.writeLong(this.startTime);
        parcel.writeLong(this.startTimeMicro);
        parcel.writeLong(this.endTimeMicro);
    }

    @VisibleForTesting
    long getId() {
        return this.id;
    }
}

