/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.apm.handler.session.b;
import com.instabug.apm.handler.session.c;
import com.instabug.apm.handler.session.e;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.InstabugStateEventBus;
import com.instabug.library.core.eventbus.NDKSessionCrashedEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventSubscriber;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.model.common.Session;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class APMPlugin
extends Plugin
implements com.instabug.apm.handler.session.a {
    public static final Object lock = new Object();
    private boolean isFirstLaunch = false;
    private final c sessionHandler = com.instabug.apm.di.a.O();
    private final com.instabug.apm.logger.internal.a apmLogger = com.instabug.apm.di.a.g();
    @Nullable
    private CompositeDisposable sdkCoreEventsSubscriberDisposable;

    private void registerSessionCrashHandler() {
        if (com.instabug.apm.di.a.d().S() && !(Thread.getDefaultUncaughtExceptionHandler() instanceof b)) {
            InstabugSDKLogger.d((String)"IBG-APM", (String)"setting Uncaught Exception Handler APMUncaughtExceptionHandler");
            Thread.setDefaultUncaughtExceptionHandler(new b());
        }
    }

    private void subscribeToSDKState() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        this.sdkCoreEventsSubscriberDisposable.add(InstabugStateEventBus.getInstance().getEventObservable().subscribe((Consumer)new Consumer<InstabugState>(){

            public void a(InstabugState instabugState) {
                if (instabugState == InstabugState.DISABLED) {
                    a a2 = this;
                    a2.APMPlugin.this.apmLogger.d("Instabug is disabled, purging APM data\u2026");
                    a2.APMPlugin.this.stopRunningMetrics();
                    a2.APMPlugin.this.endSession();
                    a2.APMPlugin.this.purgeData();
                }
            }
        }));
    }

    private void purgeData() {
        com.instabug.apm.di.a.d().m(-1L);
        final com.instabug.apm.sync.a a2 = com.instabug.apm.di.a.j();
        final boolean bl = a2.b();
        com.instabug.apm.di.a.b("session_purging_thread_executor").execute(new Runnable(this){

            @Override
            public void run() {
                a2.a(bl);
            }
        });
    }

    private void stopRunningMetrics() {
        com.instabug.apm.di.a.z().b();
        com.instabug.apm.di.a.I().b();
        PoolProvider.postMainThreadTask((Runnable)new Runnable(this){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT >= 16) {
                    com.instabug.apm.di.a.b0().f();
                    com.instabug.apm.di.a.r().b();
                }
            }
        });
    }

    private void clearInvalidCache() {
        final com.instabug.apm.handler.executiontraces.a a2 = com.instabug.apm.di.a.z();
        final com.instabug.apm.handler.networklog.a a3 = com.instabug.apm.di.a.I();
        com.instabug.apm.di.a.b("execution_traces_thread_executor").execute(new Runnable(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    a2.c();
                    return;
                }
            }
        });
        com.instabug.apm.di.a.b("network_log_thread_executor").execute(new Runnable(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (com.instabug.apm.di.a.d().p()) {
                    Object object = lock;
                    synchronized (object) {
                        a3.c();
                    }
                }
            }
        });
    }

    private void registerConfigurationChange() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        APMPlugin aPMPlugin = this;
        aPMPlugin.sdkCoreEventsSubscriberDisposable.add(SDKCoreEventSubscriber.subscribe((Consumer)new Consumer<SDKCoreEvent>(){

            @SuppressLint(value={"NULL_DEREFERENCE"})
            public void a(SDKCoreEvent object) {
                if (object.getType().equals("featuresFetched")) {
                    boolean bl = com.instabug.apm.di.a.c().a(object.getValue());
                    object = com.instabug.apm.di.a.d();
                    if (bl && object.E()) {
                        object = InstabugCore.getRunningSession();
                        if (object != null) {
                            String string = string;
                            e.a(string.APMPlugin.this);
                            string.APMPlugin.this.startSession((Session)object);
                            string.APMPlugin.this.registerSessionCrashHandler();
                        }
                        Object object2 = string;
                        object2.APMPlugin.this.registerActivityLifeCycleCallbacks();
                        object2.APMPlugin.this.registerSessionCrashHandler();
                    }
                } else if (object.getType().equals("cross_platform_state_screen_changed")) {
                    String string = object.getValue();
                    if (string != null) {
                        com.instabug.apm.di.a.c0().a(string);
                    }
                } else if (object.getType().equals("cross_platform_crashed")) {
                    string.APMPlugin.this.updateCurrentSession();
                }
            }
        }));
        aPMPlugin.sdkCoreEventsSubscriberDisposable.add(com.instabug.apm.di.a.N().subscribe((Consumer)new Consumer<NDKSessionCrashedEvent>(){

            public void a(NDKSessionCrashedEvent nDKSessionCrashedEvent) {
                APMPlugin.this.sessionHandler.a(nDKSessionCrashedEvent.getSessionId(), TimeUnit.MILLISECONDS.toMicros(nDKSessionCrashedEvent.getSessionDuration()), 1);
            }
        }));
    }

    private void updateCurrentSession() {
        com.instabug.apm.di.a.U().execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugCore.getRunningSession() != null) {
                    APMPlugin.this.sessionHandler.b(1);
                }
            }
        });
    }

    private void registerActivityLifeCycleCallbacks() {
        Context context;
        com.instabug.apm.configuration.c c2 = com.instabug.apm.di.a.d();
        if (c2.E() && (context = com.instabug.apm.di.a.q()) != null && !com.instabug.apm.lifecycle.a.h()) {
            boolean bl = c2.L() || c2.K();
            com.instabug.apm.lifecycle.a a2 = com.instabug.apm.di.a.a(context, bl, false);
            if (a2 != null) {
                ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)a2);
            }
        }
    }

    private void startSession(@NonNull Session session) {
        this.sessionHandler.a(session);
    }

    private void endSession() {
        this.sessionHandler.b(0);
    }

    public void wake() {
        Session session;
        if (com.instabug.apm.di.a.d().E() && this.isFirstLaunch) {
            this.clearInvalidCache();
            this.isFirstLaunch = false;
        }
        if ((session = InstabugCore.getRunningSession()) != null) {
            APMPlugin aPMPlugin = this;
            e.a(aPMPlugin);
            aPMPlugin.startSession(session);
            aPMPlugin.registerSessionCrashHandler();
        } else {
            this.apmLogger.e("APM session not created. Core session is null");
        }
    }

    public void stop() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable != null && !compositeDisposable.isDisposed()) {
            this.sdkCoreEventsSubscriberDisposable.dispose();
        }
    }

    public void sleep() {
        this.endSession();
    }

    public void start(Context context) {
        APMPlugin aPMPlugin = this;
        aPMPlugin.isFirstLaunch = true;
        aPMPlugin.registerConfigurationChange();
        aPMPlugin.subscribeToSDKState();
        if (Build.VERSION.SDK_INT < 16) {
            this.apmLogger.e("Could not enable Auto UI Trace. Feature is supported on API level 16 and up only.");
        }
    }

    public long getLastActivityTime() {
        return 0L;
    }

    @Override
    @WorkerThread
    public void onNewSessionStarted(@NonNull Session session, @Nullable Session session2) {
        if (session2 != null) {
            com.instabug.apm.di.a.K().a(session, session2);
            com.instabug.apm.di.a.B().a(session, session2);
        }
        com.instabug.apm.di.a.j().a();
    }

    public boolean isFeatureEnabled() {
        return com.instabug.apm.di.a.d().E();
    }
}

