/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.model;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.f1;
import com.instabug.apm.l1;
import com.instabug.apm.x1;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import org.json.JSONObject;

public class ExecutionTrace
implements Parcelable {
    public static final Parcelable.Creator<ExecutionTrace> CREATOR = new Parcelable.Creator<ExecutionTrace>(){

        public ExecutionTrace a(Parcel parcel) {
            return new ExecutionTrace(parcel);
        }

        public ExecutionTrace[] a(int n3) {
            return new ExecutionTrace[n3];
        }
    };
    private final transient Executor executor;
    private final transient f1 executionTracesHandler;
    private final transient l1 apmLogger;
    private final Map<String, String> attrs;
    private final String name;
    private final long id;
    private long startTime;
    private long startTimeMicro;
    private long endTimeMicro;

    public ExecutionTrace(final String string) {
        Executor executor = x1.a("execution_traces_thread_executor");
        ExecutionTrace executionTrace = this;
        ExecutionTrace executionTrace2 = this;
        executionTrace2.executor = executor;
        executionTrace2.executionTracesHandler = x1.x();
        executionTrace2.apmLogger = x1.f();
        executionTrace2.endTimeMicro = -1L;
        executionTrace2.id = new Random().nextLong();
        executionTrace2.startTime = System.currentTimeMillis() * 1000L;
        executionTrace2.startTimeMicro = System.nanoTime() / 1000L;
        executionTrace.name = string;
        executionTrace.attrs = new HashMap<String, String>();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                b b4 = this;
                b b5 = this;
                long l3 = b5.ExecutionTrace.this.id;
                String string2 = b5.string;
                long l4 = l3;
                l3 = ExecutionTrace.this.startTime;
                b4.ExecutionTrace.this.executionTracesHandler.a(l4, string2, l3);
                b4.ExecutionTrace.this.apmLogger.d("Execution trace " + string + " has started.");
            }
        });
    }

    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    protected ExecutionTrace(Parcel parcel) {
        this.executor = x1.a("execution_traces_thread_executor");
        this.executionTracesHandler = x1.x();
        this.apmLogger = x1.f();
        this.endTimeMicro = -1L;
        this.id = parcel.readLong();
        int n3 = parcel.readInt();
        this.attrs = new HashMap<String, String>(n3);
        for (int i3 = 0; i3 < n3; ++i3) {
            Parcel parcel2 = parcel;
            String string = parcel2.readString();
            String string2 = parcel2.readString();
            this.attrs.put(string, string2);
        }
        this.name = parcel.readString();
        this.startTime = parcel.readLong();
        this.startTimeMicro = parcel.readLong();
        this.endTimeMicro = parcel.readLong();
    }

    static /* synthetic */ long access$402(ExecutionTrace executionTrace, long l3) {
        executionTrace.endTimeMicro = l3;
        return l3;
    }

    public void end() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                c c4 = this;
                ExecutionTrace.access$402(c4.ExecutionTrace.this, System.nanoTime() / 1000L);
                c4.ExecutionTrace.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        a a4 = this;
                        long l3 = a4.ExecutionTrace.this.endTimeMicro - ExecutionTrace.this.startTimeMicro;
                        a4.ExecutionTrace.this.executionTracesHandler.a(ExecutionTrace.this.id, l3);
                        a4.ExecutionTrace.this.apmLogger.d("Execution trace " + ExecutionTrace.this.name + " has ended.\nTotal duration: " + l3 + " ms\nAttributes: " + new JSONObject(ExecutionTrace.this.attrs).toString());
                    }
                });
            }
        };
        APIChecker.checkAndRunInExecutor((String)"ExecutionTrace.end", (VoidRunnable)voidRunnable2);
    }

    public void setAttribute(@NonNull String string, final @Nullable String string2) {
        if (string != null && !string.trim().isEmpty()) {
            final String string3 = string.trim();
            if (string3.length() > 30) {
                ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\" as it was too long. Please limit attribute key names to 30 characters.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string6)).name));
                return;
            }
            if (string2 != null) {
                String string4 = string2.trim();
                if (string4.length() == 0) {
                    ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\". Trace attribute value can't be empty string.".replace("$s1", string3).replace("$s2", ((ExecutionTrace)((Object)string6)).name));
                    return;
                }
                if (string4.length() > 60) {
                    ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\" as its value was too long. Please limit trace attribute values to 60 characters.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string6)).name));
                    return;
                }
            }
            if (((ExecutionTrace)((Object)string6)).endTimeMicro != -1L) {
                ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\" because attribute was added after the trace had already ended.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string6)).name));
                return;
            }
            string = string2 == null ? null : string2.trim();
            String string5 = string6;
            ((ExecutionTrace)((Object)string5)).attrs.put(string3, string);
            ((ExecutionTrace)((Object)string5)).executor.execute(new Runnable(){

                @Override
                public void run() {
                    d d4 = f12;
                    f1 f12 = d4.ExecutionTrace.this.executionTracesHandler;
                    long l3 = d4.ExecutionTrace.this.id;
                    String string = d4.ExecutionTrace.this.name;
                    String string22 = d4.string3;
                    String string32 = d4.string2;
                    string32 = string32 == null ? null : string32.trim();
                    f12.a(l3, string, string22, string32);
                }
            });
            return;
        }
        String string6 = ((ExecutionTrace)((Object)string6)).name;
        ((ExecutionTrace)((Object)string6)).apmLogger.e("Trace attribute wasn't added to \"$s\". Trace attribute key can't be null or empty string.".replace("$s", string6));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n3) {
        parcel.writeLong(this.id);
        parcel.writeInt(this.attrs.size());
        Iterator<Map.Entry<String, String>> iterator = this.attrs.entrySet().iterator();
        while (iterator.hasNext()) {
            Parcel parcel2 = parcel;
            Map.Entry<String, String> entry = iterator.next();
            parcel2.writeString(entry.getKey());
            parcel2.writeString(entry.getValue());
        }
        parcel.writeString(this.name);
        parcel.writeLong(this.startTime);
        parcel.writeLong(this.startTimeMicro);
        parcel.writeLong(this.endTimeMicro);
    }

    @VisibleForTesting
    long getId() {
        return this.id;
    }
}

