/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.apm.b2;
import com.instabug.apm.e;
import com.instabug.apm.f1;
import com.instabug.apm.i2;
import com.instabug.apm.l1;
import com.instabug.apm.o1;
import com.instabug.apm.t;
import com.instabug.apm.v;
import com.instabug.apm.x;
import com.instabug.apm.x1;
import com.instabug.apm.y;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.InstabugStateEventBus;
import com.instabug.library.core.eventbus.NDKSessionCrashedEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventSubscriber;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.model.common.Session;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class APMPlugin
extends Plugin
implements t {
    private static final String TAG = "APMPlugin";
    public static final Object lock = new Object();
    private boolean isFirstLaunch = false;
    private final b2 sessionHandler = x1.I();
    private final l1 apmLogger = x1.f();
    @Nullable
    private CompositeDisposable sdkCoreEventsSubscriberDisposable;

    private void registerSessionCrashHandler() {
        if (x1.d().H() && !(Thread.getDefaultUncaughtExceptionHandler() instanceof x)) {
            InstabugSDKLogger.d((Object)TAG, (String)"setting Uncaught Exception Handler APMUncaughtExceptionHandler");
            Thread.setDefaultUncaughtExceptionHandler(new x());
        }
    }

    private void subscribeToSDKState() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        this.sdkCoreEventsSubscriberDisposable.add(InstabugStateEventBus.getInstance().getEventObservable().subscribe((Consumer)new Consumer<InstabugState>(){

            public void a(InstabugState instabugState) {
                if (instabugState == InstabugState.DISABLED) {
                    a a4 = this;
                    a4.APMPlugin.this.apmLogger.d("Instabug is disabled, purging APM data\u2026");
                    a4.APMPlugin.this.stopRunningMetrics();
                    a4.APMPlugin.this.endSession();
                    a4.APMPlugin.this.purgeData();
                }
            }
        }));
    }

    private void purgeData() {
        x1.d().l(-1L);
        final v v3 = x1.h();
        final boolean bl = v3.b();
        x1.a("session_purging_thread_executor").execute(new Runnable(this){

            @Override
            public void run() {
                v3.a(bl);
            }
        });
    }

    private void stopRunningMetrics() {
        x1.x().b();
        x1.C().b();
        PoolProvider.postMainThreadTask((Runnable)new Runnable(this){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT >= 16) {
                    x1.V().f();
                    x1.p().b();
                }
            }
        });
    }

    private void clearInvalidCache() {
        final f1 f12 = x1.x();
        final o1 o12 = x1.C();
        x1.a("execution_traces_thread_executor").execute(new Runnable(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    f12.c();
                    return;
                }
            }
        });
        x1.a("network_log_thread_executor").execute(new Runnable(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (x1.d().l()) {
                    Object object = lock;
                    synchronized (object) {
                        o12.c();
                    }
                }
            }
        });
    }

    private void registerConfigurationChange() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        APMPlugin aPMPlugin = this;
        aPMPlugin.sdkCoreEventsSubscriberDisposable.add(SDKCoreEventSubscriber.subscribe((Consumer)new Consumer<SDKCoreEvent>(){

            @SuppressLint(value={"NULL_DEREFERENCE"})
            public void a(SDKCoreEvent object) {
                if (object.getType().equals("featuresFetched")) {
                    boolean bl = x1.c().a(object.getValue());
                    object = x1.d();
                    if (bl && object.v()) {
                        object = InstabugCore.getRunningSession();
                        if (object != null) {
                            String string = string;
                            i2.a(string.APMPlugin.this);
                            string.APMPlugin.this.startSession((Session)object);
                            string.APMPlugin.this.registerSessionCrashHandler();
                        }
                        Object object2 = string;
                        object2.APMPlugin.this.registerActivityLifeCycleCallbacks();
                        object2.APMPlugin.this.registerSessionCrashHandler();
                    }
                } else if (object.getType().equals("cross_platform_state_screen_changed")) {
                    String string = object.getValue();
                    if (string != null) {
                        x1.W().a(string);
                    }
                } else if (object.getType().equals("cross_platform_crashed")) {
                    string.APMPlugin.this.updateCurrentSession();
                }
            }
        }));
        aPMPlugin.sdkCoreEventsSubscriberDisposable.add(x1.H().subscribe((Consumer)new Consumer<NDKSessionCrashedEvent>(){

            public void a(NDKSessionCrashedEvent nDKSessionCrashedEvent) {
                APMPlugin.this.sessionHandler.a(nDKSessionCrashedEvent.getSessionId(), TimeUnit.MILLISECONDS.toMicros(nDKSessionCrashedEvent.getSessionDuration()), 1);
            }
        }));
    }

    private void updateCurrentSession() {
        x1.O().execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugCore.getRunningSession() != null) {
                    APMPlugin.this.sessionHandler.b(1);
                }
            }
        });
    }

    private void registerActivityLifeCycleCallbacks() {
        Context context;
        e e4 = x1.d();
        if (e4.v() && (context = x1.o()) != null && !y.h()) {
            boolean bl = e4.A() || e4.z();
            y y3 = x1.a(context, bl);
            if (y3 != null) {
                ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)y3);
            }
        }
    }

    private void startSession(@NonNull Session session) {
        this.sessionHandler.a(session);
    }

    private void endSession() {
        this.sessionHandler.b(0);
    }

    public void wake() {
        Session session;
        if (x1.d().v() && this.isFirstLaunch) {
            this.clearInvalidCache();
            this.isFirstLaunch = false;
        }
        if ((session = InstabugCore.getRunningSession()) != null) {
            APMPlugin aPMPlugin = this;
            i2.a(aPMPlugin);
            aPMPlugin.startSession(session);
            aPMPlugin.registerSessionCrashHandler();
        } else {
            this.apmLogger.e("APM session not created. Core session is null");
        }
    }

    public void stop() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable != null && !compositeDisposable.isDisposed()) {
            this.sdkCoreEventsSubscriberDisposable.dispose();
        }
    }

    public void sleep() {
        this.endSession();
    }

    public void start(Context context) {
        APMPlugin aPMPlugin = this;
        aPMPlugin.isFirstLaunch = true;
        aPMPlugin.registerConfigurationChange();
        aPMPlugin.subscribeToSDKState();
        if (Build.VERSION.SDK_INT < 16) {
            this.apmLogger.e("Could not enable Auto UI Trace. Feature is supported on API level 16 and up only.");
        }
    }

    public long getLastActivityTime() {
        return 0L;
    }

    @Override
    @WorkerThread
    public void onNewSessionStarted(@NonNull Session session, @Nullable Session session2) {
        if (session2 != null) {
            x1.E().a(session, session2);
            x1.z().a(session, session2);
        }
        x1.h().a();
    }

    public boolean isFeatureEnabled() {
        return x1.d().v();
    }
}

