/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.logger.a.a;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import org.json.JSONObject;

public class ExecutionTrace
implements Parcelable {
    public static final Parcelable.Creator<ExecutionTrace> CREATOR = new Parcelable.Creator<ExecutionTrace>(){

        public ExecutionTrace createFromParcel(Parcel parcel) {
            return new ExecutionTrace(parcel);
        }

        public ExecutionTrace[] newArray(int n) {
            return new ExecutionTrace[n];
        }
    };
    private final transient Executor executor = com.instabug.apm.e.a.a("execution_traces_thread_executor");
    private final transient com.instabug.apm.f.b.a executionTracesHandler = com.instabug.apm.e.a.v();
    private final transient a apmLogger = com.instabug.apm.e.a.d();
    private final Map<String, String> attrs;
    private final String name;
    private final long id;
    private long startTime;
    private long startTimeMicro;
    private long endTimeMicro = -1L;

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
    public ExecutionTrace(String name) {
        void var1_1;
        this.id = new Random().nextLong();
        this.startTime = System.currentTimeMillis() * 1000L;
        this.startTimeMicro = System.nanoTime() / 1000L;
        this.name = var1_1;
        this.attrs = new HashMap<String, String>();
        this.executor.execute(new Runnable((String)var1_1){
            final /* synthetic */ String a;
            {
                this.a = string;
            }

            @Override
            public void run() {
                b b2 = this;
                b b3 = this;
                long l = b3.ExecutionTrace.this.id;
                String string = b3.a;
                long l2 = l;
                l = ExecutionTrace.this.startTime;
                b2.ExecutionTrace.this.executionTracesHandler.a(l2, string, l);
                b2.ExecutionTrace.this.apmLogger.d("Execution trace " + this.a + " has started.");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected ExecutionTrace(Parcel in) {
        void var1_1;
        this.id = var1_1.readLong();
        int n = var1_1.readInt();
        this.attrs = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            void v0 = var1_1;
            String string = v0.readString();
            String string2 = v0.readString();
            this.attrs.put(string, string2);
        }
        this.name = var1_1.readString();
        this.startTime = var1_1.readLong();
        this.startTimeMicro = var1_1.readLong();
        this.endTimeMicro = var1_1.readLong();
    }

    public void end() {
        this.endTimeMicro = System.nanoTime() / 1000L;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                c c2 = this;
                long l = c2.ExecutionTrace.this.endTimeMicro - ExecutionTrace.this.startTimeMicro;
                c2.ExecutionTrace.this.executionTracesHandler.a(ExecutionTrace.this.id, l);
                c2.ExecutionTrace.this.apmLogger.d("Execution trace " + ExecutionTrace.this.name + " has ended.\nTotal duration: " + l + " ms\nAttributes: " + new JSONObject(ExecutionTrace.this.attrs).toString());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(@NonNull String key, @Nullable String value) {
        String string;
        if (key != null && !string.trim().isEmpty()) {
            void var2_2;
            final String string2 = string.trim();
            if (string2.length() > 30) {
                ((ExecutionTrace)((Object)string5)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\" as it was too long. Please limit attribute key names to 30 characters.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string5)).name));
                return;
            }
            if (var2_2 != null) {
                String string3 = var2_2.trim();
                if (string3.length() == 0) {
                    ((ExecutionTrace)((Object)string5)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\". Trace attribute value can't be empty string.".replace("$s1", string2).replace("$s2", ((ExecutionTrace)((Object)string5)).name));
                    return;
                }
                if (string3.length() > 60) {
                    ((ExecutionTrace)((Object)string5)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\" as its value was too long. Please limit trace attribute values to 60 characters.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string5)).name));
                    return;
                }
            }
            if (((ExecutionTrace)((Object)string5)).endTimeMicro != -1L) {
                ((ExecutionTrace)((Object)string5)).apmLogger.e("Trace attribute \"$s1\" wasn't added to \"$s2\" because attribute was added after the trace had already ended.".replace("$s1", string).replace("$s2", ((ExecutionTrace)((Object)string5)).name));
                return;
            }
            string = var2_2 == null ? null : var2_2.trim();
            String string4 = string5;
            ((ExecutionTrace)((Object)string4)).attrs.put(string2, string);
            ((ExecutionTrace)((Object)string4)).executor.execute(new Runnable((String)var2_2){
                final /* synthetic */ String b;
                {
                    this.b = string22;
                }

                @Override
                public void run() {
                    d d2 = a2;
                    com.instabug.apm.f.b.a a2 = d2.ExecutionTrace.this.executionTracesHandler;
                    long l = d2.ExecutionTrace.this.id;
                    String string = d2.ExecutionTrace.this.name;
                    String string22 = d2.string2;
                    String string3 = d2.b;
                    string3 = string3 == null ? null : string3.trim();
                    a2.a(l, string, string22, string3);
                }
            });
            return;
        }
        String string5 = ((ExecutionTrace)((Object)string5)).name;
        ((ExecutionTrace)((Object)string5)).apmLogger.e("Trace attribute wasn't added to \"$s\". Trace attribute key can't be null or empty string.".replace("$s", string5));
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(Parcel dest, int flags) {
        void var1_1;
        var1_1.writeLong(this.id);
        var1_1.writeInt(this.attrs.size());
        Iterator<Map.Entry<String, String>> iterator = this.attrs.entrySet().iterator();
        while (iterator.hasNext()) {
            void v0 = var1_1;
            Map.Entry<String, String> entry = iterator.next();
            v0.writeString(entry.getKey());
            v0.writeString(entry.getValue());
        }
        var1_1.writeString(this.name);
        var1_1.writeLong(this.startTime);
        var1_1.writeLong(this.startTimeMicro);
        var1_1.writeLong(this.endTimeMicro);
    }

    @VisibleForTesting
    long getId() {
        return this.id;
    }
}

