package com.instabug.library.apm_okhttp_event_listener

import androidx.annotation.IntDef


@Retention(AnnotationRetention.SOURCE)
@IntDef(
    LatencyEvent.REQUEST_STARTED,
    LatencyEvent.DNS_START,
    LatencyEvent.DNS_END,
    LatencyEvent.CONNECT_START,
    LatencyEvent.SECURE_CONNECT_START,
    LatencyEvent.SECURE_CONNECT_END,
    LatencyEvent.CONNECT_END,
    LatencyEvent.REQUEST_HEADERS_START,
    LatencyEvent.REQUEST_HEADERS_END,
    LatencyEvent.REQUEST_BODY_START,
    LatencyEvent.REQUEST_BODY_END,
    LatencyEvent.RESPONSE_HEADERS_START,
    LatencyEvent.RESPONSE_HEADERS_END,
    LatencyEvent.RESPONSE_BODY_START,
    LatencyEvent.RESPONSE_BODY_END,
    LatencyEvent.REQUEST_FAILED,
    LatencyEvent.TOTAL_COUNT
)
annotation class LatencyEvent {
    companion object {
        const val REQUEST_STARTED = 0
        const val DNS_START = 1
        const val DNS_END = 2
        const val CONNECT_START = 3
        const val SECURE_CONNECT_START = 4
        const val SECURE_CONNECT_END = 5
        const val CONNECT_END = 6
        const val REQUEST_HEADERS_START = 7
        const val REQUEST_HEADERS_END = 8
        const val REQUEST_BODY_START = 9
        const val REQUEST_BODY_END = 10
        const val RESPONSE_HEADERS_START = 11
        const val RESPONSE_HEADERS_END = 12
        const val RESPONSE_BODY_START = 13
        const val RESPONSE_BODY_END = 14
        const val REQUEST_FAILED = 15
        const val TOTAL_COUNT = 16
    }
}

object NetworkLatencyConstants {

    const val EVENT_NAME = "n"
    const val START_TIME_MICROS = "st_mus"
    const val DURATION_MICROS = "dur_mus"
    const val FAILED = "fail"

    const val DNS_LOOKUP_SPAN_KEY = "dns_lkp"
    const val HANDSHAKE_SPAN_KEY = "cnct_hs"
    const val TLS_SPAN_KEY = "tls"
    const val REQUEST_SPAN_KEY = "u_rq"
    const val RESPONSE_SPAN_KEY = "d_rt"
    const val SERVER_PROCESSING_SPAN_KEY = "srv_prc"

    const val MAPPING_ERROR_MESSAGE = "Failed to map network latency spans due to an error:"
}