/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.apmokhttplogger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.logger.APMLogger;
import com.instabug.apm.networking.ApmNetworkInterceptorHelper;
import com.instabug.library.apmokhttplogger.model.a;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.networkv2.BodyBufferHelper;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kotlin.Pair;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONException;
import org.json.JSONObject;

public class InstabugAPMOkhttpInterceptor
implements Interceptor {
    private static final String TAG = "InstabugAPMOkhttpInterceptor";
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_LENGTH = "content-length";
    public static final String APOLLO_GRAPH_QL_QUERY_NAME_KEY = "x-apollo-operation-name";
    public static final String APOLLO_GRAPH_QL_ERROR_KEY = "errors";
    public static final String GRAPH_QL_SERVER_SIDE_ERROR = "GraphQLError";

    @NonNull
    private static Response continueChainWithoutCapturing(@NonNull Interceptor.Chain chain) {
        Interceptor.Chain chain2 = chain;
        return chain2.proceed(chain2.request());
    }

    private Map<String, String> getResponseHeaders(@NonNull Response response) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        response = response.headers();
        for (int i2 = 0; i2 < response.size(); ++i2) {
            String string = response.name(i2).toLowerCase();
            hashMap2.put(string, response.value(i2));
        }
        return hashMap2;
    }

    private Map<String, String> getRequestHeaders(@NonNull Request request, @Nullable RequestBody requestBody) {
        Object object;
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        if (requestBody != null) {
            object = requestBody.contentType();
            if (object != null) {
                hashMap2.put(CONTENT_TYPE, object.toString());
            }
            if (requestBody.contentLength() != -1L) {
                hashMap2.put(CONTENT_LENGTH, String.valueOf(requestBody.contentLength()));
            }
        }
        request = request.headers();
        for (int i2 = 0; i2 < request.size(); ++i2) {
            object = request.name(i2).toLowerCase();
            hashMap2.put(object, request.value(i2));
        }
        return hashMap2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String bodyToString(RequestBody requestBody) {
        Buffer buffer;
        RequestBody requestBody2;
        try {
            Object object = requestBody.contentType();
            String string = object = object != null ? object.toString() : "";
            if (BodyBufferHelper.isMultipartType((String)object)) {
                return "multipart body was omitted";
            }
            if (!BodyBufferHelper.isBodySizeAllowed((long)requestBody.contentLength())) {
                return "Body omitted due to its large size > 1MB";
            }
            requestBody2 = requestBody;
        }
        catch (IOException iOException) {}
        requestBody = buffer;
        requestBody2.writeTo((BufferedSink)new Buffer());
        return requestBody.readUtf8();
        InstabugSDKLogger.e((String)TAG, (String)"Failed to read request body", (Throwable)iOException);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response populateNetworkResponse(@NonNull Interceptor.Chain chain) {
        InstabugAPMOkhttpInterceptor instabugAPMOkhttpInterceptor;
        Interceptor.Chain chain2;
        Object object;
        boolean bl;
        Map<String, String> map;
        Request request;
        a a2;
        block12: {
            Throwable throwable2;
            block10: {
                block11: {
                    InstabugAPMOkhttpInterceptor instabugAPMOkhttpInterceptor2 = instabugAPMOkhttpInterceptor;
                    a2 = null;
                    request = chain.request();
                    map = null;
                    bl = false;
                    try {
                        a2 = InstabugAPMOkhttpInterceptor.getNetworkLogRepository().a(chain.call());
                    }
                    catch (Throwable throwable2) {
                        break block10;
                    }
                    {
                        Request request2 = request;
                        InstabugSDKLogger.v((String)TAG, (String)"populate network request started");
                        object = request2.body();
                        a2.setMethod(request2.method());
                        a2.setUrl(request.url().toString());
                        map = instabugAPMOkhttpInterceptor2.getRequestHeaders(request, (RequestBody)object);
                    }
                    {
                        bl = instabugAPMOkhttpInterceptor2.shouldProcessGraphQLRequest(map);
                        if (!bl) break block11;
                    }
                    a2.setGraphQlQueryName(instabugAPMOkhttpInterceptor.getQueryName(map));
                }
                a2.setRequestHeaders(ObjectMapper.toJson(map).toString());
                a2.setRequestContentType(map.get(CONTENT_TYPE));
                object = "$method";
                APMLogger.d((String)"Request [$method] $url has started.".replace((CharSequence)object, request.method()).replace("$url", request.url().toString()));
                break block12;
            }
            instabugAPMOkhttpInterceptor.reportException(throwable2);
        }
        if (a2 != null) {
            a a3 = a2;
            a3.a(System.nanoTime());
            a3.setStartTime(System.currentTimeMillis() * 1000L);
        }
        try {
            chain2 = chain;
            request = instabugAPMOkhttpInterceptor.injectExternalTraceIdIfPossible(request, chain.call());
        }
        catch (IOException iOException) {
            InstabugAPMOkhttpInterceptor instabugAPMOkhttpInterceptor3 = instabugAPMOkhttpInterceptor;
            instabugAPMOkhttpInterceptor.handleRequestBody(a2, request);
            instabugAPMOkhttpInterceptor = chain.call();
            instabugAPMOkhttpInterceptor3.handleExceptionResponse(a2, iOException, (Call)instabugAPMOkhttpInterceptor);
            throw iOException;
        }
        {
            object = chain2.proceed(request);
        }
        {
            InstabugAPMOkhttpInterceptor instabugAPMOkhttpInterceptor4 = instabugAPMOkhttpInterceptor;
            instabugAPMOkhttpInterceptor.handleRequestBody(a2, request);
            instabugAPMOkhttpInterceptor = chain.call();
            instabugAPMOkhttpInterceptor4.handleResponse(a2, map, bl, (Response)object, (Call)instabugAPMOkhttpInterceptor);
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Request injectExternalTraceIdIfPossible(Request request, Call object) {
        try {
            Object object2 = InstabugAPMOkhttpInterceptor.getNetworkLogRepository().a((Call)object, request.header("traceparent"));
            if (object2 == null) {
                return request;
            }
            Object object3 = object2;
            object2 = request.newBuilder();
            object = object3.iterator();
            while (object.hasNext()) {
                Pair pair = (Pair)object.next();
                object2.addHeader((String)pair.getFirst(), (String)pair.getSecond());
            }
        }
        catch (Throwable throwable) {}
        {
            continue;
        }
        return object2.build();
        IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)"InstabugAPMOkhttpInterceptor Error occurred while injecting \"IBG-TRACE-ID\"");
        return request;
    }

    private void handleRequestBody(@Nullable a a2, Request request) {
        block3: {
            InstabugAPMOkhttpInterceptor instabugAPMOkhttpInterceptor = request.body();
            if (a2 == null || instabugAPMOkhttpInterceptor == null) break block3;
            try {
                a2.setRequestBodySize(instabugAPMOkhttpInterceptor.contentLength());
                a2.setRequestBody(InstabugAPMOkhttpInterceptor.bodyToString((RequestBody)instabugAPMOkhttpInterceptor));
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)TAG, (String)"Failed to handle Request body", (Throwable)exception);
            }
        }
    }

    @NonNull
    private static com.instabug.library.apm_network_log_repository.a getNetworkLogRepository() {
        return com.instabug.library.di.a.a();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleResponse(a a2, @Nullable Map<String, String> object, boolean bl, Response response, Call call) {
        block14: {
            if (a2 == null) return;
            if (response == null) return;
            try {
                a2.b(System.nanoTime());
                a2.setResponseCode(response.code());
                if (response.code() > 0) {
                    a2.setErrorMessage(null);
                }
                Object object2 = this.getResponseHeaders(response);
                a2.setResponseHeaders(ObjectMapper.toJson(object2).toString());
                a2.setResponseContentType(object2.get(CONTENT_TYPE));
                object2 = object2.get(CONTENT_LENGTH);
                if (object2 != null) {
                    a2.setResponseBodySize(Long.parseLong((String)object2));
                }
            }
            catch (Throwable throwable) {}
            try {
                if (!this.isGraphQLRequest((Map<String, String>)object) || response.body() == null) break block14;
                com.instabug.library.apmokhttplogger.a a3 = new com.instabug.library.apmokhttplogger.a(response.body());
                a2.setResponseBodySize(a3.b());
                object = a3.a();
                a2.setResponseBody((String)object);
                if (!bl || (object = this.getGraphQlServerSideErrorMessage((String)object)) == null) break block14;
                a2.setServerSideErrorMessage((String)object);
            }
            catch (Exception exception) {}
            catch (OutOfMemoryError outOfMemoryError) {}
        }
        InstabugSDKLogger.v((String)TAG, (String)"inserting network log");
        InstabugAPMOkhttpInterceptor.getNetworkLogRepository().a(call, (Exception)null);
    }

    private void handleExceptionResponse(a a2, IOException iOException, Call call) {
        if (a2 != null) {
            try {
                a a3 = a2;
                a2.b(System.nanoTime());
                a3.setErrorMessage(iOException.getClass().getSimpleName());
                a3.setResponseCode(0);
                InstabugAPMOkhttpInterceptor.getNetworkLogRepository().a(call, iOException);
                InstabugSDKLogger.e((String)TAG, (String)"Failed to proceed request", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                this.reportException(throwable);
            }
        }
    }

    private boolean shouldProcessGraphQLRequest(@NonNull Map<String, String> map) {
        return this.isGraphQLRequest(map) && this.isGraphQlRequestsInterceptionEnabled();
    }

    private boolean isGraphQLRequest(@Nullable Map<String, String> map) {
        if (map != null) {
            return map.containsKey(APOLLO_GRAPH_QL_QUERY_NAME_KEY);
        }
        return false;
    }

    private boolean isGraphQlRequestsInterceptionEnabled() {
        return ApmNetworkInterceptorHelper.Companion.isGraphQlEnabled();
    }

    @Nullable
    private String getQueryName(@Nullable Map<String, String> map) {
        if (map != null) {
            return map.get(APOLLO_GRAPH_QL_QUERY_NAME_KEY);
        }
        return null;
    }

    @Nullable
    private String getGraphQlServerSideErrorMessage(@Nullable String string) {
        block5: {
            if (string != null) {
                try {
                    InstabugAPMOkhttpInterceptor instabugAPMOkhttpInterceptor = new JSONObject(string).optJSONArray(APOLLO_GRAPH_QL_ERROR_KEY);
                    if (instabugAPMOkhttpInterceptor == null) break block5;
                }
                catch (JSONException jSONException) {}
                if (instabugAPMOkhttpInterceptor.length() == 0) break block5;
                return GRAPH_QL_SERVER_SIDE_ERROR;
            }
        }
        return null;
    }

    private void reportException(Throwable throwable) {
        try {
            IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)"Exception while trying to intercept an OkHttp request");
            InstabugSDKLogger.e((String)TAG, (String)"Exception while trying to intercept an OkHttp request", (Throwable)throwable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isOkHttpVersionSupported(Interceptor.Chain chain) {
        try {
            chain.call();
        }
        catch (Throwable throwable) {
            APMLogger.e((String)"OkHttp requests won't be captured because the OkHttp version you are using isn't supported by Instabug. Please upgrade to OkHttp V3.14.0 or above.");
            return false;
        }
        return true;
    }

    @NonNull
    public Response intercept(@NonNull Interceptor.Chain chain) {
        if (this.isOkHttpVersionSupported(chain)) {
            return this.populateNetworkResponse(chain);
        }
        return InstabugAPMOkhttpInterceptor.continueChainWithoutCapturing(chain);
    }
}

