/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.apmokhttplogger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.logger.APMLogger;
import com.instabug.apm.networking.ApmNetworkInterceptorHelper;
import com.instabug.library.apm_network_log_repository.b;
import com.instabug.library.apmokhttplogger.model.a;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.di.c;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.networkv2.BodyBufferHelper;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONException;
import org.json.JSONObject;

public class InstabugAPMOkhttpInterceptor
implements Interceptor {
    private static final String TAG = "InstabugAPMOkhttpInterceptor";
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_LENGTH = "content-length";
    public static final String APOLLO_GRAPH_QL_QUERY_NAME_KEY = "x-apollo-operation-name";
    public static final String APOLLO_GRAPH_QL_ERROR_KEY = "errors";
    public static final String GRAPH_QL_SERVER_SIDE_ERROR = "GraphQLError";

    @NonNull
    private static Response continueChainWithoutCapturing(@NonNull Interceptor.Chain chain) {
        Interceptor.Chain chain2 = chain;
        return chain2.proceed(chain2.request());
    }

    private Map<String, String> getResponseHeaders(@NonNull Response response) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        response = response.headers();
        for (int i2 = 0; i2 < response.size(); ++i2) {
            String string = response.name(i2).toLowerCase();
            hashMap2.put(string, response.value(i2));
        }
        return hashMap2;
    }

    private Map<String, String> getRequestHeaders(@NonNull Request request, @Nullable RequestBody requestBody) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        if (requestBody != null) {
            if (requestBody.contentType() != null) {
                hashMap2.put(CONTENT_TYPE, requestBody.contentType().toString());
            }
            if (requestBody.contentLength() != -1L) {
                hashMap2.put(CONTENT_LENGTH, String.valueOf(requestBody.contentLength()));
            }
        }
        request = request.headers();
        for (int i2 = 0; i2 < request.size(); ++i2) {
            String string = request.name(i2).toLowerCase();
            hashMap2.put(string, request.value(i2));
        }
        return hashMap2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String bodyToString(RequestBody requestBody) {
        Buffer buffer;
        RequestBody requestBody2;
        try {
            String string;
            String string2 = string = requestBody.contentType() != null ? requestBody.contentType().toString() : "";
            if (BodyBufferHelper.isMultipartType((String)string)) {
                return "multipart body was omitted";
            }
            if (!BodyBufferHelper.isBodySizeAllowed((long)requestBody.contentLength())) {
                return "body omitted due to its large size > 1MB";
            }
            requestBody2 = requestBody;
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to read request body", (Throwable)iOException);
            return null;
        }
        requestBody = buffer;
        {
            requestBody2.writeTo((BufferedSink)new Buffer());
            return requestBody.readUtf8();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Response populateNetworkResponse(@NonNull Interceptor.Chain var1_1) {
        v0 = this;
        var2_2 = null;
        var3_3 = var1_1.request();
        var4_4 = null;
        var5_6 = false;
        var2_2 = InstabugAPMOkhttpInterceptor.getNetworkLogRepository().c(var1_1.call());
        v1 = var3_3;
        v2 = var2_2;
        v3 = var3_3;
        v4 = v3;
        InstabugSDKLogger.v((String)"InstabugAPMOkhttpInterceptor", (String)"populate network request started");
        var6_7 /* !! */  = v3.body();
        v2.setMethod(v4.method());
        var2_2.setUrl(v1.url().toString());
        var4_4 = v0.getRequestHeaders(var3_3, var6_7 /* !! */ );
        var5_6 = v0.shouldProcessGraphQLRequest(var4_4);
        if (!var5_6) ** GOTO lbl24
        var2_2.setGraphQlQueryName(this.getQueryName(var4_4));
lbl24:
        // 2 sources

        var2_2.setRequestHeaders(ObjectMapper.toJson(var4_4).toString());
        var2_2.setRequestContentType(var4_4.get("content-type"));
        v5 = "Request [$method] $url has started.";
        v6 = var3_3;
        var6_7 /* !! */  = "$method";
        try {
            APMLogger.d((String)v5.replace((CharSequence)var6_7 /* !! */ , v6.method()).replace("$url", var3_3.url().toString()));
        }
        catch (Throwable var6_8) {
            this.reportException(var6_8);
        }
        if (var2_2 != null) {
            v7 = var2_2;
            v7.a(System.nanoTime());
            v7.setStartTime(System.currentTimeMillis() * 1000L);
        }
        try {
            v8 = var1_1;
            var3_3 = this.injectExternalTraceIdIfPossible(var3_3, var1_1.call());
        }
        catch (IOException var4_5) {
            v9 = this;
            this.handleRequestBody(var2_2, var3_3);
            this = var1_1.call();
            v9.handleExceptionResponse(var2_2, var4_5, (Call)this);
            throw var4_5;
        }
        var6_7 /* !! */  = v8.proceed(var3_3);
        v10 = this;
        this.handleRequestBody(var2_2, var3_3);
        this = var1_1.call();
        v10.handleResponse(var2_2, var4_4, var5_6, (Response)var6_7 /* !! */ , (Call)this);
        return var6_7 /* !! */ ;
    }

    private Request injectExternalTraceIdIfPossible(Request request, Call call) {
        block3: {
            try {
                InstabugAPMOkhttpInterceptor instabugAPMOkhttpInterceptor = InstabugAPMOkhttpInterceptor.getNetworkLogRepository().a(call);
                if (instabugAPMOkhttpInterceptor != null) break block3;
                return request;
            }
            catch (Throwable throwable) {
                IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)"InstabugAPMOkhttpInterceptor Error occurred while injecting \"IBG-TRACE-ID\"");
                return request;
            }
        }
        return request.newBuilder().addHeader((String)instabugAPMOkhttpInterceptor.getFirst(), (String)instabugAPMOkhttpInterceptor.getSecond()).build();
    }

    private void handleRequestBody(@Nullable a a2, Request request) {
        block3: {
            InstabugAPMOkhttpInterceptor instabugAPMOkhttpInterceptor = request.body();
            if (a2 == null || instabugAPMOkhttpInterceptor == null) break block3;
            try {
                a2.setRequestBodySize(instabugAPMOkhttpInterceptor.contentLength());
                a2.setRequestBody(InstabugAPMOkhttpInterceptor.bodyToString((RequestBody)instabugAPMOkhttpInterceptor));
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)TAG, (String)"Failed to handle Request body", (Throwable)exception);
            }
        }
    }

    @NonNull
    private static b getNetworkLogRepository() {
        return c.a();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private void handleResponse(a var1_1, @Nullable Map<String, String> var2_6, boolean var3_7, Response var4_8, Call var5_9) {
        block14: {
            if (var1_1 == null || var4_8 == null) break block14;
            var1_1.b(System.nanoTime());
            var1_1.setResponseCode(var4_8.code());
            if (var4_8.code() > 0) {
                var1_1.setErrorMessage(null);
            }
            var6_10 = this.getResponseHeaders(var4_8);
            var1_1.setResponseHeaders(ObjectMapper.toJson(var6_10).toString());
            var1_1.setResponseContentType(var6_10.get("content-type"));
            var6_10 = var6_10.get("content-length");
            if (var6_10 == null) ** GOTO lbl16
            var1_1.setResponseBodySize(Long.parseLong((String)var6_10));
lbl16:
            // 3 sources

            if (!this.isGraphQLRequest((Map<String, String>)var2_6) || var4_8.body() == null) ** GOTO lbl41
            v0 = var3_7;
            v1 = var1_1;
            v2 = new com.instabug.library.apmokhttplogger.a(var4_8.body());
            var1_1.setResponseBodySize(v2.b());
            var2_6 = v2.a();
            v1.setResponseBody((String)var2_6);
            if (!v0 || (var2_6 = this.getGraphQlServerSideErrorMessage((String)var2_6)) == null) ** GOTO lbl41
            try {
                block13: {
                    var1_1.setServerSideErrorMessage((String)var2_6);
                    {
                        catch (Exception var1_2) {
                            v3 = "InstabugAPMOkhttpInterceptor";
                            v4 = "Failed to get response body";
lbl33:
                            // 2 sources

                            while (true) {
                                InstabugSDKLogger.e((String)v3, (String)v4, (Throwable)var1_3);
                                break block13;
                                break;
                            }
                        }
                        catch (OutOfMemoryError var1_4) {
                            InstabugCore.reportError((Throwable)var1_4, (String)"Not enough memory for saving response");
                            v3 = "InstabugAPMOkhttpInterceptor";
                            v4 = "Not enough memory for saving response";
                            ** continue;
                        }
                    }
                }
                InstabugSDKLogger.v((String)"InstabugAPMOkhttpInterceptor", (String)"inserting network log");
                InstabugAPMOkhttpInterceptor.getNetworkLogRepository().a(var5_9, null);
            }
            catch (Throwable var1_5) {
                this.reportException(var1_5);
            }
        }
    }

    private void handleExceptionResponse(a a2, IOException iOException, Call call) {
        if (a2 != null) {
            try {
                a a3 = a2;
                a2.b(System.nanoTime());
                a3.setErrorMessage(iOException.getClass().getSimpleName());
                a3.setResponseCode(0);
                InstabugAPMOkhttpInterceptor.getNetworkLogRepository().a(call, iOException);
                InstabugSDKLogger.e((String)TAG, (String)"Failed to proceed request", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                this.reportException(throwable);
            }
        }
    }

    private boolean shouldProcessGraphQLRequest(@NonNull Map<String, String> map) {
        return this.isGraphQLRequest(map) && this.isGraphQlRequestsInterceptionEnabled();
    }

    private boolean isGraphQLRequest(@Nullable Map<String, String> map) {
        if (map != null) {
            return map.containsKey(APOLLO_GRAPH_QL_QUERY_NAME_KEY);
        }
        return false;
    }

    private boolean isGraphQlRequestsInterceptionEnabled() {
        return ApmNetworkInterceptorHelper.Companion.isGraphQlEnabled();
    }

    @Nullable
    private String getQueryName(@Nullable Map<String, String> map) {
        if (map != null) {
            return map.get(APOLLO_GRAPH_QL_QUERY_NAME_KEY);
        }
        return null;
    }

    @Nullable
    private String getGraphQlServerSideErrorMessage(@Nullable String string) {
        block5: {
            if (string != null) {
                try {
                    InstabugAPMOkhttpInterceptor instabugAPMOkhttpInterceptor = new JSONObject(string).optJSONArray(APOLLO_GRAPH_QL_ERROR_KEY);
                    if (instabugAPMOkhttpInterceptor == null) break block5;
                }
                catch (JSONException jSONException) {}
                if (instabugAPMOkhttpInterceptor.length() == 0) break block5;
                return GRAPH_QL_SERVER_SIDE_ERROR;
            }
        }
        return null;
    }

    private void reportException(Throwable throwable) {
        try {
            IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)"Exception while trying to intercept an OkHttp request");
            InstabugSDKLogger.e((String)TAG, (String)"Exception while trying to intercept an OkHttp request", (Throwable)throwable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isOkHttpVersionSupported(Interceptor.Chain chain) {
        try {
            chain.call();
        }
        catch (Throwable throwable) {
            APMLogger.e((String)"OkHttp requests won't be captured because the OkHttp version you are using isn't supported by Instabug. Please upgrade to OkHttp V3.14.0 or above.");
            return false;
        }
        return true;
    }

    @NonNull
    public Response intercept(@NonNull Interceptor.Chain chain) {
        if (this.isOkHttpVersionSupported(chain)) {
            return this.populateNetworkResponse(chain);
        }
        return InstabugAPMOkhttpInterceptor.continueChainWithoutCapturing(chain);
    }
}

