/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.apmokhttplogger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.logger.APMLogger;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.apm.networking.ApmNetworkInterceptorHelper;
import com.instabug.library.apmokhttplogger.InstabugAPMOkHttpBuffer;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.networkv2.BodyBufferHelper;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InstabugAPMOkhttpInterceptor
implements Interceptor {
    private static final String TAG = "InstabugAPMOkhttpInterceptor";
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_LENGTH = "content-length";
    public static final String APOLLO_GRAPH_QL_QUERY_NAME_KEY = "x-apollo-operation-name";
    public static final String APOLLO_GRAPH_QL_ERROR_KEY = "errors";
    public static final String GRAPH_QL_SERVER_SIDE_ERROR = "GraphQLError";
    @VisibleForTesting
    APMNetworkLog networkLog;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.populateNetworkResponse(chain, new APMNetworkLog());
    }

    private Map<String, String> getResponseHeaders(@NonNull Response response) {
        HashMap<String, String> responseHeadersMap = new HashMap<String, String>();
        Headers responseHeaders = response.headers();
        for (int i = 0; i < responseHeaders.size(); ++i) {
            responseHeadersMap.put(responseHeaders.name(i).toLowerCase(), responseHeaders.value(i));
        }
        return responseHeadersMap;
    }

    private Map<String, String> getRequestHeaders(@NonNull Request request, @Nullable RequestBody requestBody) throws IOException {
        HashMap<String, String> requestHeadersMap = new HashMap<String, String>();
        if (requestBody != null) {
            if (requestBody.contentType() != null) {
                requestHeadersMap.put(CONTENT_TYPE, requestBody.contentType().toString());
            }
            if (requestBody.contentLength() != -1L) {
                requestHeadersMap.put(CONTENT_LENGTH, String.valueOf(requestBody.contentLength()));
            }
        }
        Headers requestHeaders = request.headers();
        for (int i = 0; i < requestHeaders.size(); ++i) {
            String name = requestHeaders.name(i);
            requestHeadersMap.put(name.toLowerCase(), requestHeaders.value(i));
        }
        return requestHeadersMap;
    }

    @Nullable
    private static String bodyToString(RequestBody request) {
        try {
            String contentType;
            String string = contentType = request.contentType() != null ? request.contentType().toString() : "";
            if (BodyBufferHelper.isMultipartType((String)contentType)) {
                return "multipart body was omitted";
            }
            if (!BodyBufferHelper.isBodySizeAllowed((long)request.contentLength())) {
                return "body omitted due to its large size > 1MB";
            }
            RequestBody copy = request;
            Buffer buffer = new Buffer();
            copy.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to read request body", (Throwable)e);
            return null;
        }
    }

    private Response populateNetworkResponse(@NonNull Interceptor.Chain chain, @NonNull APMNetworkLog networkLog) throws IOException {
        Response response;
        this.networkLog = networkLog;
        InstabugSDKLogger.v((String)TAG, (String)"populate network request started");
        networkLog.setStartTime(Long.valueOf(System.currentTimeMillis() * 1000L));
        Request request = chain.request();
        RequestBody requestBody = request.body();
        if (requestBody != null) {
            networkLog.setRequestBodySize(requestBody.contentLength());
            networkLog.setRequestBody(InstabugAPMOkhttpInterceptor.bodyToString(requestBody));
        }
        networkLog.setMethod(request.method());
        networkLog.setUrl(request.url().toString());
        Map<String, String> requestHeaders = this.getRequestHeaders(request, requestBody);
        boolean shouldProcessGraphQlRequest = this.shouldProcessGraphQLRequest(requestHeaders);
        if (shouldProcessGraphQlRequest) {
            networkLog.setGraphQlQueryName(this.getQueryName(requestHeaders));
        }
        networkLog.setRequestHeaders(ObjectMapper.toJson(requestHeaders).toString());
        networkLog.setRequestContentType(requestHeaders.get(CONTENT_TYPE));
        networkLog.insert(null);
        long startNs = System.nanoTime();
        try {
            APMLogger.d((String)"Request [$method] $url has started.".replace("$method", request.method()).replace("$url", request.url().toString()));
            response = chain.proceed(request);
        }
        catch (Exception ex) {
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            networkLog.setTotalDuration(tookMs);
            networkLog.setErrorMessage(ex.getClass().getSimpleName());
            networkLog.setResponseCode(0);
            networkLog.insert(ex);
            InstabugSDKLogger.e((String)TAG, (String)"Failed to proceed request", (Throwable)ex);
            throw ex;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        networkLog.setTotalDuration(tookMs);
        networkLog.setResponseCode(response.code());
        if (response.code() > 0) {
            networkLog.setErrorMessage(null);
        }
        Map<String, String> responseHeaders = this.getResponseHeaders(response);
        networkLog.setResponseHeaders(ObjectMapper.toJson(responseHeaders).toString());
        networkLog.setResponseContentType(responseHeaders.get(CONTENT_TYPE));
        String contentLength = responseHeaders.get(CONTENT_LENGTH);
        if (contentLength != null) {
            networkLog.setResponseBodySize(Long.parseLong(contentLength));
        }
        try {
            if (this.isGraphQLRequest(requestHeaders)) {
                String errorMessage;
                InstabugAPMOkHttpBuffer buffer = new InstabugAPMOkHttpBuffer(response);
                networkLog.setResponseBodySize(buffer.getSize());
                String body = buffer.getBody();
                networkLog.setResponseBody(body);
                if (shouldProcessGraphQlRequest && (errorMessage = this.getGraphQlServerSideErrorMessage(body)) != null) {
                    networkLog.setServerSideErrorMessage(errorMessage);
                }
            }
        }
        catch (OutOfMemoryError e) {
            InstabugCore.reportError((Throwable)e, (String)"Not enough memory for saving response");
            InstabugSDKLogger.e((String)TAG, (String)"Not enough memory for saving response", (Throwable)e);
        }
        catch (Exception e) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to get response body", (Throwable)e);
        }
        InstabugSDKLogger.v((String)TAG, (String)"inserting network log");
        networkLog.insert(null);
        return response;
    }

    private boolean shouldProcessGraphQLRequest(@NonNull Map<String, String> requestHeaders) {
        return this.isGraphQLRequest(requestHeaders) && this.isGraphQlRequestsInterceptionEnabled();
    }

    private boolean isGraphQLRequest(@NonNull Map<String, String> requestHeaders) {
        if (requestHeaders != null) {
            return requestHeaders.containsKey(APOLLO_GRAPH_QL_QUERY_NAME_KEY);
        }
        return false;
    }

    private boolean isGraphQlRequestsInterceptionEnabled() {
        return ApmNetworkInterceptorHelper.Companion.isGraphQlEnabled();
    }

    @Nullable
    private String getQueryName(@NonNull Map<String, String> requestHeaders) {
        if (requestHeaders != null) {
            return requestHeaders.get(APOLLO_GRAPH_QL_QUERY_NAME_KEY);
        }
        return null;
    }

    @Nullable
    private String getGraphQlServerSideErrorMessage(@Nullable String body) {
        if (body != null) {
            try {
                JSONObject jsonObject = new JSONObject(body);
                JSONArray errorsJsonArray = jsonObject.getJSONArray(APOLLO_GRAPH_QL_ERROR_KEY);
                if (errorsJsonArray != null && errorsJsonArray.length() != 0) {
                    return GRAPH_QL_SERVER_SIDE_ERROR;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }
}

