/*
 * Decompiled with CFR 0.152.
 */
package com.innovoid;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.innovoid.tabview.R;
import java.util.Arrays;
import java.util.List;

public class TabView
extends LinearLayout {
    int itemLayout;
    int itemSelectedBackground;
    int itemUnselectedBackground;
    int textViewId;
    int items;
    int itemsColor;
    int itemSelectedColor;
    boolean itemWidthEqual = false;
    int selectedIndex = 0;
    List<String> list;
    OnSelectListener mListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TabView, 0, 0);
        try {
            this.itemLayout = a.getResourceId(R.styleable.TabView_itemLayout, R.layout.tabsview_item);
            this.itemSelectedBackground = a.getResourceId(R.styleable.TabView_itemSelectedBackground, R.drawable.tabsview_selected);
            this.itemUnselectedBackground = a.getResourceId(R.styleable.TabView_itemUnselectedBackground, R.drawable.tabsview_unselected);
            this.textViewId = a.getResourceId(R.styleable.TabView_itemLayoutTextViewId, R.id.tabsview_tv);
            this.items = a.getResourceId(R.styleable.TabView_items, R.array.dummy_items);
            this.itemWidthEqual = a.getBoolean(R.styleable.TabView_itemWidthEqual, false);
            this.itemSelectedColor = a.getColor(R.styleable.TabView_itemSelectedTextColor, this.getContext().getResources().getColor(R.color.tabview_selected_item_color));
            this.itemsColor = a.getColor(R.styleable.TabView_itemsTextColor, this.getContext().getResources().getColor(R.color.tabview_grey));
            this.selectedIndex = a.getInteger(R.styleable.TabView_itemSelected, 1) - 1;
            this.list = Arrays.asList(context.getResources().getStringArray(this.items));
        }
        finally {
            a.recycle();
        }
        this.makeViews();
    }

    public void makeViews() {
        int i;
        Context context = this.getContext();
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        int size = this.list.size();
        int totalCharacters = 0;
        for (i = 0; i < this.list.size(); ++i) {
            totalCharacters += this.list.get(i).length();
            if (this.list.get(i).length() > 2) continue;
            ++totalCharacters;
        }
        if (this.selectedIndex > this.list.size() - 1) {
            this.selectedIndex = this.list.size() - 1;
        }
        this.setWeightSum(1.0f);
        for (i = 0; i < size; ++i) {
            final int position = i;
            View view = layoutInflater.inflate(this.itemLayout, null);
            ((TextView)view.findViewById(this.textViewId)).setText((CharSequence)this.list.get(i));
            LinearLayout.LayoutParams param = this.itemWidthEqual ? new LinearLayout.LayoutParams(0, -1, this.getWeightSum() / (float)size) : new LinearLayout.LayoutParams(0, -1, (this.list.get(i).length() <= 2 ? (float)this.list.get(i).length() + 1.0f : (float)this.list.get(i).length()) / (float)totalCharacters);
            view.setLayoutParams((ViewGroup.LayoutParams)param);
            view.setBackgroundResource(this.itemUnselectedBackground);
            ((TextView)view.findViewById(this.textViewId)).setTextColor(this.itemsColor);
            if (i == this.selectedIndex) {
                view.setBackgroundResource(this.itemSelectedBackground);
                ((TextView)view.findViewById(this.textViewId)).setTextColor(this.itemSelectedColor);
            }
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    for (int j = 0; j < TabView.this.getChildCount(); ++j) {
                        TabView.this.getChildAt(j).setBackgroundResource(TabView.this.itemUnselectedBackground);
                        ((TextView)TabView.this.getChildAt(j).findViewById(TabView.this.textViewId)).setTextColor(TabView.this.itemsColor);
                    }
                    v.setBackgroundResource(TabView.this.itemSelectedBackground);
                    ((TextView)v.findViewById(TabView.this.textViewId)).setTextColor(TabView.this.itemSelectedColor);
                    TabView.this.selectedIndex = position;
                    if (TabView.this.mListener != null) {
                        TabView.this.mListener.onSelect((View)TabView.this, TabView.this.list.get(position));
                    }
                }
            });
            this.addView(view);
        }
        this.setBackground(this.getContext().getResources().getDrawable(R.drawable.tabsview_background));
    }

    int dpToPx(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    public OnSelectListener getItemSelectedListener() {
        return this.mListener;
    }

    public void setOnItemClickListener(OnSelectListener mListener) {
        this.mListener = mListener;
    }

    public int getItemLayout() {
        return this.itemLayout;
    }

    public void setItemLayout(int itemLayout) {
        this.itemLayout = itemLayout;
        this.updateViews();
        this.requestLayout();
    }

    public int getItemSelectedBackground() {
        return this.itemSelectedBackground;
    }

    public void setItemSelectedBackground(int itemSelectedBackground) {
        this.itemSelectedBackground = itemSelectedBackground;
        this.updateViews();
        this.requestLayout();
    }

    public int getItemUnselectedBackground() {
        return this.itemUnselectedBackground;
    }

    public void setItemUnselectedBackground(int itemUnselectedBackground) {
        this.itemUnselectedBackground = itemUnselectedBackground;
        this.updateViews();
        this.requestLayout();
    }

    public int getTextViewId() {
        return this.textViewId;
    }

    public void setTextViewId(int textViewId) {
        this.textViewId = textViewId;
        this.updateViews();
        this.requestLayout();
    }

    public int getItems() {
        return this.items;
    }

    public void setItems(int items) {
        this.items = items;
        this.updateViews();
        this.requestLayout();
    }

    public int getItemsColor() {
        return this.itemsColor;
    }

    public void setItemsColor(int itemsColor) {
        this.itemsColor = itemsColor;
        this.updateViews();
        this.requestLayout();
    }

    public int getItemSelectedColor() {
        return this.itemSelectedColor;
    }

    public void setItemSelectedColor(int itemSelectedColor) {
        this.itemSelectedColor = itemSelectedColor;
        this.updateViews();
        this.requestLayout();
    }

    public boolean isItemWidthEqual() {
        return this.itemWidthEqual;
    }

    public void setItemWidthEqual(boolean itemWidthEqual) {
        this.itemWidthEqual = itemWidthEqual;
        this.updateViews();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedItem() {
        return this.list != null && !this.list.isEmpty() ? this.list.get(this.selectedIndex) : "";
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public List<String> getList() {
        return this.list;
    }

    public void setList(int arrayId) {
        this.items = arrayId;
        this.list = Arrays.asList(this.getContext().getResources().getStringArray(this.items));
        this.updateViews();
    }

    public void setList(List<String> list) {
        this.list = list;
        this.updateViews();
    }

    public void setList(String[] list) {
        this.list = Arrays.asList(list);
        this.updateViews();
    }

    public void updateViews() {
        int i;
        Context context = this.getContext();
        this.removeAllViews();
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        int size = this.list.size();
        int totalCharacters = 0;
        for (i = 0; i < this.list.size(); ++i) {
            totalCharacters += this.list.get(i).length();
            if (this.list.get(i).length() != 1) continue;
            ++totalCharacters;
        }
        if (this.selectedIndex > this.list.size() - 1) {
            this.selectedIndex = this.list.size() - 1;
        }
        this.setWeightSum(1.0f);
        for (i = 0; i < size; ++i) {
            final int position = i;
            View view = layoutInflater.inflate(this.itemLayout, null);
            ((TextView)view.findViewById(this.textViewId)).setText((CharSequence)this.list.get(i));
            LinearLayout.LayoutParams param = this.itemWidthEqual ? new LinearLayout.LayoutParams(0, -1, this.getWeightSum() / (float)size) : new LinearLayout.LayoutParams(0, -1, (this.list.get(i).length() == 1 ? (float)this.list.get(i).length() + 1.0f : (float)this.list.get(i).length()) / (float)totalCharacters);
            view.setLayoutParams((ViewGroup.LayoutParams)param);
            view.setBackgroundResource(this.itemUnselectedBackground);
            ((TextView)view.findViewById(this.textViewId)).setTextColor(this.itemsColor);
            if (i == this.selectedIndex) {
                view.setBackgroundResource(this.itemSelectedBackground);
                ((TextView)view.findViewById(this.textViewId)).setTextColor(this.itemSelectedColor);
            }
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    for (int j = 0; j < TabView.this.getChildCount(); ++j) {
                        TabView.this.getChildAt(j).setBackgroundResource(TabView.this.itemUnselectedBackground);
                        ((TextView)TabView.this.getChildAt(j).findViewById(TabView.this.textViewId)).setTextColor(TabView.this.itemsColor);
                    }
                    v.setBackgroundResource(TabView.this.itemSelectedBackground);
                    ((TextView)v.findViewById(TabView.this.textViewId)).setTextColor(TabView.this.itemSelectedColor);
                    TabView.this.selectedIndex = position;
                    if (TabView.this.mListener != null) {
                        TabView.this.mListener.onSelect((View)TabView.this, TabView.this.list.get(position));
                    }
                }
            });
            this.addView(view);
        }
    }

    public static interface OnSelectListener {
        public void onSelect(View var1, String var2);
    }
}

