/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.private;

import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import com.inlocomedia.android.core.a;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.bw;
import com.inlocomedia.android.core.private.d;
import com.inlocomedia.android.core.private.y;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoMediaService;
import com.inlocomedia.android.location.LocationReceiver;
import com.inlocomedia.android.location.private.al;
import java.util.List;

public class as {
    public as(Context context) {
        a.a((Context)context);
    }

    public static void a(Context context) throws bw, y {
        Validator.sdkVersion();
        if (!as.b(context)) {
            throw new y("You must register your application for ads before using this service");
        }
    }

    public static boolean b(Context context) {
        return Validator.clientId((d)al.a(context));
    }

    public static boolean c(Context context) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(intent = new Intent(context, InLocoMediaService.class), 65536);
        return list.size() > 0;
    }

    public static void d(Context context) {
        if (!as.c(context)) {
            DevLogger.w((String)("Missing optional Service: " + InLocoMediaService.class.getName() + ". It's recommended to include the service in your AndroidManifest file for better performance"));
        }
    }

    public static void e(Context context) {
        if (!as.g(context)) {
            DevLogger.w((String)"Missing optional permission: android.permission.ACCESS_WIFI_STATE. It's recommended to include the permission in your AndroidManifest file for better performance");
        }
        if (!as.h(context)) {
            DevLogger.w((String)"Missing optional permission: android.permission.CHANGE_WIFI_STATE. It's recommended to include the permission in your AndroidManifest file for better performance");
        }
        if (Build.VERSION.SDK_INT < 23 && !Validator.isPermissionEnabled((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") && !Validator.isPermissionEnabled((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION")) {
            DevLogger.w((String)"Missing optional permission: android.permission.ACCESS_FINE_LOCATION | android.permission.ACCESS_COARSE_LOCATION. It's recommended to include either permission in your AndroidManifest file for better performance");
        }
    }

    public static boolean f(Context context) {
        return Validator.isReceiverRegistered((Context)context, LocationReceiver.class, (String)"android.intent.action.BOOT_COMPLETED");
    }

    public static boolean g(Context context) {
        return Validator.isPermissionEnabled((Context)context, (String)"android.permission.ACCESS_WIFI_STATE");
    }

    public static boolean h(Context context) {
        return Validator.isPermissionEnabled((Context)context, (String)"android.permission.CHANGE_WIFI_STATE");
    }

    public static boolean i(Context context) {
        return Validator.isPermissionEnabled((Context)context, (String)"android.permission.RECEIVE_BOOT_COMPLETED");
    }

    public static boolean j(Context context) {
        return Validator.isPermissionEnabled((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") || Validator.isPermissionEnabled((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION");
    }

    public static void k(Context context) {
        Validator.manifest((Context)context);
        as.e(context);
        as.d(context);
    }

    public static void a() {
        Validator.libraryDependencies();
    }

    public boolean b() {
        return as.h(a.a());
    }

    public boolean c() {
        return as.i(a.a());
    }

    public boolean d() {
        return Validator.isPermissionEnabled((Context)a.a(), (String)"android.permission.ACCESS_FINE_LOCATION");
    }

    public boolean e() {
        return Validator.isPermissionEnabled((Context)a.a(), (String)"android.permission.ACCESS_COARSE_LOCATION");
    }

    public boolean a(Location location) {
        boolean bl2 = false;
        if (location != null) {
            try {
                if (Validator.isAboveOrEqualsAndroid23()) {
                    AppOpsManager appOpsManager = (AppOpsManager)a.a().getSystemService("appops");
                    if (appOpsManager != null) {
                        bl2 = appOpsManager.checkOp("android:mock_location", Process.myUid(), a.a().getPackageName()) == 0;
                    }
                    bl2 = bl2 || location.isFromMockProvider();
                } else {
                    bl2 = Validator.isAboveOrEqualsToAndroid18() ? location.isFromMockProvider() : !Settings.Secure.getString((ContentResolver)a.a().getContentResolver(), (String)"mock_location").equals("0");
                }
            }
            catch (Exception exception) {
                DevLogger.w((String)("Failed to detect mock location: " + exception.getMessage()), (Throwable)exception);
            }
        }
        return bl2;
    }

    public String f() {
        return Validator.checkDeviceIrregularity();
    }
}

