/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.permissions.PermissionsListener;
import com.inlocomedia.android.core.private.dx;
import com.inlocomedia.android.core.private.dz;
import com.inlocomedia.android.core.private.ea;
import com.inlocomedia.android.core.private.ee;
import com.inlocomedia.android.core.private.ej;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoOptions;
import com.inlocomedia.android.location.i;
import com.inlocomedia.android.location.private.al;
import com.inlocomedia.android.location.private.an;
import com.inlocomedia.android.location.private.cf;
import com.inlocomedia.android.location.private.n;
import java.util.Map;

public final class InLoco {
    private InLoco() {
    }

    public static void init(@NonNull Context context, InLocoOptions options) {
        an.g.a(context.getApplicationContext(), options);
    }

    public static void setLocationTrackingEnabled(final Context context, boolean enabled) {
        if (enabled && !InLoco.hasGivenPrivacyConsent(context)) {
            DevLogger.i((String)"It is not possible to enable location tracking because the user has not given privacy consent");
            return;
        }
        an.a.a(context);
        InLocoOptions.getInstance(context).setLocationTrackingEnabled(enabled);
        if (enabled) {
            i.b.a(context, al.a(context));
        } else {
            i.b.b(context);
        }
        dx.m().b((ej)dz.b()).b((ea)new ee(){

            public void a() {
                cf.o().a(InLocoOptions.getInstance(context));
            }
        }).a((Thread.UncaughtExceptionHandler)an.a).b();
    }

    public static void givePrivacyConsent(final Context context, boolean consent) {
        if (consent) {
            DevLogger.i((String)"User has given privacy consent");
        } else {
            DevLogger.i((String)"User has revoked privacy consent");
        }
        InLocoOptions inLocoOptions = InLocoOptions.getInstance(context);
        inLocoOptions.givePrivacyConsent(consent);
        an.a.a(context);
        cf.e().a(!inLocoOptions.hasGivenPrivacyConsent());
        if (InLoco.hasGivenPrivacyConsent(context) && InLoco.isLocationTrackingEnabled(context)) {
            DevLogger.i((String)"Enabling location tracking");
            i.b.a(context, al.a(context));
        } else {
            DevLogger.i((String)"Disabling location tracking");
            i.b.b(context);
        }
        dx.m().b((ej)dz.b()).b((ea)new ee(){

            public void a() {
                cf.o().a(InLocoOptions.getInstance(context));
            }
        }).a((Thread.UncaughtExceptionHandler)an.a).b();
    }

    public static boolean hasGivenPrivacyConsent(Context context) {
        return InLocoOptions.getInstance(context).hasGivenPrivacyConsent();
    }

    public static boolean isWaitingUserPrivacyConsent(Context context) {
        return InLocoOptions.getInstance(context).isWaitingUserPrivacyConsent();
    }

    public static boolean isLocationTrackingEnabled(Context context) {
        return InLocoOptions.getInstance(context).isLocationTrackingEnabled();
    }

    public static void requestLocationPermission(Activity context, boolean askIfDenied) {
        an.a.a((Context)context);
        cf.l().a(context, askIfDenied);
    }

    public static void requestCoarseLocationPermission(Activity context, boolean askIfDenied) {
        an.a.a((Context)context);
        cf.l().a(context, askIfDenied);
    }

    public static void requestPermissions(Activity context, String[] permissions, boolean askIfDenied, PermissionsListener listener) {
        an.a.a((Context)context);
        cf.b().a((Context)context, permissions, askIfDenied, listener);
    }

    public static void trackEvent(Context context, String eventName) {
        InLoco.trackEvent(context, eventName, null);
    }

    public static void trackEvent(final Context context, final String eventName, final Map<String, String> properties) {
        try {
            Validator.notNull((Object)eventName, (String)"eventName");
            dx.m().b((ej)dz.b()).b((ea)new ee(){

                public void a() {
                    an.a.a(context, InLocoOptions.getInstance(context));
                    n n2 = cf.g();
                    n2.a(eventName, properties);
                }
            }).a((ea)new ee(){

                public void a() throws Throwable {
                    DevLogger.i((String)("Event logged successfully: " + eventName + " " + properties));
                }
            }).a((Thread.UncaughtExceptionHandler)an.a).b();
        }
        catch (Throwable throwable) {
            DevLogger.w((String)("Could not track event " + eventName), (Throwable)throwable);
        }
    }
}

