/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.geofencing;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.inlocomedia.android.core.data.local.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseListener;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseWrapper;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.geofencing.SimpleGeofence;
import com.inlocomedia.android.location.geofencing.c;
import com.inlocomedia.android.location.geofencing.d;
import com.inlocomedia.android.location.geofencing.p;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class a
implements SQLiteDatabaseListener {
    private static final String b = Logger.makeTag(a.class);
    @VisibleForTesting
    LazyCloseSQLiteOpenHelper a;

    a(Context context, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.a = new LazyCloseSQLiteOpenHelper(context, "inlocomedia_bxxuif", null, 6, uncaughtExceptionHandler);
        this.a.setDatabaseListener((SQLiteDatabaseListener)this);
    }

    public void onCreate(SQLiteDatabaseWrapper db) {
        try {
            db.execSQL("CREATE TABLE geofences(_id INTEGER PRIMARY KEY AUTOINCREMENT, category TEXT, type INTEGER, geofence_id TEXT, latitude REAL, longitude REAL, radius REAL, expiration_date INTEGER, in_poll_rate INTEGER, out_poll_rate INTEGER, transition_types INTEGER, initial_trigger INTEGER, monitored_transition INTEGER, track_transition INTEGER, register_transition_url TEXT, loitering_delay INTEGER, resp_delay INTEGER);");
            db.execSQL("CREATE TABLE monitored_retails(_id INTEGER PRIMARY KEY AUTOINCREMENT, geofence_id TEXT, retail_id TEXT);");
            db.execSQL("CREATE TABLE visiting_geofences(_id INTEGER PRIMARY KEY AUTOINCREMENT, geofence_id TEXT,last_polling_timestamp TEXT, visit_timestamp TEXT, triggered_dwell TEXT);");
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
    }

    public void onUpgrade(SQLiteDatabaseWrapper db, int oldVersion, int newVersion) {
        try {
            db.execSQL("DROP TABLE IF EXISTS geofences");
            db.execSQL("DROP TABLE IF EXISTS monitored_retails");
            db.execSQL("DROP TABLE IF EXISTS visiting_geofences");
            this.onCreate(db);
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
    }

    public void onDowngrade(SQLiteDatabaseWrapper db, int oldVersion, int newVersion) {
        try {
            db.execSQL("DROP TABLE IF EXISTS geofences");
            db.execSQL("DROP TABLE IF EXISTS monitored_retails");
            this.onCreate(db);
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
    }

    protected void a(Collection<SimpleGeofence> collection) {
        try {
            if (collection.size() <= 0) {
                return;
            }
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d();
            sQLiteDatabaseWrapper.beginTransaction();
            for (SimpleGeofence simpleGeofence : collection) {
                ContentValues contentValues = com.inlocomedia.android.location.geofencing.a.a(simpleGeofence);
                sQLiteDatabaseWrapper.insert("geofences", contentValues);
            }
            for (SimpleGeofence simpleGeofence : collection) {
                for (String string : simpleGeofence.monitoredRetailIds) {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("geofence_id", simpleGeofence.id);
                    contentValues.put("retail_id", string);
                    sQLiteDatabaseWrapper.insert("monitored_retails", contentValues);
                }
            }
            sQLiteDatabaseWrapper.setTransactionSuccessful();
            sQLiteDatabaseWrapper.endTransaction();
            this.a.closeDatabase();
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
    }

    public void a(d d2) {
        try {
            if (d2.a() <= 0) {
                return;
            }
            List<String> list = p.a(d2);
            Collection<SimpleGeofence> collection = this.d(list);
            if (collection == null || collection.size() != d2.a()) {
                return;
            }
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d();
            sQLiteDatabaseWrapper.beginTransaction();
            for (Map.Entry<SimpleGeofence, c> entry : d2.b()) {
                ContentValues contentValues = com.inlocomedia.android.location.geofencing.a.a(entry.getKey(), entry.getValue());
                sQLiteDatabaseWrapper.insert("visiting_geofences", contentValues);
            }
            sQLiteDatabaseWrapper.setTransactionSuccessful();
            sQLiteDatabaseWrapper.endTransaction();
            this.a.closeDatabase();
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
    }

    protected void b(Collection<SimpleGeofence> collection) {
        this.a("visiting_geofences", collection);
        this.a("geofences", collection);
    }

    protected void c(Collection<SimpleGeofence> collection) {
        this.a("visiting_geofences", collection);
    }

    private void a(String string, Collection<SimpleGeofence> collection) {
        try {
            if (collection.size() <= 0) {
                return;
            }
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d();
            sQLiteDatabaseWrapper.beginTransaction();
            List<String> list = p.d(collection);
            String string2 = TextUtils.join((CharSequence)"', '", list);
            String string3 = "DELETE FROM %s WHERE %s IN ('%s');";
            String string4 = String.format("DELETE FROM %s WHERE %s IN ('%s');", string, "geofence_id", string2);
            sQLiteDatabaseWrapper.execSQL(string4);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
            sQLiteDatabaseWrapper.endTransaction();
            this.a.closeDatabase();
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected Collection<SimpleGeofence> a() {
        Collection<SimpleGeofence> collection = null;
        Cursor cursor = null;
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d();
            cursor = sQLiteDatabaseWrapper.queryAll("geofences");
            collection = com.inlocomedia.android.location.geofencing.a.a(sQLiteDatabaseWrapper, cursor);
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.a.closeDatabase();
        }
        if (collection == null) {
            collection = new ArrayList<SimpleGeofence>();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected Collection<SimpleGeofence> b() {
        Cursor cursor = null;
        Collection<Object> collection = null;
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d();
            cursor = sQLiteDatabaseWrapper.query("geofences", null, "type=?", new String[]{String.valueOf(1)}, null, null, null);
            if (cursor.moveToFirst()) {
                collection = com.inlocomedia.android.location.geofencing.a.a(sQLiteDatabaseWrapper, cursor);
            }
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.a.closeDatabase();
        }
        if (collection == null) {
            collection = new ArrayList();
        }
        return collection;
    }

    protected Collection<SimpleGeofence> d(Collection<String> collection) {
        return this.b("geofence_id", collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SimpleGeofence> b(String string, Collection<?> collection) {
        Cursor cursor = null;
        Collection<Object> collection2 = null;
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d();
            String string2 = TextUtils.join((CharSequence)"', '", collection);
            String string3 = "SELECT * FROM %s WHERE %s IN ('%s');";
            String string4 = String.format("SELECT * FROM %s WHERE %s IN ('%s');", "geofences", string, string2);
            cursor = sQLiteDatabaseWrapper.rawQuery(string4);
            if (cursor.moveToFirst()) {
                collection2 = com.inlocomedia.android.location.geofencing.a.a(sQLiteDatabaseWrapper, cursor);
            }
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.a.closeDatabase();
        }
        if (collection2 == null) {
            collection2 = new ArrayList();
        }
        return collection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected d c() {
        Cursor cursor = null;
        d d2 = new d();
        try {
            Collection<SimpleGeofence> collection;
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d();
            cursor = sQLiteDatabaseWrapper.queryAll("visiting_geofences");
            HashMap<String, c> hashMap = new HashMap<String, c>();
            if (cursor.moveToFirst()) {
                int n2 = cursor.getColumnIndex("geofence_id");
                int n3 = cursor.getColumnIndex("visit_timestamp");
                int n4 = cursor.getColumnIndex("last_polling_timestamp");
                int n5 = cursor.getColumnIndex("triggered_dwell");
                do {
                    hashMap.put(cursor.getString(n2), new c(cursor.getLong(n3), cursor.getLong(n4), cursor.getInt(n5) != 0));
                } while (cursor.moveToNext());
            }
            if ((collection = this.d(hashMap.keySet())) != null) {
                for (SimpleGeofence simpleGeofence : collection) {
                    d2.a(simpleGeofence, (c)hashMap.get(simpleGeofence.id));
                }
            }
        }
        catch (Throwable throwable) {
            this.a.onUnexpectedError(throwable);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.a.closeDatabase();
        }
        return d2;
    }

    private SQLiteDatabaseWrapper d() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.a.openDatabase();
        Validator.notNull((Object)sQLiteDatabaseWrapper, (String)"Geofence Database");
        return sQLiteDatabaseWrapper;
    }

    private static Collection<SimpleGeofence> a(SQLiteDatabaseWrapper sQLiteDatabaseWrapper, Cursor cursor) {
        ArrayList<SimpleGeofence> arrayList = new ArrayList<SimpleGeofence>();
        if (cursor.moveToFirst()) {
            int n2 = cursor.getColumnIndex("type");
            int n3 = cursor.getColumnIndex("category");
            int n4 = cursor.getColumnIndex("geofence_id");
            int n5 = cursor.getColumnIndex("latitude");
            int n6 = cursor.getColumnIndex("longitude");
            int n7 = cursor.getColumnIndex("radius");
            int n8 = cursor.getColumnIndex("expiration_date");
            int n9 = cursor.getColumnIndex("in_poll_rate");
            int n10 = cursor.getColumnIndex("out_poll_rate");
            int n11 = cursor.getColumnIndex("transition_types");
            int n12 = cursor.getColumnIndex("initial_trigger");
            int n13 = cursor.getColumnIndex("monitored_transition");
            int n14 = cursor.getColumnIndex("track_transition");
            int n15 = cursor.getColumnIndex("register_transition_url");
            int n16 = cursor.getColumnIndex("loitering_delay");
            int n17 = cursor.getColumnIndex("resp_delay");
            do {
                SimpleGeofence.a a2 = new SimpleGeofence.a();
                a2.a(cursor.getInt(n2));
                a2.a(cursor.getString(n3));
                a2.b(cursor.getString(n4));
                a2.a(cursor.getDouble(n5));
                a2.b(cursor.getDouble(n6));
                a2.c(cursor.getDouble(n7));
                a2.a(cursor.getLong(n8));
                a2.b(cursor.getLong(n9));
                a2.c(cursor.getLong(n10));
                a2.b(cursor.getInt(n11));
                a2.d(cursor.getInt(n12));
                a2.c(cursor.getInt(n13));
                a2.a(cursor.getInt(n14) != 0);
                a2.c(cursor.getString(n15));
                a2.e(cursor.getInt(n16));
                a2.f(cursor.getInt(n17));
                a2.a(com.inlocomedia.android.location.geofencing.a.a(sQLiteDatabaseWrapper, cursor.getString(n4)));
                arrayList.add(a2.a());
            } while (cursor.moveToNext());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> a(SQLiteDatabaseWrapper sQLiteDatabaseWrapper, String string) {
        try (Cursor cursor = null;){
            cursor = sQLiteDatabaseWrapper.query("monitored_retails", null, "geofence_id=?", new String[]{string}, null, null, null);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = cursor.getColumnIndex("_id");
            int n3 = cursor.getColumnIndex("retail_id");
            while (cursor.moveToNext()) {
                if (cursor.isNull(n2) || cursor.isNull(n3)) continue;
                arrayList.add(cursor.getString(n3));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @VisibleForTesting
    private static ContentValues a(SimpleGeofence simpleGeofence) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(simpleGeofence.type));
        contentValues.put("category", simpleGeofence.category);
        contentValues.put("geofence_id", simpleGeofence.id);
        contentValues.put("latitude", Double.valueOf(simpleGeofence.latitude));
        contentValues.put("longitude", Double.valueOf(simpleGeofence.longitude));
        contentValues.put("radius", Double.valueOf(simpleGeofence.radius));
        contentValues.put("expiration_date", Long.valueOf(simpleGeofence.expirationDate));
        contentValues.put("in_poll_rate", Long.valueOf(simpleGeofence.inPollRate));
        contentValues.put("out_poll_rate", Long.valueOf(simpleGeofence.outPollRate));
        contentValues.put("transition_types", Integer.valueOf(simpleGeofence.triggeringTransitionTypes));
        contentValues.put("initial_trigger", Integer.valueOf(simpleGeofence.initialTriggerTransitions));
        contentValues.put("monitored_transition", Integer.valueOf(simpleGeofence.monitoredTransitions));
        contentValues.put("track_transition", Integer.valueOf(simpleGeofence.trackTransition ? 1 : 0));
        contentValues.put("register_transition_url", simpleGeofence.registerTransitionUrl);
        contentValues.put("loitering_delay", Integer.valueOf(simpleGeofence.loiteringDelay));
        contentValues.put("resp_delay", Integer.valueOf(simpleGeofence.responsivenessDelay));
        return contentValues;
    }

    @VisibleForTesting
    static ContentValues a(SimpleGeofence simpleGeofence, c c2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("geofence_id", simpleGeofence.id);
        contentValues.put("visit_timestamp", Long.valueOf(c2.b));
        contentValues.put("last_polling_timestamp", Long.valueOf(c2.a));
        contentValues.put("triggered_dwell", Boolean.valueOf(c2.c));
        return contentValues;
    }
}

