/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.communication.Request;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.communication.listeners.ImageRequestListener;
import com.inlocomedia.android.core.exception.InLocoMediaAPIException;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.permissions.PermissionsListener;
import com.inlocomedia.android.core.permissions.PermissionsManager;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.location.InLocoOptions;
import com.inlocomedia.android.location.LocationError;
import com.inlocomedia.android.location.core.communication.listeners.RetailMapImageRequestListener;
import com.inlocomedia.android.location.core.communication.listeners.RetailMapsRequestListener;
import com.inlocomedia.android.location.core.communication.listeners.RetailsRequestListener;
import com.inlocomedia.android.location.core.communication.listeners.StoresRequestListener;
import com.inlocomedia.android.location.d;
import com.inlocomedia.android.location.exception.LocationExceptionMapping;
import com.inlocomedia.android.location.listeners.LocationListener;
import com.inlocomedia.android.location.models.Retail;
import com.inlocomedia.android.location.models.RetailMap;
import com.inlocomedia.android.location.models.Store;
import com.inlocomedia.android.location.models.e;
import com.inlocomedia.android.location.private.al;
import com.inlocomedia.android.location.private.am;
import com.inlocomedia.android.location.private.as;
import com.inlocomedia.android.location.private.bf;
import com.inlocomedia.android.location.private.bw;
import com.inlocomedia.android.location.private.t;
import com.inlocomedia.android.location.private.u;
import com.inlocomedia.android.location.private.v;
import java.util.List;
import java.util.Locale;

public final class InLoco {
    private InLoco() {
    }

    public static void init(@NonNull Context context, InLocoOptions options) {
        v.a(context.getApplicationContext(), options, new Module[]{u.b.e});
    }

    public static void setLocationTrackingEnabled(Context context, boolean enabled) {
        InLocoOptions.getInstance(context).setLocationTrackingEnabled(enabled);
        if (enabled) {
            d.b.a(context, t.d(context));
        } else {
            d.b.a(context);
        }
    }

    public static boolean isLocationTrackingEnabled(Context context) {
        return InLocoOptions.getInstance(context).isLocationTrackingEnabled();
    }

    public static void requestRetails(Context context, final RetailsRequestListener listener) {
        as.a(context, new RequestListener<List<Retail>>(){

            public void a(final List<Retail> list) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFinished(list);
                    }
                });
            }

            public void onRequestFailed(final InLocoMediaException error) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFailed(LocationExceptionMapping.parseException(error));
                    }
                });
            }

            public /* synthetic */ void onRequestFinished(Object object) {
                this.a((List)object);
            }
        });
    }

    public static Request requestRetailImage(Context context, String retailId, final ImageRequestListener listener) {
        return as.a(context, retailId, new RequestListener<Bitmap>(){

            public void a(final Bitmap bitmap) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFinished(bitmap);
                    }
                });
            }

            public void onRequestFailed(final InLocoMediaException error) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFailed(LocationExceptionMapping.parseException(error));
                    }
                });
            }

            public /* synthetic */ void onRequestFinished(Object object) {
                this.a((Bitmap)object);
            }
        });
    }

    public static Request requestRetailImageThumbnail(Context context, String retailId, final ImageRequestListener listener) {
        return as.b(context, retailId, new RequestListener<Bitmap>(){

            public void a(final Bitmap bitmap) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFinished(bitmap);
                    }
                });
            }

            public void onRequestFailed(final InLocoMediaException error) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFailed(LocationExceptionMapping.parseException(error));
                    }
                });
            }

            public /* synthetic */ void onRequestFinished(Object object) {
                this.a((Bitmap)object);
            }
        });
    }

    public static Request requestMaps(Context context, String retailId, final RetailMapsRequestListener listener) throws InLocoMediaAPIException {
        return as.c(context, retailId, new RequestListener<List<RetailMap>>(){

            public void a(final List<RetailMap> list) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFinished(list);
                    }
                });
            }

            public void onRequestFailed(final InLocoMediaException error) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFailed(LocationExceptionMapping.parseException(error));
                    }
                });
            }

            public /* synthetic */ void onRequestFinished(Object object) {
                this.a((List)object);
            }
        });
    }

    public static Request requestMapImage(Context context, String retailId, String mapId, RetailMapImageRequestListener listener) {
        return InLoco.requestMapImage(context, retailId, mapId, true, listener);
    }

    public static Request requestMapImage(Context context, String retailId, String mapId, boolean useCache, final RetailMapImageRequestListener listener) {
        return as.a(context, retailId, mapId, useCache, new RequestListener<e>(){

            public void a(final e e2) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFinished(e2);
                    }
                });
            }

            public void onRequestFailed(final InLocoMediaException error) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFailed(LocationExceptionMapping.parseException(error));
                    }
                });
            }

            public /* synthetic */ void onRequestFinished(Object object) {
                this.a((e)object);
            }
        });
    }

    public static Request requestStores(Context context, String retailId, Locale locale, final StoresRequestListener listener) {
        return as.a(context, retailId, locale, new RequestListener<List<Store>>(){

            public void a(final List<Store> list) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFinished(list);
                    }
                });
            }

            public void onRequestFailed(final InLocoMediaException error) {
                ThreadPool.executeInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onRequestFailed(LocationExceptionMapping.parseException(error));
                    }
                });
            }

            public /* synthetic */ void onRequestFinished(Object object) {
                this.a((List)object);
            }
        });
    }

    public static void requestMapsLocationUpdates(Context context, LocationListener listener) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            bf.a(context, listener, new am());
        } else {
            DevLogger.i((String)"You have to activate Background Location Tracking in order to request location updates");
            listener.onLocationError(LocationError.UNAVAILABLE);
        }
    }

    public static void removeMapsLocationUpdates(Context context, LocationListener listener) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            bf.a(context, listener);
        } else {
            DevLogger.i((String)"No Location updates registered, as Background Location Tracking is disabled");
            listener.onLocationError(LocationError.UNAVAILABLE);
        }
    }

    public static void requestLocationUpdates(Context context, LocationListener listener) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            bf.a(context, listener, new al(){

                @Override
                public bw a() {
                    return bw.d;
                }
            });
        } else {
            DevLogger.i((String)"You have to activate Background Location Tracking in order to request location updates");
            listener.onLocationError(LocationError.UNAVAILABLE);
        }
    }

    public static void removeLocationUpdates(Context context, LocationListener listener) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            bf.a(context, listener);
        } else {
            DevLogger.i((String)"No Location updates registered, as Background Location Tracking is disabled");
            listener.onLocationError(LocationError.UNAVAILABLE);
        }
    }

    public static void requestMapsLocation(Context context, LocationListener listener) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            bf.b(context, listener, new am());
        } else {
            DevLogger.i((String)"You have to activate Background Location Tracking in order to request location updates");
            listener.onLocationError(LocationError.UNAVAILABLE);
        }
    }

    public static void requestLocation(Context context, LocationListener listener) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            bf.b(context, listener, new al());
        } else {
            DevLogger.i((String)"You have to activate Background Location Tracking in order to request location updates");
            listener.onLocationError(LocationError.UNAVAILABLE);
        }
    }

    public static void requestLocationPermission(Activity context, boolean askIfDenied) {
        if (InLocoOptions.getInstance((Context)context).isLocationTrackingEnabled()) {
            bf.a(context, askIfDenied);
        } else {
            DevLogger.i((String)"You have to activate Background Location Tracking in order to request location updates");
        }
    }

    public static void requestCoarseLocationPermission(Activity context, boolean askIfDenied) {
        if (InLocoOptions.getInstance((Context)context).isLocationTrackingEnabled()) {
            bf.a(context, askIfDenied);
        } else {
            DevLogger.i((String)"You have to activate Background Location Tracking in order to request location updates");
        }
    }

    public static void requestPermissions(Activity context, String[] permissions, boolean askIfDenied, PermissionsListener listener) {
        if (InLocoOptions.getInstance((Context)context).isLocationTrackingEnabled()) {
            PermissionsManager.getInstance().requestPermissions((Context)context, permissions, askIfDenied, listener);
        } else {
            DevLogger.i((String)"You have to activate Background Location Tracking in order to request location updates");
        }
    }
}

