/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.maps.views;

import android.content.Context;
import android.graphics.PointF;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.resources.ui.views.InteractiveView;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.R;
import com.inlocomedia.android.location.exception.RetailMapImageInvalidException;
import com.inlocomedia.android.location.maps.MapViewLoadListener;
import com.inlocomedia.android.location.maps.views.MapImageView;
import com.inlocomedia.android.location.maps.views.RouteView;
import com.inlocomedia.android.location.maps.views.UserPositionView;
import com.inlocomedia.android.location.models.Location;
import com.inlocomedia.android.location.models.Retail;
import com.inlocomedia.android.location.models.RetailMap;
import com.inlocomedia.android.location.models.Store;
import com.inlocomedia.android.location.models.e;
import com.inlocomedia.android.location.private.av;
import com.inlocomedia.android.location.private.ba;
import java.util.List;

public class IndoorMapView
extends InteractiveView {
    static final String TAG = Logger.makeTag(IndoorMapView.class);
    private static final long PERIOD_FOR_60_FPS = 16L;
    private static final String MAIN_THREAD_VALIDATION_TAG = "IndoorMapView data change error";
    private com.inlocomedia.android.location.maps.a mManager;
    private com.inlocomedia.android.location.maps.views.a mBalloonView;
    private com.inlocomedia.android.location.maps.views.b mCloseRouteView;
    private RouteView mRouteView;
    private MapImageView mMapImageView;
    private UserPositionView mUserPositionView;
    private a mStoresListener;
    private RetailMap mRetailMap;
    private Store mClickedStore;
    private boolean mIsTrackUserEnabled;
    private int mBalloonLayoutResId;
    private int mCloseRouteLayoutResId;
    private int mCloseRouteGravity;
    private int mCloseRouteXOffset;
    private int mCloseRouteYOffset;
    private int mDifferentFloorsErrorStringId;
    private int mRouteNotAvailableErrorStringId;
    private long mLastValidUserLocationReceivedTimestamp;
    private b mState;
    private Options mOptions;

    public IndoorMapView(Context context) {
        super(context);
        this.init(context);
    }

    public IndoorMapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public IndoorMapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        if (this.isInEditMode()) {
            return;
        }
        this.setLayerType(1, null);
        this.setBalloonLayoutResId(R.layout.ilm_balloon);
        this.setCloseRouteLayout(R.layout.ilm_close_route);
        this.setDifferentFloorsErrorStringId(R.string.ilm_error_different_floors);
        this.setRouteNotAvailableErrorStringId(R.string.ilm_error_graph_not_found);
        this.mOptions = Options.defaultOptions();
        this.mState = b.a;
        this.mManager = new com.inlocomedia.android.location.maps.a(this);
        this.mMapImageView = new MapImageView(context);
        this.mCloseRouteGravity = 112;
        this.addView(this.mMapImageView);
    }

    public void setOptions(Options options) {
        if (this.mState != b.a) {
            throw new UnsupportedOperationException("You can not change the map options after loading it");
        }
        this.mOptions = options;
    }

    public void setRetail(Retail retail) {
        this.setRetail(retail, null);
    }

    public void setRetail(Retail retail, MapViewLoadListener listener) {
        Validator.mainThread((String)MAIN_THREAD_VALIDATION_TAG);
        this.mManager.a(retail, listener);
    }

    public void setRetailById(String retailId, MapViewLoadListener listener) {
        Retail retail = new Retail();
        retail.setId(retailId);
        this.mManager.a(retail, listener);
    }

    public void setRetailMap(RetailMap retailMap) {
        this.mManager.a(retailMap);
    }

    public void setNextFloor() {
        Validator.mainThread((String)MAIN_THREAD_VALIDATION_TAG);
        this.mManager.a();
    }

    public void setPreviousFloor() {
        Validator.mainThread((String)MAIN_THREAD_VALIDATION_TAG);
        this.mManager.b();
    }

    public boolean hasNextFloor() {
        return this.mManager.c();
    }

    public boolean hasPreviousFloor() {
        return this.mManager.d();
    }

    public boolean isRetailLoaded() {
        return this.mManager.e();
    }

    public boolean hasRetailMapLoaded() {
        return this.mRetailMap != null;
    }

    public void loadRetailMap(RetailMap retailMap, e mapSvgObjectManager) throws RetailMapImageInvalidException {
        this.setVisibility(4);
        b b2 = this.mState;
        if (this.mState == b.a) {
            b2 = b.b;
        }
        this.unattachChildren();
        if (this.mMapImageView.getMapDrawable() != null) {
            this.mMapImageView.b();
        }
        if (retailMap != null && mapSvgObjectManager != null) {
            this.mMapImageView.a(retailMap, mapSvgObjectManager);
            this.addView(this.mMapImageView);
            if (this.mOptions.routeEnabled) {
                if (this.mRouteView == null) {
                    this.mRouteView = new RouteView(this.getContext());
                }
                this.mRouteView.a(retailMap, mapSvgObjectManager);
                this.addView(this.mRouteView);
                if (this.mCloseRouteView != null) {
                    this.bringChildToFront((View)this.mCloseRouteView);
                }
            }
            if (this.mOptions.userInteractionEnabled && this.mClickedStore != null && this.mClickedStore.getRetailMapId().equals(retailMap.getId())) {
                this.addView((View)this.mBalloonView);
            }
            if (this.mOptions.userPositionEnabled) {
                Location location;
                if (this.mUserPositionView == null) {
                    this.mUserPositionView = new UserPositionView(this.getContext());
                }
                if ((location = this.mUserPositionView.getUserPosition()) != null && location.getFloor().intValue() == retailMap.getFloor()) {
                    this.addView(this.mUserPositionView);
                }
            }
        } else {
            throw new RetailMapImageInvalidException("The RetailMap either does not possess a bitmap or it is recycled");
        }
        this.setCenterView(this.mMapImageView);
        this.centralize(this.mMapImageView, false);
        this.setVisibility(0);
        this.mIsTrackUserEnabled = false;
        this.mState = b2;
        this.mRetailMap = retailMap;
        this.invalidate();
    }

    public void setOnMapViewLoadListener(MapViewLoadListener listener) {
        this.mManager.a(listener);
    }

    public void setOnStoreClickListener(a listener) {
        this.mStoresListener = listener;
    }

    private void unattachChildren() {
        this.setCenterView(null);
        if (this.mMapImageView != null && this.mMapImageView.getParent() != null) {
            this.removeView(this.mMapImageView);
        }
        if (this.mUserPositionView != null && this.mUserPositionView.getParent() != null) {
            this.removeView(this.mUserPositionView);
        }
        if (this.mRouteView != null && this.mRouteView.getParent() != null) {
            this.removeView(this.mRouteView);
        }
        if (this.mBalloonView != null && this.mBalloonView.getParent() != null) {
            this.removeView((View)this.mBalloonView);
        }
    }

    public void clear() {
        this.mManager.f();
        this.unattachChildren();
        if (this.mMapImageView != null && this.mMapImageView.getMapDrawable() != null) {
            this.mMapImageView.b();
        }
    }

    public void setUserLocation(Location location) {
        long l2;
        if (this.mManager.a(location) && (l2 = SystemClock.elapsedRealtime()) > this.mLastValidUserLocationReceivedTimestamp + 16L) {
            int n2;
            this.mLastValidUserLocationReceivedTimestamp = l2;
            if (this.mOptions.userPositionEnabled) {
                if (this.mUserPositionView == null) {
                    this.mUserPositionView = new UserPositionView(this.getContext());
                }
                int n3 = n2 = location != null && this.mRetailMap != null && location.getFloor().intValue() == this.mRetailMap.getFloor() ? 1 : 0;
                if (this.mUserPositionView.getParent() == null) {
                    if (n2 != 0) {
                        this.addView(this.mUserPositionView);
                    }
                } else if (n2 == 0) {
                    this.removeView(this.mUserPositionView);
                }
                this.mUserPositionView.setUserPosition(location);
            }
            if (this.mOptions.routeEnabled && location != null && (this.mState == b.c || this.mState == b.d)) {
                n2 = this.mRouteView.a(location.getPoint(), this.mManager.a((int)location.getFloor()));
                if (n2 > 0 && n2 <= 5) {
                    this.onGoalIsReached();
                } else if (n2 > 5) {
                    this.mCloseRouteView.a(false);
                    this.mState = b.c;
                }
                if (this.mIsTrackUserEnabled) {
                    this.centralize(this.mUserPositionView, false);
                }
            }
            this.invalidate();
        }
    }

    public void focusOnUserPosition() {
        this.centralize(this.mUserPositionView, false);
    }

    public void onLongPress(PointF p2) {
    }

    public void onPointClick(PointF p2) {
        if (this.mOptions.isUserInteractionEnabled()) {
            switch (this.mState) {
                case a: {
                    break;
                }
                case b: 
                case c: 
                case d: {
                    Store store = this.mMapImageView.b(p2);
                    if (store != null) {
                        this.onStoreSelected(store);
                        break;
                    }
                    this.dismissBalloon();
                }
            }
        }
    }

    public void onStoreSelected(Store store) {
        if (((Object)((Object)store)).equals((Object)this.mClickedStore) || this.mRetailMap == null || !this.mRetailMap.getId().equals(store.getRetailMapId())) {
            return;
        }
        if (this.mStoresListener != null) {
            this.mStoresListener.a(store);
        }
        this.showBalloonOnStore(store);
    }

    private void showBalloonOnStore(final Store store) {
        if (this.mBalloonLayoutResId != 0) {
            this.dismissBalloon();
            this.mBalloonView = new com.inlocomedia.android.location.maps.views.a(this.getContext(), store, this.mBalloonLayoutResId);
            this.mBalloonView.a(new View.OnClickListener(){

                public void onClick(View v2) {
                    IndoorMapView.this.onTraceRouteClick(store);
                }
            });
            this.addView((View)this.mBalloonView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            this.centralize((View)this.mBalloonView, true);
            this.mClickedStore = store;
        }
    }

    private void onTraceRouteClick(Store store) {
        Location location = this.mUserPositionView.getUserPosition();
        if (this.mRouteView.b() && location != null) {
            if (location.getFloor().intValue() == this.mRetailMap.getFloor()) {
                this.dismissBalloon();
                if (this.traceRouteFromUser(store) == 1) {
                    this.onGoalIsReached();
                } else {
                    this.showHighlightStore(store);
                    this.showCloseRouteView();
                    this.centralize(this.mRouteView, true);
                    this.mIsTrackUserEnabled = true;
                    this.mState = b.c;
                }
            } else {
                RetailMap retailMap = this.mManager.b(location.getFloor());
                if (retailMap != null && this.mDifferentFloorsErrorStringId != 0) {
                    String string2 = this.getContext().getString(this.mDifferentFloorsErrorStringId);
                    this.mBalloonView.a(String.format(string2, retailMap.getName(), this.mRetailMap.getName()));
                }
            }
        } else if (this.mRouteNotAvailableErrorStringId != 0) {
            String string3 = this.getContext().getString(this.mRouteNotAvailableErrorStringId);
            this.mBalloonView.a(string3, 3000L);
        }
    }

    private void onGoalIsReached() {
        if (this.mState != b.d) {
            if (this.mCloseRouteView != null) {
                this.mCloseRouteView.a(true);
            }
            this.mState = b.d;
        }
    }

    private void dismissBalloon() {
        this.removeView((View)this.mBalloonView);
        this.mBalloonView = null;
        this.mClickedStore = null;
    }

    private void showCloseRouteView() {
        if (this.mCloseRouteLayoutResId != 0) {
            if (this.mCloseRouteView == null) {
                this.mCloseRouteView = new com.inlocomedia.android.location.maps.views.b(this.getContext(), this.mCloseRouteLayoutResId, this.mCloseRouteGravity, this.mCloseRouteXOffset, this.mCloseRouteYOffset);
                this.mCloseRouteView.a(new View.OnClickListener(){

                    public void onClick(View v2) {
                        IndoorMapView.this.onCloseRouteButtonClick();
                    }
                });
                this.addView((View)this.mCloseRouteView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, this.mCloseRouteGravity));
            }
            this.mCloseRouteView.a(false);
            this.mCloseRouteView.setVisibility(0);
        }
    }

    private void onCloseRouteButtonClick() {
        this.mRouteView.a();
        this.mCloseRouteView.setVisibility(8);
        this.dismissHighlightStore();
        this.mState = b.b;
    }

    private void showHighlightStore(Store store) {
        this.mMapImageView.a(store.getPoint());
    }

    private void dismissHighlightStore() {
        this.mMapImageView.a();
    }

    public void setTrackUserEnabled(boolean enabled) {
        this.mIsTrackUserEnabled = enabled;
        if (enabled) {
            this.focusOnUserPosition();
        }
    }

    public boolean isTrackUserEnabled() {
        return this.mIsTrackUserEnabled;
    }

    public int traceRouteFromUser(Store store) {
        if (this.mRouteView == null) {
            return -1;
        }
        PointF pointF = this.mUserPositionView.getUserPosition().getPoint();
        RetailMap retailMap = this.mManager.a((int)this.mUserPositionView.getUserPosition().getFloor());
        return this.mRouteView.a(pointF, retailMap, store.getPoint(), this.mManager.a(store.getRetailMapId()));
    }

    public int traceRoute(PointF from, RetailMap fromRetailMap, PointF to, RetailMap toRetailMap) {
        if (this.mRouteView == null) {
            return -1;
        }
        return this.mRouteView.a(from, fromRetailMap, to, toRetailMap);
    }

    public void setUserResources(int pinResId, int arrowResId, int shadowColor) {
        this.mUserPositionView.setUserNavigationPin(pinResId);
        this.mUserPositionView.setUserNavigationArrowPin(arrowResId);
        this.mUserPositionView.setUserShadowColor(shadowColor);
    }

    public void setCloseRouteGravity(int gravity, int xOffset, int yOffset) {
        this.mCloseRouteGravity = gravity;
        this.mCloseRouteXOffset = xOffset;
        this.mCloseRouteYOffset = yOffset;
    }

    public void setStoreColor(int color) {
        this.mMapImageView.setStoresColor(color);
    }

    public void setHighlightColor(int color) {
        this.mMapImageView.setHighlightColor(color);
    }

    public void setTextColor(int color) {
        this.mMapImageView.setTextColor(color);
    }

    public void setRouteColor(int color) {
        this.mRouteView.setRouteColor(color);
    }

    public void setHallColor(int color) {
        this.mMapImageView.setHallColor(color);
    }

    public void setBalloonLayoutResId(int layoutId) {
        this.mBalloonLayoutResId = layoutId;
    }

    public void setDifferentFloorsErrorStringId(int stringResId) {
        this.mDifferentFloorsErrorStringId = stringResId;
    }

    public void setRouteNotAvailableErrorStringId(int stringResId) {
        this.mRouteNotAvailableErrorStringId = stringResId;
    }

    public void setCloseRouteLayout(int layoutResId) {
        this.mCloseRouteLayoutResId = layoutResId;
    }

    public void setStores(List<Store> stores) {
        this.mMapImageView.setStores(stores);
    }

    public void setGraph(av<ba> graph) {
        if (this.mRouteView != null) {
            this.mRouteView.setGraph(graph);
        }
    }

    public void onScroll(float distanceX, float distanceY) {
        this.mIsTrackUserEnabled = false;
    }

    public Options getOptions() {
        return this.mOptions;
    }

    public static class Options {
        private boolean userInteractionEnabled;
        private boolean zoomEnabled;
        private boolean translationEnabled;
        private boolean routeEnabled;
        private boolean userPositionEnabled;

        public boolean isUserInteractionEnabled() {
            return this.userInteractionEnabled;
        }

        public void setUserInteractionEnabled(boolean userInteractionEnabled) {
            this.userInteractionEnabled = userInteractionEnabled;
        }

        public boolean isZoomEnabled() {
            return this.zoomEnabled;
        }

        public void setZoomEnabled(boolean zoomEnabled) {
            this.zoomEnabled = zoomEnabled;
        }

        public boolean isTranslationEnabled() {
            return this.translationEnabled;
        }

        public void setTranslationEnabled(boolean translationEnabled) {
            this.translationEnabled = translationEnabled;
        }

        public boolean isRouteEnabled() {
            return this.routeEnabled;
        }

        public void setRouteEnabled(boolean routeEnabled) {
            this.routeEnabled = routeEnabled;
        }

        public static Options defaultOptions() {
            Options options = new Options();
            options.userInteractionEnabled = true;
            options.zoomEnabled = true;
            options.translationEnabled = true;
            options.routeEnabled = true;
            options.userPositionEnabled = true;
            return options;
        }
    }

    private static enum b {
        a,
        b,
        c,
        d;

    }

    public static interface a {
        public void a(Store var1);
    }
}

