/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location;

import android.content.Context;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.location.InLocoOptions;
import com.inlocomedia.android.location.geofencing.GeofencingEventsListener;
import com.inlocomedia.android.location.geofencing.g;
import com.inlocomedia.android.location.geofencing.m;
import com.inlocomedia.android.location.geofencing.r;
import com.inlocomedia.android.location.models.Location;
import com.inlocomedia.android.location.private.aa;
import com.inlocomedia.android.location.private.bf;
import com.inlocomedia.android.location.private.bt;
import com.inlocomedia.android.location.private.u;
import com.inlocomedia.android.location.private.v;

public class InLocoPrivate {
    private static String TAG = Logger.makeTag(InLocoPrivate.class);

    public static void initGeofencing(@NonNull Context context) {
        v.a(context.getApplicationContext(), u.b.c);
    }

    public static void initConfigurableModels(@NonNull Context context) {
        v.a(context.getApplicationContext(), u.b.b);
    }

    public static void initLocation(@NonNull Context context) {
        v.a(context.getApplicationContext(), u.b.a);
    }

    public static void initCrowdSourcing(@NonNull Context context) {
        v.a(context.getApplicationContext(), u.b.d);
    }

    public static boolean hasMapsAccess(Context context) {
        return aa.c(context);
    }

    public static boolean hasLocationReceiver(Context context) {
        return aa.f(context);
    }

    public static boolean hasBootCompletedPermission(Context context) {
        return aa.i(context);
    }

    public static void requestLocationRefresh(Context context) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            bf.c(context);
        }
    }

    public static Location getLastKnownValidLocation(Context context) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            return bt.a(context).n();
        }
        return null;
    }

    public static class Geofencing {
        public static boolean isAvailable(Context context) {
            if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
                return m.a(context);
            }
            return false;
        }

        public static void requestRefresh(Context context) {
            if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
                g.b(context);
            }
        }

        public static void registerListener(Context context, Class<? extends GeofencingEventsListener> listener, String category) {
            if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
                g.a(context, listener, category);
            }
        }

        public static void unregisterListener(Context context, String category) {
            if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
                g.a(context, category);
            }
        }

        public static boolean containsEnterTransition(int geofencingTransition) {
            return r.a(geofencingTransition, 1);
        }

        public static boolean containsDwellTransition(int geofencingTransition) {
            return r.a(geofencingTransition, 4);
        }

        public static boolean containsPollingTransition(int geofencingTransition) {
            return r.a(geofencingTransition, 8);
        }
    }
}

