/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileLogger {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String NEW_LINE_REPLACEMENT = " ";
    private static final String SEPARATOR = "\t";
    private static final int MAX_BYTES = 512000;
    private static final String LOGS_FOLDER_NAME = "logs";
    private static final String LOG_FILE_PREFIX = "log";
    public static final String TSV_EXTENSION = ".tsv";
    public static final String ARCHIVED_LOGS_FILE_NAME = "logs.zip";
    public static final int ZIP_BUFFER_SIZE = 2048;
    private Date date = new Date();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss.SSS", Locale.US);
    private String folderPath;
    private HandlerThread handlerThread;
    private Handler handler;
    private static AtomicReference<FileLogger> instanceReference = new AtomicReference();

    private FileLogger(Context context) {
        this.folderPath = context.getFilesDir().getAbsolutePath() + File.separatorChar + LOGS_FOLDER_NAME;
        this.handlerThread = new HandlerThread("FileLogger");
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
    }

    public static FileLogger getInstance(Context context) {
        FileLogger fileLogger = instanceReference.get();
        if (fileLogger == null) {
            instanceReference.compareAndSet(null, new FileLogger(context));
            fileLogger = instanceReference.get();
        }
        return fileLogger;
    }

    public void log(@NonNull String message) {
    }

    public void archiveLogs(final LogArchiveListener listener) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        List list = FileLogger.this.getLogFiles();
                        FileOutputStream fileOutputStream = new FileOutputStream(FileLogger.this.folderPath + "/" + FileLogger.ARCHIVED_LOGS_FILE_NAME);
                        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
                        byte[] byArray = new byte[2048];
                        for (String string : list) {
                            int n2;
                            FileInputStream fileInputStream = new FileInputStream(string);
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
                            ZipEntry zipEntry = new ZipEntry(string.substring(string.lastIndexOf("/") + 1));
                            zipOutputStream.putNextEntry(zipEntry);
                            while ((n2 = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                                zipOutputStream.write(byArray, 0, n2);
                            }
                            bufferedInputStream.close();
                        }
                        zipOutputStream.finish();
                        zipOutputStream.close();
                        if (listener != null) {
                            File file = new File(FileLogger.this.folderPath + "/" + FileLogger.ARCHIVED_LOGS_FILE_NAME);
                            listener.onSuccess(file);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        if (listener == null) break block5;
                        listener.onError();
                    }
                }
            }
        });
    }

    public void readLogs(final LogReadListener listener) {
        this.handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStreamReader inputStreamReader = null;
                try {
                    String string;
                    inputStreamReader = new InputStreamReader(new FileInputStream(FileLogger.this.getCurrentLogFile()));
                    ArrayList<Log> arrayList = new ArrayList<Log>();
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string = bufferedReader.readLine()) != null) {
                        arrayList.add(FileLogger.this.parseLogLine(string));
                    }
                    Collections.reverse(arrayList);
                    listener.onSuccess(arrayList);
                }
                catch (Throwable throwable) {
                    if (listener != null) {
                        listener.onError();
                    }
                }
                finally {
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }

    public void deleteLogFiles() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                File file = new File(FileLogger.this.folderPath);
                String[] stringArray = file.list();
                for (int i2 = 0; i2 < (stringArray != null ? stringArray.length : 0); ++i2) {
                    new File(file, stringArray[i2]).delete();
                }
            }
        });
    }

    private List<String> getLogFiles() {
        File file = new File(this.folderPath);
        File[] fileArray = file.listFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2 == null || !file2.isFile() || !file2.getAbsolutePath().endsWith(TSV_EXTENSION)) continue;
                arrayList.add(file2.getAbsolutePath());
            }
        }
        return arrayList;
    }

    private Log parseLogLine(String logLine) {
        String[] stringArray = logLine.split(SEPARATOR);
        return new Log(Long.parseLong(stringArray[0]), stringArray[2]);
    }

    private void writeLog(String log) {
        block4: {
            FileWriter fileWriter = null;
            File file = this.getCurrentLogFile();
            try {
                fileWriter = new FileWriter(file, true);
                fileWriter.append(log);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                if (fileWriter == null) break block4;
                try {
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
    }

    private File getCurrentLogFile() {
        File file = new File(this.folderPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        int n2 = 0;
        File file2 = null;
        File file3 = new File(file, String.format("%s_%s.tsv", LOG_FILE_PREFIX, n2));
        while (file3.exists()) {
            file2 = file3;
            file3 = new File(file, String.format("%s_%s.tsv", LOG_FILE_PREFIX, ++n2));
        }
        if (file2 != null) {
            if (file2.length() >= 512000L) {
                return file3;
            }
            return file2;
        }
        return file3;
    }

    @VisibleForTesting
    public static void reset(Context context) {
        FileLogger fileLogger = FileLogger.getInstance(context);
        fileLogger.handlerThread.quitSafely();
        instanceReference.set(null);
    }

    public static interface LogReadListener {
        public void onSuccess(List<Log> var1);

        public void onError();
    }

    public static interface LogArchiveListener {
        public void onSuccess(File var1);

        public void onError();
    }

    public static class Log {
        public final long date;
        public final String message;

        Log(long date, String message) {
            this.date = date;
            this.message = message;
        }
    }
}

