/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.profile;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.telephony.TelephonyManager;
import android.util.Base64;
import com.inlocomedia.android.core.a;
import com.inlocomedia.android.core.private.dp;
import com.inlocomedia.android.core.private.dq;
import com.inlocomedia.android.core.private.dr;
import com.inlocomedia.android.core.private.dz;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.core.util.at;
import com.inlocomedia.android.core.util.n;
import com.inlocomedia.android.core.util.r;
import com.inlocomedia.android.core.util.v;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.json.JSONArray;

public final class Device {
    public static final String OS_NAME = "android";
    public static final String MODEL = Build.MODEL;
    public static final String MANUFACTURER = Build.MANUFACTURER;
    public static final String INDUSTRIAL_DESIGN_NAME = Build.DEVICE;
    public static final int ANDROID_VERSION_CODE = Build.VERSION.SDK_INT;
    private static final String TAG = com.inlocomedia.android.core.log.a.a(Device.class);
    private static final String DEVICE_ID_PREFIX = "ILM-ID-";

    private Device() {
    }

    @Nullable
    public static List<String> getSimCarrierName(TelephonyManager tManager) {
        try {
            return Device.splitSimOrNetData(tManager.getSimOperatorName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<String> getNetworkCarrierName(TelephonyManager tManager) {
        try {
            return Device.splitSimOrNetData(tManager.getNetworkOperatorName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static List<String> getSimCountryIso(TelephonyManager tManager) {
        try {
            return Device.splitSimOrNetData(tManager.getSimCountryIso());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static List<String> getNetworkCountryIso(TelephonyManager tManager) {
        try {
            return Device.splitSimOrNetData(tManager.getNetworkCountryIso());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @VisibleForTesting
    static List<String> splitSimOrNetData(String data) {
        if (Validator.isNullOrEmpty(data)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : data.split(",")) {
            if (string.isEmpty() || string.equals("null")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static boolean isAdTrackingEnabled(@NonNull Context context) {
        return !n.e(context);
    }

    @Nullable
    public static String getGoogleAdvertisingId(@NonNull Context context) {
        return n.d(context);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static String getInstallationId(Context context) {
        com.inlocomedia.android.core.private.at at2 = com.inlocomedia.android.core.private.at.a(context);
        String string = at2.c("7OLmdmz8vjKtQQKjEuy0").f("zbAsYg5vOUMV3SWbst7A");
        if (string == null) {
            string = Device.generateDeviceId();
            at2.c("7OLmdmz8vjKtQQKjEuy0").b("zbAsYg5vOUMV3SWbst7A", string).d();
        }
        return string;
    }

    public static SortedSet<Integer> getDeviceSdkHistory(Context context) {
        com.inlocomedia.android.core.private.at at2 = com.inlocomedia.android.core.private.at.a(context);
        String string = at2.c("7OLmdmz8vjKtQQKjEuy0").f("sdk_history");
        try {
            JSONArray jSONArray = new JSONArray(string);
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                treeSet.add(jSONArray.getInt(i2));
            }
            return treeSet;
        }
        catch (Throwable throwable) {
            at2.c("7OLmdmz8vjKtQQKjEuy0").i("sdk_history").d();
            return new TreeSet<Integer>();
        }
    }

    public static void recoverSdkHistory() {
        SortedSet<Integer> sortedSet = Device.getDeviceSdkHistory(a.a());
        if (sortedSet.isEmpty() && Device.hasDeviceId(a.a())) {
            Device.addSdkVersionToHistory(a.a(), 0);
        }
        Device.addSdkVersionToHistory(a.a(), 50502);
    }

    public static String getEncryptedInstallationId(Context context) throws GeneralSecurityException {
        dq dq2 = dr.i();
        dq dq3 = new dq(Device.getInstallationIV(context));
        byte[] byArray = dp.a(Device.getInstallationId(context).getBytes(), dq2, dq3);
        byte[] byArray2 = Base64.encode((byte[])byArray, (int)3);
        return new String(byArray2).trim();
    }

    @VisibleForTesting
    static byte[] getInstallationIV(Context context) {
        dz dz2 = new dz();
        dz2.a(Device.getInstallationId(context).getBytes());
        return Arrays.copyOfRange(dz2.d(), 0, 16);
    }

    @VisibleForTesting
    static String generateDeviceId() {
        return DEVICE_ID_PREFIX + UUID.randomUUID().toString();
    }

    @Nullable
    public static String getDevelopmentDeviceId(Context context) {
        String string = v.a(Device.getAndroidId(context));
        if (string != null) {
            return string.toUpperCase(Locale.US);
        }
        return null;
    }

    @SuppressLint(value={"HardwareIds"})
    @Nullable
    private static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    @Nullable
    public static HashSet<String> getInstalledPackageNames(Context context, boolean filterSystemApps, boolean useFallbackMethodOnFailure) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            if (Validator.isAboveOrEqualsToAndroid30()) {
                return null;
            }
            List<ApplicationInfo> list = Device.getInstalledAppsUsingPackageManager(context, 0);
            if (useFallbackMethodOnFailure && !Device.isInstalledAppsListValid(context, list)) {
                list = Device.getInstalledAppsUsingRuntime(context, 0);
            }
            for (ApplicationInfo applicationInfo : list) {
                if ((applicationInfo.flags & 1) != 0 && filterSystemApps) continue;
                hashSet.add(applicationInfo.packageName);
            }
        }
        catch (Throwable throwable) {
            hashSet = null;
        }
        return hashSet;
    }

    public static List<PackageInfo> getInstalledPackages(Context context, boolean filterSystemApps) {
        try {
            if (Validator.isAboveOrEqualsToAndroid30()) {
                return null;
            }
            List<PackageInfo> list = Device.getInstalledPackagesUsingPackageManager(context, 0);
            if (filterSystemApps) {
                ArrayList<PackageInfo> arrayList = new ArrayList<PackageInfo>();
                for (PackageInfo packageInfo : list) {
                    ApplicationInfo applicationInfo = packageInfo.applicationInfo;
                    if (applicationInfo == null || (applicationInfo.flags & 1) != 0) continue;
                    arrayList.add(packageInfo);
                }
                return arrayList;
            }
            return list;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean canHandleIntentForUri(Context context, String uri) {
        return uri != null && Device.canHandleIntent(context, r.a(context, uri));
    }

    public static boolean canHandleIntent(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public static boolean canHandleIntentForUriOnlyOnBrowserApp(Context context, String uri) {
        String string = "http://" + at.a(20) + "." + at.a(3);
        List<String> list = Device.getActivityNamesForUri(context, string);
        List<String> list2 = Device.getActivityNamesForUri(context, uri);
        list2.removeAll(list);
        return list2.size() == 0;
    }

    private static void addSdkVersionToHistory(Context context, int sdkCodeVersion) {
        com.inlocomedia.android.core.private.at at2 = com.inlocomedia.android.core.private.at.a(context);
        SortedSet<Integer> sortedSet = Device.getDeviceSdkHistory(context);
        sortedSet.add(sdkCodeVersion);
        JSONArray jSONArray = new JSONArray(sortedSet);
        at2.c("7OLmdmz8vjKtQQKjEuy0").b("sdk_history", jSONArray.toString()).d();
    }

    private static boolean hasDeviceId(Context context) {
        com.inlocomedia.android.core.private.at at2 = com.inlocomedia.android.core.private.at.a(context);
        String string = at2.c("7OLmdmz8vjKtQQKjEuy0").f("zbAsYg5vOUMV3SWbst7A");
        return string != null;
    }

    private static List<String> getActivityNamesForUri(Context context, String uri) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(r.a(context, uri), 65536);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ResolveInfo resolveInfo : list) {
            arrayList.add(resolveInfo.activityInfo.packageName);
        }
        return arrayList;
    }

    @VisibleForTesting
    public static List<ApplicationInfo> getInstalledAppsUsingPackageManager(Context context, int flags) {
        return context.getPackageManager().getInstalledApplications(flags);
    }

    @VisibleForTesting
    public static List<PackageInfo> getInstalledPackagesUsingPackageManager(Context context, int flags) {
        return context.getPackageManager().getInstalledPackages(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static List<ApplicationInfo> getInstalledAppsUsingRuntime(Context context, int flags) {
        Validator.notMainThread(TAG);
        PackageManager packageManager = context.getPackageManager();
        ArrayList<ApplicationInfo> arrayList = new ArrayList<ApplicationInfo>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            Process process = Runtime.getRuntime().exec("pm list packages");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                String string2 = string.substring(string.indexOf(58) + 1);
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string2, flags);
                arrayList.add(applicationInfo);
            }
        }
        catch (Exception exception) {
            arrayList = null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList;
    }

    private static boolean isInstalledAppsListValid(Context context, List<ApplicationInfo> appInfoList) {
        if (appInfoList == null) {
            return false;
        }
        String string = context.getPackageName();
        for (ApplicationInfo applicationInfo : appInfoList) {
            if (!string.equals(applicationInfo.packageName)) continue;
            return true;
        }
        return false;
    }
}

