/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.inlocomedia.android.core.log.a;
import com.inlocomedia.android.core.private.ay;
import com.inlocomedia.android.core.private.az;
import com.inlocomedia.android.core.private.ba;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class FileLogger
implements az {
    private static final int DB_VERSION = 1;
    private static final String TAG = a.a(FileLogger.class);
    @SuppressLint(value={"SimpleDateFormat"})
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss.SSS");
    private static final String TABLE_NAME = "entries";
    private static final String dbName = "inlocomedia_eoitnhdentuiolceaoafdsfasueid";
    private static final String LOG_FILE_NAME = "sdk_logs";
    private static final String COL_ID = "_id";
    private static final String COL_DATE = "date";
    private static final String COL_MESSAGE = "message";
    private static final String DB_CREATE_QUERY = "CREATE TABLE entries(_id INTEGER PRIMARY KEY AUTOINCREMENT, date INTEGER, message TEXT);";
    private ay mLazyCloseSQLiteOpenHelper;
    private static FileLogger sInstance;

    private FileLogger(Context context, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.mLazyCloseSQLiteOpenHelper = new ay(context, dbName, null, 1, exceptionHandler);
        this.mLazyCloseSQLiteOpenHelper.a(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FileLogger getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<FileLogger> clazz = FileLogger.class;
        synchronized (FileLogger.class) {
            if (sInstance != null) return sInstance;
            sInstance = new FileLogger(context, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex2) {
                    throw new RuntimeException(ex2);
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public synchronized void onCreate(ba db2) {
        try {
            db2.d(DB_CREATE_QUERY);
        }
        catch (Throwable throwable) {
            this.mLazyCloseSQLiteOpenHelper.a(throwable);
        }
    }

    @Override
    public synchronized void onUpgrade(ba db2, int oldVersion, int newVersion) {
        try {
            db2.d("DROP TABLE IF EXISTS entries");
            this.onCreate(db2);
        }
        catch (Throwable throwable) {
            this.mLazyCloseSQLiteOpenHelper.a(throwable);
        }
    }

    @Override
    public synchronized void onDowngrade(ba db2, int oldVersion, int newVersion) {
        try {
            db2.d("DROP TABLE IF EXISTS entries");
            this.onCreate(db2);
        }
        catch (Throwable throwable) {
            this.mLazyCloseSQLiteOpenHelper.a(throwable);
        }
    }

    public static void clearDatabase(Context context) {
        FileLogger fileLogger = FileLogger.getInstance(context);
        try {
            ba ba2 = fileLogger.mLazyCloseSQLiteOpenHelper.b();
            if (ba2 == null) {
                return;
            }
            ba2.a(TABLE_NAME, null, null);
            fileLogger.mLazyCloseSQLiteOpenHelper.c();
        }
        catch (Throwable throwable) {
            fileLogger.mLazyCloseSQLiteOpenHelper.a(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static synchronized List<LogEntry> getEntries(Context context) {
        Cursor cursor = null;
        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>();
        FileLogger fileLogger = FileLogger.getInstance(context);
        try {
            ba ba2 = fileLogger.mLazyCloseSQLiteOpenHelper.b();
            if (ba2 == null) {
                List<LogEntry> list = null;
                return list;
            }
            cursor = ba2.a(TABLE_NAME, null, null, null, null, null, null);
            int n2 = cursor.getColumnIndex(COL_DATE);
            int n3 = cursor.getColumnIndex(COL_MESSAGE);
            while (cursor.moveToNext()) {
                LogEntry logEntry = new LogEntry(cursor.getLong(n2), cursor.getString(n3));
                arrayList.add(0, logEntry);
            }
            Collections.sort(arrayList, new Comparator<LogEntry>(){

                public int a(LogEntry logEntry, LogEntry logEntry2) {
                    long l2 = logEntry2.date;
                    long l3 = logEntry.date;
                    if (l2 > l3) {
                        return 1;
                    }
                    if (l3 > l2) {
                        return -1;
                    }
                    return 0;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((LogEntry)object, (LogEntry)object2);
                }
            });
        }
        catch (Throwable throwable) {
            fileLogger.mLazyCloseSQLiteOpenHelper.a(throwable);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            fileLogger.mLazyCloseSQLiteOpenHelper.c();
        }
        return arrayList;
    }

    public static synchronized void dumpToFile(Context context) {
        FileLogger.dumpToFile(context, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void dumpToFile(Context context, long sizeLimitInBytes) {
        int n2 = 0;
        BufferedWriter bufferedWriter = null;
        try {
            File file = FileLogger.getLogFile(context);
            if (file.exists()) {
                file.delete();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file, true));
            List<LogEntry> list = FileLogger.getEntries(context);
            if (list != null) {
                for (LogEntry logEntry : list) {
                    String string = DATE_FORMAT.format(new Date(logEntry.date)) + ": " + logEntry.message + "\n";
                    int n3 = string.getBytes().length;
                    if ((long)(n2 + n3) > sizeLimitInBytes) break;
                    bufferedWriter.write(string);
                    n2 += n3;
                }
            }
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File getLogDirectory(Context context) {
        File file = context.getExternalFilesDir(null);
        return new File(file.getAbsolutePath() + "/inlocomedia_logs/");
    }

    public static synchronized File getLogFile(Context context) throws IllegalStateException {
        File file = FileLogger.getLogDirectory(context);
        boolean bl2 = file.mkdirs();
        if (!bl2 && !file.exists()) {
            throw new IllegalStateException("Failed to create log file at: " + file);
        }
        return new File(FileLogger.getLogDirectory(context), LOG_FILE_NAME);
    }

    @VisibleForTesting
    public static void reset(Context context) {
        if (sInstance != null) {
            FileLogger fileLogger = FileLogger.getInstance(context);
            ba ba2 = fileLogger.mLazyCloseSQLiteOpenHelper.b();
            if (ba2 != null) {
                ba2.d("DROP TABLE IF EXISTS entries");
            }
            fileLogger.mLazyCloseSQLiteOpenHelper.c();
            fileLogger.mLazyCloseSQLiteOpenHelper.d();
            sInstance = null;
        }
    }

    public static void insert(Context context, String message) {
    }

    public static class LogEntry {
        public final long date;
        public final String message;

        LogEntry(long date, String message) {
            this.date = date;
            this.message = message;
        }
    }
}

