/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.profile;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.private.br;
import com.inlocomedia.android.core.private.ea;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@ApiAccess
public class UserProfile
extends ea {
    private static final long serialVersionUID = -1436729049804573382L;
    private static final SimpleDateFormat sDateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH);
    private static final boolean CRYPTOGRAPHY_ENABLED = true;
    private static final int VERSION = 0;
    private static final String UNIQUE_NAME = "UserProfile";
    private static final String VALUE_GENDER_MALE = "masculine";
    private static final String VALUE_GENDER_FEMALE = "feminine";
    private static final String VALUE_GENDER_UNDEFINED = "undefined";
    public static final int AGE_UNDEFINED = 0;
    private Date birthDate;
    private Gender gender;
    private int maxAge;
    private int minAge;

    public UserProfile() {
        this(Gender.UNDEFINED, null, 0, 0);
    }

    public UserProfile(Gender gender, @Nullable Date birthDate) {
        this(gender, birthDate, 0, 0);
    }

    public UserProfile(Gender gender, int minAge, int maxAge) {
        this(gender, null, minAge, maxAge);
    }

    public UserProfile(Gender gender, @Nullable Date birthDate, int minAge, int maxAge) {
        super(0, true);
        this.setGender(gender);
        this.setBirthDate(birthDate);
        this.setAgeRange(minAge, maxAge);
    }

    @Nullable
    public static UserProfile getSavedProfile(Context context) {
        UserProfile userProfile = new UserProfile();
        boolean bl2 = userProfile.restore(context);
        return bl2 ? userProfile : null;
    }

    public static boolean clearSavedProfile(Context context) {
        UserProfile userProfile = new UserProfile();
        return userProfile.clear(context);
    }

    @Nullable
    public Date getBirthdate() {
        return this.birthDate;
    }

    public String getFormattedBirthDate() {
        return sDateFormat.format(this.birthDate);
    }

    public void setBirthDate(@Nullable Date birthDate) {
        this.birthDate = birthDate != null && birthDate.getTime() > System.currentTimeMillis() ? null : birthDate;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender == null ? Gender.UNDEFINED : gender;
    }

    public void setAgeRange(int minAge, int maxAge) {
        this.minAge = Math.max(0, minAge);
        this.maxAge = Math.max(0, maxAge);
    }

    public int getMinAge() {
        return this.minAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public JSONObject parseToJSON() throws br {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.birthDate != null) {
                jSONObject.put("birthdate", (Object)this.getFormattedBirthDate());
            }
            if (this.gender != null && this.gender != Gender.UNDEFINED) {
                jSONObject.put("gender", (Object)this.gender.value);
            }
            if (this.minAge > 0) {
                jSONObject.put("min_age", this.minAge);
            }
            if (this.maxAge > 0) {
                jSONObject.put("max_age", this.maxAge);
            }
        }
        catch (JSONException jSONException) {
            throw new br("UserProfile mapping has failed", (Exception)((Object)jSONException));
        }
        return jSONObject;
    }

    @Override
    public void parseFromJSON(JSONObject json) throws br {
        try {
            this.minAge = json.optInt("min_age", 0);
            this.maxAge = json.optInt("max_age", 0);
            this.birthDate = json.has("birthdate") ? sDateFormat.parse(json.getString("birthdate")) : null;
            this.gender = json.has("gender") ? Gender.genderFromValue(json.getString("gender")) : Gender.UNDEFINED;
        }
        catch (ParseException | JSONException throwable) {
            throw new br(throwable.getMessage(), (Exception)throwable);
        }
    }

    @Override
    public boolean save(Context context) {
        return super.save(context);
    }

    @Override
    public boolean restore(Context context) {
        return super.restore(context);
    }

    @Override
    public boolean clear(Context context) {
        boolean bl2 = super.clear(context);
        if (bl2) {
            this.birthDate = null;
            this.gender = Gender.UNDEFINED;
            this.minAge = 0;
            this.maxAge = 0;
        }
        return bl2;
    }

    public boolean isSaved(Context context) {
        return this.equals(UserProfile.getSavedProfile(context));
    }

    public boolean isValid() {
        return this.birthDate != null || this.gender != Gender.UNDEFINED || this.minAge > 0 && this.maxAge > 0;
    }

    @NonNull
    public String toString() {
        return String.format(Locale.US, "[Birthdate:%s] [Gender:%s] [Age Range:%s-%s]", new Object[]{this.birthDate != null ? sDateFormat.format(this.birthDate) : null, this.gender, this.minAge, this.maxAge});
    }

    private boolean compareDates(Date firstDate, Date secondDate) {
        String string = sDateFormat.format(firstDate);
        String string2 = sDateFormat.format(secondDate);
        return string.equals(string2);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UserProfile userProfile = (UserProfile)o2;
        if (this.birthDate != null ? !this.compareDates(this.birthDate, userProfile.birthDate) : userProfile.birthDate != null) {
            return false;
        }
        if (this.gender != userProfile.gender) {
            return false;
        }
        if (this.minAge != userProfile.minAge) {
            return false;
        }
        return this.maxAge == userProfile.maxAge;
    }

    public int hashCode() {
        int n2 = this.birthDate != null ? this.birthDate.hashCode() : 0;
        n2 = 31 * n2 + this.minAge;
        n2 = 31 * n2 + this.maxAge;
        n2 = 31 * n2 + (this.gender != null ? this.gender.hashCode() : 0);
        return n2;
    }

    @Override
    public String getUniqueName() {
        return UNIQUE_NAME;
    }

    @Override
    protected void onUpgrade(int savedVersion, String savedJsonModel) {
    }

    @Override
    protected void onDowngrade(int savedVersion, String savedJsonModel) {
    }

    @ApiAccess
    public static enum Gender {
        MALE("masculine"),
        FEMALE("feminine"),
        UNDEFINED("undefined");

        private final String value;

        private Gender(String value) {
            this.value = value;
        }

        public static Gender genderFromValue(String value) {
            switch (value) {
                case "masculine": {
                    return MALE;
                }
                case "feminine": {
                    return FEMALE;
                }
            }
            return UNDEFINED;
        }

        public String getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return this.value;
        }
    }
}

