/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.webkit.URLUtil;
import com.inlocomedia.android.core.c;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.aa;
import com.inlocomedia.android.core.private.by;
import com.inlocomedia.android.core.private.f;
import com.inlocomedia.android.core.private.g;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class Validator {
    public static final int MINIMUM_SUPPORTED_VERSION = 14;
    private static final String[] REQUIRED_PERMISSIONS = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"};

    private Validator() {
    }

    public static void tokenAccess(g token) throws aa, by {
        Validator.sdkVersion();
        if (!Validator.token(token)) {
            throw new aa("You must register your application with an id before using this service");
        }
    }

    public static void authenticationIdAccess(f clientId) throws aa, by {
        Validator.sdkVersion();
        if (!Validator.clientId(clientId)) {
            throw new aa("You must register your application with an id before using this service");
        }
    }

    public static boolean token(g token) {
        return token != null && !Validator.isNullOrEmpty(token.b()) && !Validator.isNullOrEmpty(token.c());
    }

    public static boolean clientId(f authenticationId) {
        return authenticationId != null && !Validator.isNullOrEmpty(authenticationId.a());
    }

    public static void sdkVersion() throws by {
        if (!Validator.isValidSDKVersion()) {
            String string = String.format(Locale.US, "This device SDK version is below the minimum required version. Minimum: %s, Current %s", 14, Build.VERSION.SDK_INT);
            throw new by(string);
        }
    }

    public static boolean isValidSDKVersion() {
        return Build.VERSION.SDK_INT >= 14;
    }

    public static void manifest(Context context) {
        Validator.permissions(context);
    }

    static boolean hasStoragePermissionOnManifest(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            if (packageInfo.requestedPermissions != null) {
                for (String string : packageInfo.requestedPermissions) {
                    if (!string.equals("android.permission.WRITE_EXTERNAL_STORAGE")) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void permissions(Context context) {
        for (String string : REQUIRED_PERMISSIONS) {
            if (Validator.isPermissionEnabled(context, string)) continue;
            c.b.a.g();
            DevLogger.e("Missing required permission: " + string + ". It's required to include the permission in your AndroidManifest file");
        }
    }

    static boolean writeExternalStoragePermission(Context context) {
        int n2 = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        return n2 == 0;
    }

    public static void libraryDependencies() {
        try {
            Class.forName("android.support.v4.util.LruCache");
        }
        catch (ClassNotFoundException classNotFoundException) {
            DevLogger.e("Configuration error: Missing required library 'Android Support v4'");
            c.b.a.g();
        }
    }

    public static boolean isPermissionEnabled(Context context, String permission2) {
        int n2 = context.checkCallingOrSelfPermission(permission2);
        return n2 == 0;
    }

    public static boolean isPermissionGrantable(Context context, String permission2) {
        return !Validator.isBelowAndroid23() || Validator.isPermissionEnabled(context, permission2);
    }

    public static void notNull(Object arg, String name) {
        if (arg == null) {
            throw new NullPointerException("Argument '" + name + "' cannot be null");
        }
    }

    public static void notEmpty(String arg, String name) {
        if (arg.isEmpty()) {
            throw new IllegalArgumentException("Argument '" + name + "' cannot be empty");
        }
    }

    public static void isValidUrl(String url, String name) {
        if (!Validator.isValidUrl(url)) {
            throw new IllegalArgumentException("Url argument '" + name + "' is invalid");
        }
    }

    public static boolean isValidHttpUrl(String url) {
        return URLUtil.isHttpUrl((String)url) || URLUtil.isHttpsUrl((String)url);
    }

    public static boolean isValidUrl(String url) {
        return URLUtil.isValidUrl((String)url);
    }

    public static void notNullNorEmpty(String arg, String name) {
        if (Validator.isNullOrEmpty(arg)) {
            throw new IllegalArgumentException("Argument '" + name + "' cannot be null or empty");
        }
    }

    public static void notNullNorEmpty(Collection<?> c2, String name) {
        if (Validator.isNullOrEmpty(c2)) {
            throw new IllegalArgumentException("Argument '" + name + "' cannot be null or empty");
        }
    }

    public static void isNotNegative(long arg, String name) {
        if (arg < 0L) {
            throw new IllegalArgumentException("Argument '" + name + "' cannot be negative");
        }
    }

    public static void isPositive(long arg, String name) {
        if (arg <= 0L) {
            throw new IllegalArgumentException("Argument '" + name + "' should be positive");
        }
    }

    public static void notNullAndPositive(Integer arg, String name) {
        if (arg == null || arg <= 0) {
            throw new IllegalArgumentException("Argument '" + name + "' should be non null and positive");
        }
    }

    public static void notNullAndPositive(Double arg, String name) {
        if (arg == null || arg <= 0.0) {
            throw new IllegalArgumentException("Argument '" + name + "' should be non null and positive");
        }
    }

    public static void nullOrNotNegative(Integer arg, String name) {
        if (arg != null && arg < 0) {
            throw new IllegalArgumentException("Argument '" + name + "' should be null or non negative");
        }
    }

    public static boolean isNullOrEmpty(Collection<?> c2) {
        return c2 == null || c2.size() == 0;
    }

    public static boolean isNullOrEmpty(Map<?, ?> c2) {
        return c2 == null || c2.size() == 0;
    }

    public static boolean areNotNullNorEmpty(String ... strings) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        for (String string : strings) {
            if (!Validator.isNullOrEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.length() == 0;
    }

    public static boolean isMainThread() throws RuntimeException {
        return Looper.getMainLooper().equals(Looper.myLooper());
    }

    public static void mainThread(String tag) throws RuntimeException {
        if (!Validator.isMainThread()) {
            throw new RuntimeException("[" + tag + "] You need to be on the UI Thread to perform this operation");
        }
    }

    public static void notMainThread(String tag) throws RuntimeException {
        if (Validator.isMainThread()) {
            throw new RuntimeException("[" + tag + "] You can't execute this operation on the UI Thread");
        }
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static boolean isAboveOrEqualsToAndroid18() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public static boolean isBelowAndroid23() {
        return Build.VERSION.SDK_INT < 23;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static boolean isBelowOrEqualsAndroid21() {
        return Build.VERSION.SDK_INT < 21;
    }

    public static boolean isAboveOrEqualsToAndroid22() {
        return Build.VERSION.SDK_INT >= 22;
    }

    public static boolean isAboveOrEqualsToAndroid21() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static boolean isAboveOrEqualsToAndroid19() {
        return Build.VERSION.SDK_INT >= 19;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static boolean isAboveOrEqualsAndroid16() {
        return Build.VERSION.SDK_INT >= 16;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static boolean isAboveOrEqualsAndroid17() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static boolean isAboveOrEqualsAndroid23() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static boolean isBelowAndroid24() {
        return Build.VERSION.SDK_INT < 24;
    }

    public static void isActivityRegistered(Context context, Class<?> activityKlass) {
        if (new Intent(context, activityKlass).resolveActivityInfo(context.getPackageManager(), 0) == null) {
            throw new RuntimeException("The activity " + activityKlass.getName() + " was not declared on the android manifest");
        }
    }

    public static boolean isAboveOrEqualsAndroid26() {
        return Build.VERSION.SDK_INT >= 26;
    }

    public static boolean isReceiverRegistered(Context context, Class<?> receiverKlass, String action) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent(context, receiverKlass);
        if (action != null) {
            intent.setAction(action);
        }
        List list = packageManager.queryBroadcastReceivers(intent, 32);
        for (ResolveInfo resolveInfo : list) {
            String string = resolveInfo.activityInfo.name;
            try {
                Class<?> clazz = Class.forName(string);
                if (!clazz.equals(receiverKlass)) continue;
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return false;
    }

    public static boolean areEqualAndNonNull(String str1, String str2) {
        return str1 != null && str1.equals(str2);
    }
}

