/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.profile;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.telephony.TelephonyManager;
import com.inlocomedia.android.core.log.c;
import com.inlocomedia.android.core.private.bb;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.core.util.as;
import com.inlocomedia.android.core.util.l;
import com.inlocomedia.android.core.util.p;
import com.inlocomedia.android.core.util.t;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public final class Device {
    public static final String OS_NAME = "android";
    public static final String MODEL = Build.MODEL;
    public static final String MANUFACTURER = Build.MANUFACTURER;
    public static final String INDUSTRIAL_DESIGN_NAME = Build.DEVICE;
    public static final int ANDROID_VERSION_CODE = Build.VERSION.SDK_INT;
    private static final String TAG = c.a(Device.class);
    private static final String DEVICE_ID_PREFIX = "ILM-ID-";

    private Device() {
    }

    @VisibleForTesting(otherwise=3)
    public static List<String> getSimCarrierName(TelephonyManager tManager) {
        try {
            return Device.splitSimOrNetData(tManager.getSimOperatorName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<String> getNetworkCarrierName(TelephonyManager tManager) {
        try {
            return Device.splitSimOrNetData(tManager.getNetworkOperatorName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @VisibleForTesting(otherwise=3)
    public static List<String> getSimCountryIso(TelephonyManager tManager) {
        try {
            return Device.splitSimOrNetData(tManager.getSimCountryIso());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @VisibleForTesting(otherwise=3)
    public static List<String> getNetworkCountryIso(TelephonyManager tManager) {
        try {
            return Device.splitSimOrNetData(tManager.getNetworkCountryIso());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @VisibleForTesting
    static List<String> splitSimOrNetData(String data) {
        if (Validator.isNullOrEmpty(data)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : data.split(",")) {
            if (string.isEmpty() || string.equals("null")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String getAdOrDeviceId(Context context) {
        String string = Device.getGoogleAdvertisingId(context);
        if (string == null) {
            string = Device.getDeviceId(context);
        }
        return string;
    }

    public static boolean isAdTrackingEnabled(@NonNull Context context) {
        return !l.e(context);
    }

    @Nullable
    public static String getGoogleAdvertisingId(@NonNull Context context) {
        return l.d(context);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static String getDeviceId(Context context) {
        bb bb2 = bb.a(context);
        String string = bb2.a("7OLmdmz8vjKtQQKjEuy0").f("zbAsYg5vOUMV3SWbst7A");
        if (string == null) {
            string = Device.generateDeviceId();
            bb2.a("7OLmdmz8vjKtQQKjEuy0").b("zbAsYg5vOUMV3SWbst7A", string).d();
        }
        return string;
    }

    @VisibleForTesting
    static String generateDeviceId() {
        return DEVICE_ID_PREFIX + UUID.randomUUID().toString();
    }

    @Nullable
    public static String getDevelopmentDeviceId(Context context) {
        String string = t.a(Device.getAndroidId(context));
        if (string != null) {
            return string.toUpperCase(Locale.US);
        }
        return null;
    }

    @SuppressLint(value={"HardwareIds"})
    @Nullable
    private static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    @Nullable
    public static HashSet<String> getInstalledPackageNames(Context context, boolean filterSystemApps, boolean useFallbackMethodOnFailure) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            List<ApplicationInfo> list = Device.getInstalledAppsUsingPackageManager(context, 0);
            if (useFallbackMethodOnFailure && !Device.isInstalledAppsListValid(context, list)) {
                list = Device.getInstalledAppsUsingRuntime(context, 0);
            }
            for (ApplicationInfo applicationInfo : list) {
                if ((applicationInfo.flags & 1) != 0 && filterSystemApps) continue;
                hashSet.add(applicationInfo.packageName);
            }
        }
        catch (Throwable throwable) {
            hashSet = null;
        }
        return hashSet;
    }

    public static boolean canHandleIntentForUri(Context context, String uri) {
        return uri != null && Device.canHandleIntent(context, p.a(context, uri));
    }

    public static boolean canHandleIntent(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public static boolean canHandleIntentForUriOnlyOnBrowserApp(Context context, String uri) {
        String string = "http://" + as.a(20) + "." + as.a(3);
        List<String> list = Device.getActivityNamesForUri(context, string);
        List<String> list2 = Device.getActivityNamesForUri(context, uri);
        list2.removeAll(list);
        return list2.size() == 0;
    }

    private static List<String> getActivityNamesForUri(Context context, String uri) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(p.a(context, uri), 65536);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ResolveInfo resolveInfo : list) {
            arrayList.add(resolveInfo.activityInfo.packageName);
        }
        return arrayList;
    }

    @VisibleForTesting
    public static List<ApplicationInfo> getInstalledAppsUsingPackageManager(Context context, int flags) {
        return context.getPackageManager().getInstalledApplications(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static List<ApplicationInfo> getInstalledAppsUsingRuntime(Context context, int flags) {
        Validator.notMainThread(TAG);
        PackageManager packageManager = context.getPackageManager();
        ArrayList<ApplicationInfo> arrayList = new ArrayList<ApplicationInfo>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            Process process = Runtime.getRuntime().exec("pm list packages");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                String string2 = string.substring(string.indexOf(58) + 1);
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string2, flags);
                arrayList.add(applicationInfo);
            }
        }
        catch (Exception exception) {
            arrayList = null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList;
    }

    private static boolean isInstalledAppsListValid(Context context, List<ApplicationInfo> appInfoList) {
        if (appInfoList == null) {
            return false;
        }
        String string = context.getPackageName();
        for (ApplicationInfo applicationInfo : appInfoList) {
            if (!string.equals(applicationInfo.packageName)) continue;
            return true;
        }
        return false;
    }
}

