/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.profile;

import android.content.Context;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import com.inlocomedia.android.core.communication.util.NetworkAccessTools;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.profile.UserRequestParams;
import com.inlocomedia.android.core.util.ScreenHelper;
import com.inlocomedia.android.core.util.TimeUtils;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.core.util.time.TimeProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.TimeZone;

public class UserRequestParamsFactory<T extends UserRequestParams> {
    private static final String a = Logger.makeTag(UserRequestParamsFactory.class);
    private Class<T> b;
    private TimeProvider c;
    private ScreenHelper d;

    public UserRequestParamsFactory(Class<T> klass, TimeProvider timeProvider, ScreenHelper screenHelper) {
        this.b = klass;
        this.c = timeProvider;
        this.d = screenHelper;
    }

    public T getUserRequestParams(Context context) {
        try {
            Constructor<T> constructor = this.b.getConstructor(new Class[0]);
            UserRequestParams userRequestParams = (UserRequestParams)constructor.newInstance(new Object[0]);
            this.a(userRequestParams, context);
            return (T)userRequestParams;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private void a(T t, Context context) {
        this.a(t);
        this.b(t);
        this.c(t);
        this.b(t, context);
        this.d(t);
        this.e(t);
        this.f(t);
        this.c(t, context);
        this.d(t, context);
        this.e(t, context);
    }

    private void a(T t) {
        ((UserRequestParams)t).mTimezone = TimeZone.getDefault().getID();
    }

    private void b(T t) {
        ((UserRequestParams)t).mTimestamp = this.c.currentTimeMillis();
    }

    private void c(T t) {
        ((UserRequestParams)t).mHour = TimeUtils.getCurrentHour();
    }

    private void b(T t, Context context) {
        ((UserRequestParams)t).mPackageName = context.getPackageName();
    }

    private void d(T t) {
        ((UserRequestParams)t).mSdkVersionName = "3.3.9";
        ((UserRequestParams)t).mSdkCodeVersion = 30309;
    }

    private void e(T t) {
        ((UserRequestParams)t).mOsName = "android";
        ((UserRequestParams)t).mOsVersionCode = Device.ANDROID_VERSION_CODE;
    }

    private void f(T t) {
        ((UserRequestParams)t).mDeviceModel = Device.MODEL;
        ((UserRequestParams)t).mDeviceManufacturer = Device.MANUFACTURER;
        ((UserRequestParams)t).mDeviceDesignName = Device.INDUSTRIAL_DESIGN_NAME;
        ((UserRequestParams)t).mScreenDensityRatio = Float.valueOf(this.d.getDensity());
    }

    private void c(T t, Context context) {
        ((UserRequestParams)t).mGoogleAId = Device.getGoogleAdvertisingId(context);
        ((UserRequestParams)t).mAdIdentifier = Device.getAdOrDeviceId(context);
        ((UserRequestParams)t).mAdTrackingEnabled = Device.isAdTrackingEnabled(context);
        ((UserRequestParams)t).mInLocoMediaId = Device.getDeviceId(context);
    }

    private void d(T t, Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ((UserRequestParams)t).mSimCountryISO = Device.b(telephonyManager);
        ((UserRequestParams)t).mNetworkCountryISO = Device.c(telephonyManager);
        ((UserRequestParams)t).mSimOperator = Device.a(telephonyManager);
        ((UserRequestParams)t).mNetworkOperator = Device.getNetworkCarrierName(telephonyManager);
    }

    private void e(T t, Context context) {
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        if (networkInfo != null && networkInfo.isConnectedOrConnecting()) {
            ((UserRequestParams)t).mConnectionType = String.valueOf(networkInfo.getType());
            if (networkInfo.getType() == 0) {
                ((UserRequestParams)t).mMobileConnectionType = String.valueOf(networkInfo.getSubtype());
            }
        }
    }

    public T newParams(Context context) {
        Validator.notMainThread("Get UserRequestParams");
        return this.getUserRequestParams(context);
    }
}

