/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.data.local.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.VisibleForTesting;
import android.util.SparseArray;
import com.inlocomedia.android.core.communication.util.BinaryUtils;
import com.inlocomedia.android.core.data.local.Storage;
import com.inlocomedia.android.core.data.local.StorageEntry;
import com.inlocomedia.android.core.data.local.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseListener;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseWrapper;
import com.inlocomedia.android.core.data.local.database.StorageOperation;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.time.TimeProvider;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DatabaseStorage
implements Storage,
SQLiteDatabaseListener {
    private static final String b = Logger.makeTag(DatabaseStorage.class);
    private int c;
    private long d;
    private LazyCloseSQLiteOpenHelper e;
    private Listener f;
    private TimeProvider g;
    @VisibleForTesting
    long a;

    public DatabaseStorage(LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper, int databaseMaxRows, long maxDatabaseSize, TimeProvider timeProvider) {
        this(lazyCloseSQLiteOpenHelper, databaseMaxRows, maxDatabaseSize, timeProvider, null);
    }

    public DatabaseStorage(LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper, int databaseMaxRows, long maxDatabaseSize, TimeProvider timeProvider, Listener listener) {
        this.e = lazyCloseSQLiteOpenHelper;
        this.e.setDatabaseListener(this);
        this.c = databaseMaxRows;
        this.d = maxDatabaseSize;
        this.f = listener;
        this.a = Long.MAX_VALUE;
        this.g = timeProvider;
    }

    @Override
    public synchronized int insert(int id, Map<String, Serializable> values) {
        String string;
        StorageEntry storageEntry = new StorageEntry();
        long l = System.currentTimeMillis();
        storageEntry.add(l, values);
        boolean bl = this.a(id, storageEntry);
        String string2 = string = bl ? "Values saved successfully: " : "Failure saving values: ";
        if (!bl) {
            return 3;
        }
        if (this.c() >= (long)this.c || this.a() >= this.d) {
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void trim() {
        StorageOperation.Builder builder = new StorageOperation.Builder().setOperation(2);
        if (this.f != null) {
            this.a(builder);
        }
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            long l = sQLiteDatabaseWrapper.queryNumEntries("events");
            long l2 = sQLiteDatabaseWrapper.getDatabaseSize();
            if (l > (long)this.c || l2 > this.d) {
                long l3 = Math.max(l - (long)(this.c / 2), l / 2L);
                sQLiteDatabaseWrapper.execSQL(this.a(l3));
            }
            this.e.closeDatabase();
        }
        catch (Throwable throwable) {
            if (this.f != null) {
                builder.setOperation(5);
            }
            this.e.onUnexpectedError(throwable);
        }
        finally {
            if (this.f != null) {
                this.b(builder);
                this.f.onOperationPerformed(builder.build());
            }
        }
    }

    @Override
    public synchronized void clean() {
        try {
            this.b();
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SparseArray<StorageEntry> dump() {
        try (Cursor cursor = null;){
            SparseArray sparseArray = new SparseArray();
            cursor = this.d();
            if (cursor != null) {
                int n = cursor.getColumnIndex("event_id");
                int n2 = cursor.getColumnIndex("timestamp");
                int n3 = cursor.getColumnIndex("event_values");
                while (cursor.moveToNext()) {
                    int n4 = cursor.getInt(n);
                    long l = cursor.getLong(n2);
                    byte[] byArray = cursor.getBlob(n3);
                    StorageEntry storageEntry = (StorageEntry)sparseArray.get(n4);
                    if (storageEntry == null) {
                        storageEntry = new StorageEntry();
                        sparseArray.put(n4, (Object)storageEntry);
                    }
                    storageEntry.add(l, (Map)BinaryUtils.fromByteArray(byArray));
                }
            }
            this.a = this.g.currentTimeMillis();
            SparseArray sparseArray2 = sparseArray;
            return sparseArray2;
        }
    }

    @Override
    public synchronized void onCreate(SQLiteDatabaseWrapper databaseWrapper) {
        try {
            databaseWrapper.execSQL("CREATE TABLE events(_id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp INTEGER, event_id INTEGER NOT NULL, event_values BLOB); ");
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
        }
    }

    @Override
    public synchronized void onUpgrade(SQLiteDatabaseWrapper databaseWrapper, int oldVersion, int newVersion) {
        this.a(databaseWrapper);
    }

    @Override
    public synchronized void onDowngrade(SQLiteDatabaseWrapper databaseWrapper, int oldVersion, int newVersion) {
        this.a(databaseWrapper);
    }

    private void a(SQLiteDatabaseWrapper sQLiteDatabaseWrapper) {
        try {
            sQLiteDatabaseWrapper.execSQL("DROP TABLE IF EXISTS events");
            this.onCreate(sQLiteDatabaseWrapper);
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
        }
    }

    private void b() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
        if (sQLiteDatabaseWrapper != null) {
            sQLiteDatabaseWrapper.execSQL(this.b(this.a));
        }
        this.e.closeDatabase();
    }

    private boolean a(int n, StorageEntry storageEntry) {
        boolean bl = true;
        List<Map<String, Serializable>> list = storageEntry.getValuesList();
        for (Map<String, Serializable> map : list) {
            bl &= this.a(n, map, storageEntry.getTimestampFromValues(map));
        }
        return bl;
    }

    private boolean a(int n, Map<String, Serializable> map, long l) {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return false;
            }
            ContentValues contentValues = this.b(n, map, l);
            long l2 = sQLiteDatabaseWrapper.insert("events", contentValues);
            this.e.closeDatabase();
            return l2 > 0L;
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
            return false;
        }
    }

    private long c() {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return -1L;
            }
            long l = sQLiteDatabaseWrapper.queryNumEntries("events");
            this.e.closeDatabase();
            return l;
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
            return -1L;
        }
    }

    long a() {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return -1L;
            }
            long l = sQLiteDatabaseWrapper.getDatabaseSize();
            this.e.closeDatabase();
            return l;
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
            return -1L;
        }
    }

    private ContentValues b(int n, Map<String, Serializable> map, long l) throws IOException {
        ContentValues contentValues = new ContentValues();
        contentValues.put("event_id", Integer.valueOf(n));
        contentValues.put("timestamp", Long.valueOf(l));
        byte[] byArray = BinaryUtils.toByteArray(map);
        contentValues.put("event_values", byArray);
        return contentValues;
    }

    private Cursor d() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
        if (sQLiteDatabaseWrapper == null) {
            return null;
        }
        Cursor cursor = sQLiteDatabaseWrapper.queryAll("events");
        this.e.closeDatabase();
        return cursor;
    }

    private void a(StorageOperation.Builder builder) {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            builder.setStorageName(sQLiteDatabaseWrapper.getDatabaseName()).setStorageVersion(sQLiteDatabaseWrapper.getDatabaseVersion()).setEntriesBefore(sQLiteDatabaseWrapper.queryNumEntries("events")).setSizeBefore(sQLiteDatabaseWrapper.getDatabaseSize());
            this.e.closeDatabase();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void b(StorageOperation.Builder builder) {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            builder.setEntriesAfter(sQLiteDatabaseWrapper.queryNumEntries("events")).setSizeAfter(sQLiteDatabaseWrapper.getDatabaseSize());
            this.e.closeDatabase();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @VisibleForTesting(otherwise=2)
    String a(long l) {
        String string = "SELECT ROWID FROM events ORDER BY timestamp ASC LIMIT " + l;
        String string2 = "DELETE FROM %s WHERE ROWID IN (" + string + ");";
        return String.format(string2, "events", "event_id");
    }

    @VisibleForTesting(otherwise=2)
    String b(long l) {
        return "DELETE FROM events WHERE timestamp < " + Long.toString(l) + ";";
    }

    public void setListener(Listener listener) {
        this.f = listener;
    }

    public static interface Listener {
        public void onOperationPerformed(StorageOperation var1);
    }
}

