/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.util.Validator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPool {
    private static String a = "InLocoMedia";
    private static ScheduledExecutorService b;
    private static ThreadPoolExecutor c;
    private static ThreadPoolExecutor d;
    private static Handler e;

    private ThreadPool() {
    }

    public static void execute(Runnable task, boolean usingLimitedPool) {
        if (usingLimitedPool) {
            d.execute(task);
        } else {
            c.execute(task);
        }
    }

    public static void execute(Runnable task) {
        c.submit(task);
    }

    public static void execute(final Runnable task, final Thread.UncaughtExceptionHandler error) {
        c.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Throwable throwable) {
                    error.uncaughtException(Thread.currentThread(), throwable);
                }
            }
        });
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return ThreadPool.submit(task, false);
    }

    public static <T> Future<T> submit(Callable<T> command, boolean usingLimitedPool) {
        if (usingLimitedPool) {
            return d.submit(command);
        }
        return c.submit(command);
    }

    public static void executeInBackground(Runnable runnable) {
        if (Validator.isMainThread()) {
            ThreadPool.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public static void executeInMain(Runnable runnable) {
        if (!Validator.isMainThread()) {
            ThreadPool.executeInMainAt(runnable, 0L, TimeUnit.MILLISECONDS);
        } else {
            runnable.run();
        }
    }

    public static void postOnMain(Runnable runnable) {
        ThreadPool.executeInMainAt(runnable, 0L, TimeUnit.MILLISECONDS);
    }

    public static void executeInMainAt(Runnable runnable, long delay, TimeUnit timeUnit) {
        if (timeUnit != TimeUnit.MILLISECONDS) {
            delay = timeUnit.toMillis(delay);
        }
        if (delay > 0L) {
            e.postDelayed(runnable, delay);
        } else {
            e.post(runnable);
        }
    }

    public static ScheduledFuture<?> executeAt(Runnable command, long delay, TimeUnit unit) {
        return b.schedule(command, delay, unit);
    }

    public static ScheduledFuture<?> executeAt(Runnable command, long delayInMillis) {
        return b.schedule(command, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> executeAtFixedRate(Runnable command, long initialDelayInMillis, long periodInMillis) {
        return b.scheduleAtFixedRate(command, initialDelayInMillis, periodInMillis, TimeUnit.MILLISECONDS);
    }

    private static void a() {
        c = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new com.inlocomedia.android.core.util.a(a + "_MainPool"));
        d = new ThreadPoolExecutor(2, 6, 60L, TimeUnit.SECONDS, new a<Runnable>(), new com.inlocomedia.android.core.util.a(a + "_ImageLoader"), new b());
        b = Executors.newSingleThreadScheduledExecutor();
    }

    private static void b() {
        ThreadPool.a();
        e = new Handler(Looper.getMainLooper());
    }

    public static void waitForThreadsToFinish() throws InterruptedException {
        c.shutdownNow();
        c.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        d.shutdownNow();
        d.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        b.shutdownNow();
        b.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        ThreadPool.a();
    }

    public static ThreadPoolExecutor cacheExecutor() {
        return new ThreadPoolExecutor(1, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new com.inlocomedia.android.core.util.a(a + "_Cache"));
    }

    static {
        ThreadPool.b();
    }

    private static class b
    implements RejectedExecutionHandler {
        private b() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class a<T>
    extends LinkedBlockingQueue<T> {
        private a() {
        }

        @Override
        public boolean offer(@NonNull T e) {
            return this.size() <= 1 && super.offer(e);
        }
    }
}

