/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class ProxyUtils {
    public static final String SDK_NOT_INITIATED = "The SDK must be initiated before calling this method.";

    public static <T> T getProxyInstance(Class<T> klass, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(klass.getClassLoader(), new Class[]{klass}, invocationHandler);
    }

    public static <T> T getProxyInstance(Class<T> klass, String tag, String errorReason) {
        return ProxyUtils.getProxyInstance(klass, ProxyUtils.getEmptyInvocationHandler(tag, errorReason));
    }

    public static InvocationHandler getEmptyInvocationHandler(final String tag, final String errorReason) {
        return new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Log.e((String)tag, (String)("Method call failed for method: " + method.getName() + ". Reason: " + errorReason + " - Stacktrace: " + Arrays.toString(Thread.currentThread().getStackTrace())));
                switch (method.getReturnType().toString()) {
                    case "boolean": {
                        return false;
                    }
                    case "short": {
                        return (short)0;
                    }
                    case "byte": {
                        return (byte)0;
                    }
                    case "long": 
                    case "int": 
                    case "float": 
                    case "double": {
                        return 0;
                    }
                }
                return null;
            }
        };
    }
}

