/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.schedulers.alarm;

import android.os.Bundle;
import com.inlocomedia.android.core.schedulers.TaskInfo;

public class AlarmInfo {
    private String a;
    private Class<?> b;
    private String c;
    private long d;
    private long e;
    private Bundle f;

    AlarmInfo(Builder builder) {
        this.d = builder.a != null ? builder.a : 0L;
        this.e = builder.interval != null ? builder.interval : 0L;
        this.a = builder.action;
        this.b = builder.receiver;
        this.c = builder.description;
        this.f = builder.extras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlarmInfo alarmInfo = (AlarmInfo)o;
        if (this.d != alarmInfo.d) {
            return false;
        }
        if (this.e != alarmInfo.e) {
            return false;
        }
        if (this.a != null ? !this.a.equals(alarmInfo.a) : alarmInfo.a != null) {
            return false;
        }
        if (this.b != null ? !this.b.equals(alarmInfo.b) : alarmInfo.b != null) {
            return false;
        }
        return this.c != null ? this.c.equals(alarmInfo.c) : alarmInfo.c == null;
    }

    public int hashCode() {
        int n = this.a != null ? this.a.hashCode() : 0;
        n = 31 * n + (this.b != null ? this.b.hashCode() : 0);
        n = 31 * n + (this.c != null ? this.c.hashCode() : 0);
        n = 31 * n + (int)(this.d ^ this.d >>> 32);
        n = 31 * n + (int)(this.e ^ this.e >>> 32);
        return n;
    }

    public String toString() {
        return "AlarmInfo{action='" + this.a + '\'' + ", receiverClass=" + (this.b != null ? this.b.getName() : "null") + ", description='" + this.c + '\'' + ", latency=" + this.d + ", interval=" + this.e + ", extras=" + this.f + '}';
    }

    public String getAction() {
        return this.a;
    }

    public Class<?> getReceiver() {
        return this.b;
    }

    public String getDescription() {
        return this.c;
    }

    public long getInterval() {
        return this.e;
    }

    public long getLatency() {
        return this.d;
    }

    public Bundle getExtras() {
        return this.f;
    }

    boolean a() {
        return this.e > 0L;
    }

    public static AlarmInfo fromTaskInfo(TaskInfo taskInfo) {
        Builder builder = new Builder().setInterval(taskInfo.getInterval()).setLatency(taskInfo.getLatency()).setAction(taskInfo.getAction()).setDescription(taskInfo.getDescription()).setReceiver(taskInfo.getAlarmReceivingClass()).setExtras(taskInfo.getExtras());
        return builder.build();
    }

    public static class Builder {
        public String action;
        public Class<?> receiver;
        public String description;
        Long a;
        public Long interval;
        public Bundle extras;

        public AlarmInfo build() {
            return new AlarmInfo(this);
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setReceiver(Class<?> receiver) {
            this.receiver = receiver;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setLatency(long latency) {
            this.a = latency;
            return this;
        }

        public Builder setInterval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder setExtras(Bundle extras) {
            this.extras = extras;
            return this;
        }
    }
}

