/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.VisibleForTesting;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.models.Size;
import com.inlocomedia.android.core.util.ScreenHelper;
import java.lang.reflect.Method;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScreenHelperImpl
implements ScreenHelper {
    private static final String d = Logger.makeTag(ScreenHelperImpl.class);
    private Float e;
    private Context f;
    @VisibleForTesting
    Boolean a;
    @VisibleForTesting
    BroadcastReceiver b;
    @VisibleForTesting
    protected CopyOnWriteArraySet<ScreenHelper.ScreenStateListener> mListeners;
    @VisibleForTesting
    AtomicBoolean c;

    public ScreenHelperImpl(Context context) {
        this.f = context.getApplicationContext();
        this.a = null;
        this.e = null;
        this.c = new AtomicBoolean(false);
    }

    @Override
    public Size getScreenSizeInDp(Context context) {
        DisplayMetrics displayMetrics = this.a(context);
        Size size = this.getScreenSizeInPx(context);
        return new Size(Math.round(size.width / displayMetrics.density), Math.round(size.height / displayMetrics.density));
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public Size getScreenSizeInPx(Context context) {
        int n = 0;
        int n2 = 0;
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics displayMetrics = this.a(context);
            n = displayMetrics.widthPixels;
            n2 = displayMetrics.heightPixels;
        } else {
            try {
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display display = windowManager.getDefaultDisplay();
                Method method = Display.class.getMethod("getRawHeight", new Class[0]);
                Method method2 = Display.class.getMethod("getRawWidth", new Class[0]);
                n2 = (Integer)method.invoke((Object)display, new Object[0]);
                n = (Integer)method2.invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Size(n, n2);
    }

    @Override
    public int getScreenOrientation(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    @Override
    public float getDensity() {
        if (this.e == null) {
            this.e = Float.valueOf(this.a((Context)this.f).density);
        }
        return this.e.floatValue();
    }

    @Override
    public boolean isScreenOn() {
        if (this.a != null) {
            return this.a;
        }
        PowerManager powerManager = (PowerManager)this.f.getSystemService("power");
        if (Build.VERSION.SDK_INT < 20) {
            return powerManager.isScreenOn();
        }
        return powerManager.isInteractive();
    }

    private DisplayMetrics a(Context context) {
        return context.getResources().getDisplayMetrics();
    }

    @Override
    public boolean addScreenStateListener(ScreenHelper.ScreenStateListener listener) {
        boolean bl;
        boolean bl2 = bl = this.mListeners != null || this.registerBroadcastReceiver();
        if (bl) {
            if (this.mListeners == null) {
                this.mListeners = new CopyOnWriteArraySet();
            }
            return this.mListeners.add(listener);
        }
        return false;
    }

    @VisibleForTesting
    protected boolean registerBroadcastReceiver() {
        try {
            if (this.b == null) {
                this.b = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (intent == null) {
                            return;
                        }
                        boolean bl = "android.intent.action.USER_PRESENT".equals(intent.getAction());
                        if (ScreenHelperImpl.this.a == null || ScreenHelperImpl.this.a != bl) {
                            ScreenHelperImpl.this.a = bl;
                            ScreenHelperImpl.this.a(bl);
                        }
                    }
                };
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                if (this.c.compareAndSet(false, true)) {
                    this.f.registerReceiver(this.b, intentFilter);
                }
            }
        }
        catch (Exception exception) {
            this.c.set(false);
            return false;
        }
        return true;
    }

    private void a(boolean bl) {
        if (this.mListeners != null) {
            for (ScreenHelper.ScreenStateListener screenStateListener : this.mListeners) {
                screenStateListener.onScreenStateChanged(bl);
            }
        }
    }

    @Override
    public boolean removeScreenStateListener(ScreenHelper.ScreenStateListener listener) {
        if (this.mListeners == null) {
            return false;
        }
        boolean bl = this.mListeners.remove(listener);
        if (this.mListeners.isEmpty()) {
            this.mListeners = null;
            return this.a();
        }
        return bl;
    }

    private boolean a() {
        try {
            if (this.c.compareAndSet(true, false)) {
                this.f.unregisterReceiver(this.b);
            }
            this.b = null;
            this.a = null;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public float dipToPx(float dip) {
        return dip * this.getDensity();
    }

    @Override
    public float pxToDip(float px) {
        return px / this.getDensity();
    }

    @Override
    public void pxToDip(Rect rectPx, Rect rectDip) {
        rectDip.set((int)this.pxToDip(rectPx.left), (int)this.pxToDip(rectPx.top), (int)this.pxToDip(rectPx.right), (int)this.pxToDip(rectPx.bottom));
    }

    @Override
    public void dipToPx(Rect rectDip, Rect rectPx) {
        rectPx.set((int)this.dipToPx(rectDip.left), (int)this.dipToPx(rectDip.top), (int)this.dipToPx(rectDip.right), (int)this.dipToPx(rectDip.bottom));
    }

    @Override
    public void pxToDip(Size sizePx, Size sizeDip) {
        sizeDip.set(this.pxToDip(sizePx.width), this.pxToDip(sizePx.height));
    }

    @Override
    public void dipToPx(Size sizeDip, Size sizePx) {
        sizePx.set(this.dipToPx(sizeDip.width), this.dipToPx(sizeDip.height));
    }
}

