/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.data.remote;

import android.content.Context;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.communication.Communication;
import com.inlocomedia.android.core.communication.RequestOverview;
import com.inlocomedia.android.core.communication.builders.SimpleHttpRequestBuilder;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.communication.interfaces.RequestOverviewListener;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.util.HttpUtils;
import com.inlocomedia.android.core.communication.util.RestfulMethod;
import com.inlocomedia.android.core.data.remote.Requestor;
import com.inlocomedia.android.core.data.remote.SerializedData;
import com.inlocomedia.android.core.exception.ErrorHandlerManager;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import java.util.HashMap;

public class DataRequestor
implements Requestor<byte[]> {
    private final ErrorHandlerManager a;
    private static final String b = Logger.makeTag(DataRequestor.class);
    private final RequestOverviewListener c;

    public DataRequestor(Context context, ErrorHandlerManager errorHandlerManager) {
        AppContext.set(context);
        this.a = errorHandlerManager;
        this.c = null;
    }

    public DataRequestor(Context context, ErrorHandlerManager errorHandlerManager, RequestOverviewListener requestOverviewListener) {
        AppContext.set(context);
        this.a = errorHandlerManager;
        this.c = requestOverviewListener;
    }

    @Override
    public void sendRequestWithData(final SerializedData data, final RestfulMethod service, RequestListener<byte[]> listener) {
        SimpleHttpRequestBuilder<byte[]> simpleHttpRequestBuilder = new SimpleHttpRequestBuilder<byte[]>(this.a){

            @Override
            public HttpRequestParams build() throws Throwable {
                HttpRequestParams httpRequestParams = new HttpRequestParams(AppContext.get(), service);
                httpRequestParams.setBody(data.getData());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (data.getSerializationType() == 1 || data.getSerializationType() == 2) {
                    hashMap.put("Content-Type", "application/json");
                }
                if (data.getCompressionType() == 101) {
                    hashMap.putAll(HttpUtils.getHeaderGroupForGzip());
                }
                httpRequestParams.setHeaders(hashMap);
                return httpRequestParams;
            }

            public byte[] a(byte[] byArray) throws Throwable {
                return byArray;
            }

            @Override
            public void handleRequestOverview(RequestOverview requestOverview) {
                if (DataRequestor.this.c != null) {
                    DataRequestor.this.c.handleRequestOverview(AppContext.get(), requestOverview);
                }
            }

            @Override
            public /* synthetic */ Object convert(byte[] byArray) throws Throwable {
                return this.a(byArray);
            }
        };
        try {
            listener.onRequestFinished(Communication.executeSync(simpleHttpRequestBuilder));
        }
        catch (InLocoMediaException inLocoMediaException) {
            listener.onRequestFailed(inLocoMediaException);
        }
    }
}

