/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.responses;

import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.inlocomedia.android.core.communication.exception.UnauthorizedException;
import com.inlocomedia.android.core.communication.responses.ResponseData;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class UrlResponse {
    private static final String a = Logger.makeTag(UrlResponse.class);
    private int b;
    private String c;
    private String d;
    private ResponseData e;
    private InLocoMediaException f;
    private String g;

    UrlResponse(ResponseData responseData) throws IllegalStateException, IOException {
        this.e = responseData != null ? responseData : new ResponseData();
        this.b = 200;
    }

    @VisibleForTesting(otherwise=3)
    public UrlResponse(InLocoMediaException error) {
        this.f = error;
        this.e = new ResponseData();
    }

    public boolean isSuccessful() {
        return this.f == null && this.b >= 200 && this.b <= 299;
    }

    public boolean isUnauthorized() {
        return this.b == 401 || this.f instanceof UnauthorizedException;
    }

    public byte[] getResponseBytes() {
        return this.e.getBytes();
    }

    public InLocoMediaException getErrorReceived() {
        return this.f;
    }

    private boolean a() {
        return this.f != null;
    }

    public void setErrorReceived(InLocoMediaException errorReceived) {
        this.f = errorReceived;
    }

    private boolean b() {
        return this.d != null && (this.d.contains("application/json") || this.d.contains("text/plain"));
    }

    private String c() throws UnsupportedEncodingException {
        return new String(this.getResponseBytes(), "UTF-8");
    }

    public void setRequestedUrl(String url) {
        this.g = url;
    }

    public String getRequestedUrl() {
        return this.g;
    }

    public void setStatusCode(int statusCode) {
        this.b = statusCode;
    }

    public void setContentType(String contentType) {
        this.d = contentType;
    }

    public String getStatusMessage() {
        return this.c;
    }

    public void setStatusMessage(String statusMessage) {
        this.c = statusMessage;
    }

    public int getStatusCode() {
        return this.b;
    }

    public String getContentType() {
        return this.d;
    }

    public void setResponseData(ResponseData responseData) {
        this.e = responseData;
    }

    public int getResponseSize() {
        return this.e != null ? this.e.getResponseSize() : 0;
    }

    public boolean isCached() {
        return this.e != null && this.e.isCached();
    }

    public void print() {
        if (this.a()) {
            Log.w((String)a, (String)("Request error: " + InLocoMediaException.getFormattedMessage(this.getErrorReceived())));
        } else if (this.b()) {
            try {
                Log.d((String)a, (String)("Response: " + this.c()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }
}

