/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.requests;

import android.util.Log;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.communication.cache.CacheManager;
import com.inlocomedia.android.core.communication.requests.HttpRequest;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.responses.HttpUrlConnectionResponse;
import com.inlocomedia.android.core.communication.responses.ResponseData;
import com.inlocomedia.android.core.communication.responses.UrlResponse;
import com.inlocomedia.android.core.communication.util.CacheConfig;
import com.inlocomedia.android.core.communication.util.HttpUtils;
import com.inlocomedia.android.core.communication.util.LoadState;
import com.inlocomedia.android.core.communication.util.NetworkAccessTools;
import com.inlocomedia.android.core.exception.ErrorHandlerManager;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.OperationTimer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.Map;

public class HttpUrlConnectionRequest
extends HttpRequest {
    private static final String b = Logger.makeTag(HttpUrlConnectionRequest.class.getSimpleName());
    private HttpURLConnection c;

    public HttpUrlConnectionRequest(HttpRequestParams params, ErrorHandlerManager errorHandler) {
        super(params, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UrlResponse run() {
        Object object;
        HttpUrlConnectionResponse httpUrlConnectionResponse = null;
        try {
            if (this.isCanceled()) {
                UrlResponse urlResponse = null;
                return urlResponse;
            }
            this.mParams.buildUrl();
            if (this.mParams.isCacheEnabled()) {
                httpUrlConnectionResponse = this.a();
            }
            if (httpUrlConnectionResponse == null) {
                String string = this.mParams.getUrl();
                NetworkAccessTools.validateNetworkAvailable(this.mParams.getContext());
                object = this.mParams.getMethod();
                this.c = (HttpURLConnection)new URL(string).openConnection();
                this.c.setReadTimeout(15000);
                this.c.setConnectTimeout(15000);
                this.c.setInstanceFollowRedirects(true);
                this.c.setRequestMethod((String)object);
                for (Map.Entry<String, String> object22 : this.mParams.getHeaders().entrySet()) {
                    this.c.setRequestProperty(object22.getKey(), object22.getValue());
                }
                Object object3 = this.mParams.getBody();
                if (object3 != null) {
                    if (this.mParams.getHeaders().containsKey("Content-Encoding") && this.mParams.getHeaders().get("Content-Encoding").equals("gzip")) {
                        object3 = HttpUtils.gzip((byte[])object3);
                    }
                    this.c.setDoOutput(true);
                    this.c.getOutputStream().write((byte[])object3);
                }
                if (Environment.isCommunicationDebug()) {
                    this.print();
                }
                OperationTimer operationTimer = new OperationTimer();
                if (this.isCanceled()) {
                    UrlResponse urlResponse = null;
                    return urlResponse;
                }
                this.c.connect();
                if (this.isCanceled()) {
                    UrlResponse urlResponse = null;
                    return urlResponse;
                }
                httpUrlConnectionResponse = this.a(this.c);
                if (this.isCanceled()) {
                    UrlResponse inLocoMediaException = null;
                    return inLocoMediaException;
                }
                httpUrlConnectionResponse.setRequestedUrl(string);
                if (!httpUrlConnectionResponse.isSuccessful()) {
                    InLocoMediaException inLocoMediaException = this.handleError(string, httpUrlConnectionResponse);
                    httpUrlConnectionResponse.setErrorReceived(inLocoMediaException);
                } else if (this.mParams.isResponseCacheable() && !this.mParams.shouldStoreData()) {
                    this.a(this.c, httpUrlConnectionResponse.getResponseBytes());
                }
                if (Environment.isCommunicationDebug()) {
                    Log.d((String)b, (String)("Request at " + this.mParams.getUrl() + " finished in " + operationTimer.getDuration() + " milliseconds."));
                    httpUrlConnectionResponse.print();
                }
            }
        }
        catch (Throwable throwable) {
            object = this.handleError(this.mParams.getUrl(), throwable);
            httpUrlConnectionResponse = new HttpUrlConnectionResponse((InLocoMediaException)object);
        }
        finally {
            this.shutdown();
        }
        if (this.isCanceled()) {
            this.a = LoadState.FINISHED;
            return null;
        }
        this.a = LoadState.FINISHED;
        return httpUrlConnectionResponse;
    }

    private HttpUrlConnectionResponse a(HttpURLConnection httpURLConnection) throws IOException {
        HttpUrlConnectionResponse httpUrlConnectionResponse = new HttpUrlConnectionResponse((ResponseData)null);
        httpUrlConnectionResponse.setHeaders(httpURLConnection.getHeaderFields());
        String string = httpURLConnection.getContentType();
        if (string != null) {
            String string2 = string.split(";")[0].trim();
            httpUrlConnectionResponse.setContentType(string2);
        }
        try {
            httpUrlConnectionResponse.setStatusCode(httpURLConnection.getResponseCode());
            httpUrlConnectionResponse.setStatusMessage(httpURLConnection.getResponseMessage());
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().contains("No authentication challenges")) {
                httpUrlConnectionResponse.setStatusCode(401);
                httpUrlConnectionResponse.setStatusMessage("Unauthorized");
            }
            throw iOException;
        }
        httpUrlConnectionResponse.setResponseData(this.a(httpUrlConnectionResponse, httpURLConnection));
        return httpUrlConnectionResponse;
    }

    private ResponseData a(HttpUrlConnectionResponse httpUrlConnectionResponse, HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = httpUrlConnectionResponse.isSuccessful() ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        ResponseData responseData = httpUrlConnectionResponse.isSuccessful() && this.mParams.shouldStoreData() ? this.b(inputStream) : this.a(inputStream);
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseData a(InputStream inputStream) throws IOException {
        ResponseData responseData = new ResponseData();
        if (inputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n;
                byte[] byArray = new byte[4096];
                while (!this.isCanceled() && -1 != (n = inputStream.read(byArray))) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                responseData.setBytes(byArray2);
                responseData.setResponseSize(byArray2.length);
            }
            finally {
                inputStream.close();
            }
        }
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ResponseData b(InputStream var1_1) throws IOException {
        var2_2 = new ResponseData();
        var3_3 = this.mParams.getCacheConfig().getCacheManager();
        var5_5 = var3_3.getTempFile(var4_4 = this.mParams.getCacheConfig().getKey());
        if (var5_5.exists()) {
            var5_5.delete();
        }
        if (var5_5.createNewFile() && var1_1 != null) {
            var6_6 = new FileOutputStream(var5_5);
            try {
                var7_7 = new byte[4096];
                while (!this.isCanceled() && -1 != (var8_8 = var1_1.read(var7_7))) {
                    var6_6.write(var7_7, 0, var8_8);
                    var2_2.setResponseSize(var2_2.getResponseSize() + var8_8);
                }
                if (this.isCanceled()) ** GOTO lbl28
                var3_3.setTempFileCompleted(var4_4);
            }
            finally {
                if (var5_5.exists()) {
                    var5_5.delete();
                }
                var6_6.close();
                var1_1.close();
            }
        } else {
            this.cancel();
            throw new IOException();
        }
lbl28:
        // 2 sources

        var6_6 = var3_3.getFile(var4_4);
        var3_3.put((File)var6_6);
        var2_2.setBytes(var6_6.getAbsolutePath().getBytes("UTF-8"));
        return var2_2;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.c != null) {
            this.c.disconnect();
        }
    }

    private HttpUrlConnectionResponse a() throws IOException {
        CacheConfig cacheConfig = this.mParams.getCacheConfig();
        CacheManager cacheManager = cacheConfig.getCacheManager();
        if (cacheManager.isCached(cacheConfig.getKey())) {
            byte[] byArray = this.mParams.shouldStoreData() ? cacheManager.getFilePath(cacheConfig.getKey()).getBytes("UTF-8") : cacheManager.get(cacheConfig.getKey());
            if (Environment.isCommunicationDebug()) {
                Log.d((String)b, (String)("Request at " + this.mParams.getUrl() + " finished with cached value"));
            }
            ResponseData responseData = new ResponseData(byArray, 0, true);
            return new HttpUrlConnectionResponse(responseData);
        }
        return null;
    }

    private void a(HttpURLConnection httpURLConnection, byte[] byArray) {
        Object object;
        String string = httpURLConnection.getHeaderField("Cache-Control");
        if (string != null && (((String)(object = string.toLowerCase(Locale.US))).contains("no-cache") || ((String)object).contains("no-store"))) {
            return;
        }
        if (Environment.isCommunicationDebug()) {
            Log.d((String)b, (String)("Caching response for url " + this.mParams.getUrl()));
        }
        object = this.mParams.getCacheConfig().getCacheManager();
        ((CacheManager)object).put(this.mParams.getCacheConfig().getKey(), byArray);
    }
}

