/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.permissions.PermissionsHandler;
import com.inlocomedia.android.core.util.StreamHelper;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class MediaStorageHelper {
    public static boolean isAvailable(@NonNull Context context, PermissionsHandler permissionsHandler) {
        if ("mounted".equals(Environment.getExternalStorageState())) {
            if (Build.VERSION.SDK_INT < 23) {
                return Validator.b(context);
            }
            return !permissionsHandler.isPermissionDeniedForever(context, "android.permission.WRITE_EXTERNAL_STORAGE") && Validator.a(context);
        }
        return false;
    }

    public static void storeBitmap(final @NonNull Bitmap bmp, final @NonNull String relativeFolder, final @NonNull String filename, final @NonNull Bitmap.CompressFormat compressFormat, final @Nullable MediaStorageListener listener) {
        ThreadPool.executeInBackground(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block10: {
                    ByteArrayInputStream byteArrayInputStream = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        File file = new File(Environment.getExternalStorageDirectory(), relativeFolder);
                        if (!file.mkdirs() && !file.isDirectory()) {
                            this.a("Picture directory can not be created.");
                            return;
                        }
                        File file2 = new File(file, filename);
                        if (file2.isDirectory() || file2.exists()) {
                            this.a("Path already exists.");
                            return;
                        }
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        bmp.compress(compressFormat, 100, (OutputStream)byteArrayOutputStream);
                        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        fileOutputStream = new FileOutputStream(file2);
                        StreamHelper.copy(byteArrayInputStream, fileOutputStream);
                        if (listener != null) {
                            listener.onSuccess(file2.getPath());
                        }
                        StreamHelper.close(byteArrayInputStream);
                    }
                    catch (Exception exception) {
                        this.a("Bitmap storage has failed. " + exception.getMessage());
                        break block10;
                    }
                    finally {
                        StreamHelper.close(byteArrayInputStream);
                        StreamHelper.close(fileOutputStream);
                    }
                    StreamHelper.close(fileOutputStream);
                }
            }

            private void a(String string) {
                if (listener != null) {
                    listener.onFailure(new InLocoMediaException(string));
                }
            }
        });
    }

    public static interface MediaStorageListener {
        public void onSuccess(String var1);

        public void onFailure(InLocoMediaException var1);
    }
}

