/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core;

import android.content.Context;
import android.os.Build;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public class Module<T> {
    private static final String a = Logger.makeTag(Module.class);
    private AtomicBoolean b = new AtomicBoolean(true);
    private AtomicBoolean c = new AtomicBoolean(false);
    private AtomicBoolean d = new AtomicBoolean(false);
    private String e;
    private List<Module<T>> f;
    private final Object g = new Object();
    private final Object h = new Object();

    @SafeVarargs
    public Module(String name, Module<T> ... dependencies) {
        this.e = name;
        this.f = Arrays.asList(dependencies);
    }

    public boolean isValid() {
        if (!Validator.isValidSDKVersion()) {
            String string = String.format(Locale.US, "This device SDK version is below the minimum required version. Minimum: %s, Current %s", 14, Build.VERSION.SDK_INT);
            DevLogger.w(string);
            return false;
        }
        return this.b.get();
    }

    public boolean isValidAndInvalidate() {
        if (this.isValid()) {
            this.setInvalid();
            return true;
        }
        return false;
    }

    public void setInactive() {
        this.c.set(false);
        this.d.set(false);
    }

    public void setActive() {
        this.c.set(true);
        this.d.set(true);
    }

    public boolean isActive() {
        return this.c.get() && this.d.get();
    }

    private void a() {
        this.c.set(true);
    }

    private boolean b() {
        return this.c.get();
    }

    private void c() {
        this.d.set(true);
    }

    private boolean d() {
        return this.d.get();
    }

    public void setInvalid() {
        this.b.set(false);
    }

    public void setValid() {
        this.b.set(true);
    }

    public boolean requiresInitialization() {
        return true;
    }

    private boolean e() {
        return !this.isActive() && this.isValid() && this.requiresInitialization();
    }

    public String toString() {
        return this.e;
    }

    public final void init(final Context context, final T options) {
        if (this.e()) {
            final LinkedHashSet<Module<T>> linkedHashSet = this.f();
            for (Module module : linkedHashSet) {
                module.a(context, options);
            }
            ThreadPool.executeInBackground(new Runnable(){

                @Override
                public void run() {
                    for (Module module : linkedHashSet) {
                        module.b(context, options);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Context context, T t) {
        Object object = this.g;
        synchronized (object) {
            try {
                if (this.isValid() && !this.b()) {
                    this.onStart(context, t);
                    this.a();
                }
            }
            catch (Throwable throwable) {
                this.setInvalid();
                this.onError(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(Context context, T t) {
        Object object = this.h;
        synchronized (object) {
            try {
                if (this.isValid() && !this.d()) {
                    this.onStartInBackground(context, t);
                    this.c();
                }
            }
            catch (Throwable throwable) {
                this.setInvalid();
                this.onError(throwable);
            }
        }
    }

    protected void onStart(Context context, T options) {
    }

    protected void onStartInBackground(Context context, T options) {
    }

    protected void onError(Throwable t) {
        DevLogger.e("Module " + this.e + " failed to initialize. Error: " + t.getLocalizedMessage());
    }

    private LinkedHashSet<Module<T>> f() {
        LinkedHashSet<Module<T>> linkedHashSet = new LinkedHashSet<Module<T>>();
        HashSet<Module<T>> hashSet = new HashSet<Module<T>>();
        this.a(linkedHashSet, hashSet);
        return linkedHashSet;
    }

    private void a(LinkedHashSet<Module<T>> linkedHashSet, HashSet<Module<T>> hashSet) {
        hashSet.add(this);
        for (Module<T> module : this.f) {
            if (hashSet.contains(module)) continue;
            super.a(linkedHashSet, hashSet);
        }
        if (this.e()) {
            linkedHashSet.add(this);
        }
    }
}

