/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.schedulers.alarm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.schedulers.alarm.AlarmInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AlarmHelper {
    private static final String a = Logger.makeTag(AlarmHelper.class);
    public static final int ALARM_CODE_GEOFENCE_TRANSITION = 0;
    private Map<Integer, AlarmInfo> b;

    public AlarmHelper(Context context) {
        AppContext.set(context);
        this.b = new ConcurrentHashMap<Integer, AlarmInfo>();
    }

    public PendingIntent getPendingIntent(int alarmCode) {
        return this.getPendingIntent(alarmCode, 0x8000000);
    }

    public PendingIntent getPendingIntent(int alarmCode, int pendingIntentFlag) {
        AlarmInfo alarmInfo = this.b.get(alarmCode);
        if (alarmInfo != null) {
            Intent intent = new Intent(AppContext.get(), alarmInfo.getReceiver());
            intent.setAction(alarmInfo.getAction());
            intent.setPackage(AppContext.get().getPackageName());
            if (alarmInfo.getExtras() != null) {
                intent.putExtras(alarmInfo.getExtras());
            }
            return PendingIntent.getBroadcast((Context)AppContext.get(), (int)alarmCode, (Intent)intent, (int)pendingIntentFlag);
        }
        return null;
    }

    public boolean enableAlarm(int alarmCode, @NonNull AlarmInfo alarmInfo) {
        this.b.put(alarmCode, alarmInfo);
        long l = alarmInfo.getLatency() + SystemClock.elapsedRealtime();
        if (l >= SystemClock.elapsedRealtime()) {
            AlarmManager alarmManager = (AlarmManager)AppContext.get().getSystemService("alarm");
            if (alarmInfo.a()) {
                alarmManager.setRepeating(2, l, alarmInfo.getInterval(), this.getPendingIntent(alarmCode));
            } else {
                alarmManager.set(2, l, this.getPendingIntent(alarmCode));
            }
            this.a(l, alarmInfo);
            return true;
        }
        this.disableAlarm(alarmCode);
        return false;
    }

    private void a(long l, AlarmInfo alarmInfo) {
    }

    public void disableAlarm(int alarmCode) {
        if (this.isAlarmActivated(alarmCode)) {
            PendingIntent pendingIntent = this.getPendingIntent(alarmCode);
            AlarmManager alarmManager = (AlarmManager)AppContext.get().getSystemService("alarm");
            alarmManager.cancel(pendingIntent);
            pendingIntent.cancel();
            this.b.remove(alarmCode);
        }
    }

    public boolean isAlarmActivated(int alarmCode) {
        return this.getPendingIntent(alarmCode, 0x20000000) != null;
    }
}

