/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.annotations.AccessedByTests;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.config.DataControllerConfig;
import com.inlocomedia.android.core.data.local.database.DatabaseStorage;
import com.inlocomedia.android.core.data.local.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.data.remote.DataController;
import com.inlocomedia.android.core.data.remote.DataRequestor;
import com.inlocomedia.android.core.data.remote.JSONProcessor;
import com.inlocomedia.android.core.exception.ErrorHandlerManager;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.ErrorNotifier;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.SaltedDelayedTask;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.time.TimeProvider;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class CriticalErrorManager
implements ErrorNotifier,
Thread.UncaughtExceptionHandler {
    private static final String a = Logger.makeTag(CriticalErrorManager.class);
    private static final DateFormat b = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
    @AccessedByTests
    private static final ErrorHandlerManager c;
    private final Map<String, Serializable> d;
    private TimeProvider e;
    @AccessedByTests
    private SaltedDelayedTask f;
    @AccessedByTests
    private DataController g;

    public CriticalErrorManager(@NonNull Context context, DataControllerConfig config, TimeProvider timeProvider) {
        AppContext.set(context);
        this.e = timeProvider;
        this.d = new HashMap<String, Serializable>();
        LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper = new LazyCloseSQLiteOpenHelper(context, config.getDatabaseName(), null, config.getDatabaseVersion(), this);
        DatabaseStorage databaseStorage = new DatabaseStorage(lazyCloseSQLiteOpenHelper, config.getMaxDatabaseRows(), timeProvider);
        DataRequestor dataRequestor = new DataRequestor(context, c);
        JSONProcessor jSONProcessor = new JSONProcessor();
        this.g = new DataController.Builder().setContext(context).setDataControllerConfig(config).setStorage(databaseStorage).setProcessor(jSONProcessor).setRequestor(dataRequestor).setUncaughtExceptionHandler(this).build();
    }

    @Override
    public synchronized void start() {
        try {
            if (this.f != null) {
                this.f.invalidate();
            }
            this.f = new SaltedDelayedTask(){

                @Override
                protected void runDelayed() {
                    try {
                        if (Environment.CoreModulesManager.ERROR_UPLOAD.isValid()) {
                            CriticalErrorManager.this.g.enableTransmissionsInterval(true);
                            CriticalErrorManager.this.a();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                @Override
                protected void onError(Throwable t) {
                }
            };
            this.f.start(a);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @VisibleForTesting
    void a() {
        File file = AppContext.get().getDatabasePath("InLocoMediaCriticalError");
        if (file.exists()) {
            AppContext.get().deleteDatabase("InLocoMediaCriticalError");
        }
    }

    @Override
    public void stop() {
        if (this.f != null) {
            this.g.enableTransmissionsInterval(false);
            this.f.invalidate();
        }
    }

    public void addExtraParam(String key, Serializable value) {
        this.d.put(key, value);
    }

    @Override
    public void notifyError(String tag, Throwable e, Module module) {
        this.notifyError(tag, e, module, true, null);
    }

    public void notifyError(String tag, Throwable e, Module module, boolean uploadNow) {
        this.notifyError(tag, e, module, uploadNow, null);
    }

    public void notifyError(final String tag, final Throwable e, final Module module, final boolean uploadNow, final @Nullable RequestListener<byte[]> listener) {
        Logger.a(tag, e);
        ThreadPool.executeInBackground(new Runnable(){

            @Override
            public void run() {
                block8: {
                    if (module.isValidAndInvalidate()) {
                        try {
                            module.setInvalid();
                            if (Environment.isProductionEnvironment()) {
                                CriticalErrorManager.this.a(tag, e, module, uploadNow, listener);
                            } else if (listener != null) {
                                listener.onRequestFailed(new InLocoMediaException("Environment state may be Production."));
                            }
                            break block8;
                        }
                        catch (Throwable throwable) {
                            if (listener != null) {
                                listener.onRequestFailed(new InLocoMediaException("Notify error has failed", throwable));
                            }
                            break block8;
                        }
                    }
                    if (listener != null) {
                        listener.onRequestFailed(new InLocoMediaException("Invalid module"));
                    }
                }
            }
        });
    }

    private void a(final String string, final Throwable throwable, final Module module, final boolean bl, final @Nullable RequestListener<byte[]> requestListener) {
        ThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (Environment.CoreModulesManager.ERROR_UPLOAD.isValid()) {
                            Map map = CriticalErrorManager.this.a(string, module, InLocoMediaException.getFormattedMessage(throwable), CriticalErrorManager.b(throwable));
                            CriticalErrorManager.this.g.addEvent(0, map, bl, requestListener);
                        } else if (requestListener != null) {
                            requestListener.onRequestFailed(new InLocoMediaException("Invalid ERROR_UPLOAD module"));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (requestListener == null) break block5;
                        requestListener.onRequestFailed(new InLocoMediaException("Critical Error insertion has failed", throwable2));
                    }
                }
            }
        });
    }

    private Map<String, Serializable> a(String string, Module module, String string2, String string3) {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("type", (Serializable)((Object)"sdk_error_log"));
        hashMap.put("app_package_name", (Serializable)((Object)AppContext.get().getPackageName()));
        hashMap.put("sdk_code_version", Integer.valueOf(30301));
        hashMap.put("sdt", (Serializable)((Object)b.format(new Date(this.e.currentTimeMillis()))));
        hashMap.put("tag", (Serializable)((Object)string.replace(' ', '_').replace('\t', '_')));
        hashMap.put("error_msg", (Serializable)((Object)string2));
        hashMap.put("stacktrace", (Serializable)((Object)string3));
        hashMap.put("module", (Serializable)((Object)String.valueOf(module)));
        hashMap.put("sender_name", (Serializable)((Object)"Android-API"));
        this.a(hashMap);
        hashMap.putAll(this.d);
        return hashMap;
    }

    private void a(Map<String, Serializable> map) {
        map.put("os", (Serializable)((Object)"android"));
        map.put("os_version", (Serializable)((Object)String.valueOf(Device.ANDROID_VERSION_CODE)));
        map.put("device_model", (Serializable)((Object)Device.MODEL));
        map.put("device_manufacturer", (Serializable)((Object)Device.MANUFACTURER));
        map.put("mad_id", (Serializable)((Object)Device.getAdOrDeviceId(AppContext.get())));
        map.put("google_aid", (Serializable)((Object)Device.getGoogleAdvertisingId(AppContext.get())));
        map.put("ilm_id", (Serializable)((Object)Device.getDeviceId(AppContext.get())));
    }

    private static String b(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (Environment.CoreModulesManager.ERROR_UPLOAD.isValidAndInvalidate()) {
            // empty if block
        }
    }

    public Serializable getExtraParamValue(String key) {
        return this.d.get(key);
    }

    static {
        b.setTimeZone(TimeZone.getTimeZone("UTC"));
        c = new ErrorHandlerManager();
    }
}

