/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.util;

import com.inlocomedia.android.core.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;

public class BinaryUtils {
    private static final String a = Logger.makeTag(BinaryUtils.class);

    public static String toHex(byte[] data) {
        StringBuilder stringBuilder = new StringBuilder(data.length * 2);
        for (byte by : data) {
            String string = Integer.toHexString(by);
            if (string.length() == 1) {
                stringBuilder.append("0");
            } else if (string.length() == 8) {
                string = string.substring(6);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().toLowerCase(Locale.getDefault());
    }

    public static byte[] fromHex(String hexData) {
        byte[] byArray = new byte[(hexData.length() + 1) / 2];
        int n = 0;
        for (int i = 0; i < hexData.length(); i += 2) {
            String string = hexData.substring(i, i + 2);
            byArray[n++] = (byte)Integer.parseInt(string, 16);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Object object) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromByteArray(byte[] byteArray) throws IOException, ClassNotFoundException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return object;
    }
}

