/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.profile;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.telephony.TelephonyManager;
import com.inlocomedia.android.core.data.local.SharedPreferencesManager;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.GooglePlayServicesHelper;
import com.inlocomedia.android.core.util.IntentUtils;
import com.inlocomedia.android.core.util.MD5;
import com.inlocomedia.android.core.util.Utils;
import com.inlocomedia.android.core.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public final class Device {
    public static final String OS_NAME = "android";
    public static final String MODEL = Build.MODEL;
    public static final String MANUFACTURER = Build.MANUFACTURER;
    public static final String INDUSTRIAL_DESIGN_NAME = Build.DEVICE;
    public static final int ANDROID_VERSION_CODE = Build.VERSION.SDK_INT;
    private static final String a = Logger.makeTag(Device.class);

    private Device() {
    }

    static List<String> a(TelephonyManager telephonyManager) {
        try {
            return Device.a(telephonyManager.getSimOperatorName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<String> getNetworkCarrierName(TelephonyManager tManager) {
        try {
            return Device.a(tManager.getNetworkOperatorName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    static List<String> b(TelephonyManager telephonyManager) {
        try {
            return Device.a(telephonyManager.getSimCountryIso());
        }
        catch (Exception exception) {
            return null;
        }
    }

    static List<String> c(TelephonyManager telephonyManager) {
        try {
            return Device.a(telephonyManager.getNetworkCountryIso());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @VisibleForTesting
    static List<String> a(String string) {
        if (Validator.isNullOrEmpty(string)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(",")) {
            if (string2.isEmpty() || string2.equals("null")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String getAdOrDeviceId(Context context) {
        String string = Device.getGoogleAdvertisingId(context);
        if (string == null) {
            string = Device.getDeviceId(context);
        }
        return string;
    }

    public static boolean isAdTrackingEnabled(@NonNull Context context) {
        return !GooglePlayServicesHelper.isLimitAdTrackingEnabled(context);
    }

    @Nullable
    public static String getGoogleAdvertisingId(@NonNull Context context) {
        return GooglePlayServicesHelper.getAdvertisingId(context);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static String getDeviceId(Context context) {
        SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getInstance(context);
        String string = sharedPreferencesManager.getEntry("7OLmdmz8vjKtQQKjEuy0").getString("zbAsYg5vOUMV3SWbst7A");
        if (string == null) {
            string = Device.a();
            sharedPreferencesManager.getEntry("7OLmdmz8vjKtQQKjEuy0").put("zbAsYg5vOUMV3SWbst7A", string).commit();
        }
        return string;
    }

    @VisibleForTesting
    static String a() {
        return "ILM-ID-" + UUID.randomUUID().toString();
    }

    @Nullable
    public static String getDevelopmentDeviceId(Context context) {
        String string = MD5.calculateMD5(Device.a(context));
        if (string != null) {
            return string.toUpperCase(Locale.US);
        }
        return null;
    }

    @SuppressLint(value={"HardwareIds"})
    @Nullable
    private static String a(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    @Nullable
    public static HashSet<String> getInstalledPackageNames(Context context) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            List list = context.getPackageManager().getInstalledApplications(0);
            for (ApplicationInfo applicationInfo : list) {
                if ((applicationInfo.flags & 1) != 0) continue;
                hashSet.add(applicationInfo.packageName);
            }
        }
        catch (RuntimeException runtimeException) {
            hashSet = null;
        }
        return hashSet;
    }

    public static boolean canHandleIntentForUri(Context context, String uri) {
        return uri != null && Device.canHandleIntent(context, IntentUtils.getIntentForUri(context, uri));
    }

    public static boolean canHandleIntent(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public static boolean canHandleIntentForUriOnlyOnBrowserApp(Context context, String uri) {
        String string = "http://" + Utils.generateRandomAlphaNumString(20) + "." + Utils.generateRandomAlphaNumString(3);
        List<String> list = Device.a(context, string);
        List<String> list2 = Device.a(context, uri);
        list2.removeAll(list);
        return list2.size() == 0;
    }

    private static List<String> a(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(IntentUtils.getIntentForUri(context, string), 65536);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ResolveInfo resolveInfo : list) {
            arrayList.add(resolveInfo.activityInfo.packageName);
        }
        return arrayList;
    }
}

