/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.data.local.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.VisibleForTesting;
import android.util.SparseArray;
import com.inlocomedia.android.core.communication.util.BinaryUtils;
import com.inlocomedia.android.core.data.local.Storage;
import com.inlocomedia.android.core.data.local.StorageEntry;
import com.inlocomedia.android.core.data.local.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseListener;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseWrapper;
import com.inlocomedia.android.core.data.local.database.StorageOperation;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.time.TimeProvider;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DatabaseStorage
implements Storage,
SQLiteDatabaseListener {
    private static final String b = Logger.makeTag(DatabaseStorage.class);
    private int c;
    private LazyCloseSQLiteOpenHelper d;
    private Listener e;
    private TimeProvider f;
    @VisibleForTesting
    long a;

    public DatabaseStorage(LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper, int databaseMaxRows, TimeProvider timeProvider) {
        this(lazyCloseSQLiteOpenHelper, databaseMaxRows, timeProvider, null);
    }

    public DatabaseStorage(LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper, int databaseMaxRows, TimeProvider timeProvider, Listener listener) {
        this.d = lazyCloseSQLiteOpenHelper;
        this.d.setDatabaseListener(this);
        this.c = databaseMaxRows;
        this.e = listener;
        this.a = Long.MAX_VALUE;
        this.f = timeProvider;
    }

    @Override
    public synchronized int insert(int id, Map<String, Serializable> values) {
        String string;
        StorageEntry storageEntry = new StorageEntry();
        long l = System.currentTimeMillis();
        storageEntry.add(l, values);
        boolean bl = this.a(id, storageEntry);
        String string2 = string = bl ? "Values saved successfully: " : "Failure saving values: ";
        if (!bl) {
            return 3;
        }
        if (this.b() >= (long)this.c) {
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void trim() {
        StorageOperation.Builder builder = new StorageOperation.Builder().setOperation(2);
        if (this.e != null) {
            this.a(builder);
        }
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            long l = sQLiteDatabaseWrapper.queryNumEntries("events");
            if (l > (long)this.c) {
                long l2 = l - (long)(this.c / 2);
                sQLiteDatabaseWrapper.execSQL(this.a(l2));
            }
            this.d.closeDatabase();
        }
        catch (Throwable throwable) {
            if (this.e != null) {
                builder.setOperation(5);
            }
            this.d.onUnexpectedError(throwable);
        }
        finally {
            if (this.e != null) {
                this.b(builder);
                this.e.onOperationPerformed(builder.build());
            }
        }
    }

    @Override
    public synchronized void clean() {
        try {
            this.a();
        }
        catch (Throwable throwable) {
            this.d.onUnexpectedError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SparseArray<StorageEntry> dump() {
        try (Cursor cursor = null;){
            SparseArray sparseArray = new SparseArray();
            cursor = this.c();
            if (cursor != null) {
                int n = cursor.getColumnIndex("event_id");
                int n2 = cursor.getColumnIndex("timestamp");
                int n3 = cursor.getColumnIndex("event_values");
                while (cursor.moveToNext()) {
                    int n4 = cursor.getInt(n);
                    long l = cursor.getLong(n2);
                    byte[] byArray = cursor.getBlob(n3);
                    StorageEntry storageEntry = (StorageEntry)sparseArray.get(n4);
                    if (storageEntry == null) {
                        storageEntry = new StorageEntry();
                        sparseArray.put(n4, (Object)storageEntry);
                    }
                    storageEntry.add(l, (Map)BinaryUtils.fromByteArray(byArray));
                }
            }
            this.a = this.f.currentTimeMillis();
            SparseArray sparseArray2 = sparseArray;
            return sparseArray2;
        }
    }

    @Override
    public synchronized void onCreate(SQLiteDatabaseWrapper databaseWrapper) {
        try {
            databaseWrapper.execSQL("CREATE TABLE events(_id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp INTEGER, event_id INTEGER NOT NULL, event_values BLOB); ");
        }
        catch (Throwable throwable) {
            this.d.onUnexpectedError(throwable);
        }
    }

    @Override
    public synchronized void onUpgrade(SQLiteDatabaseWrapper databaseWrapper, int oldVersion, int newVersion) {
        this.a(databaseWrapper);
    }

    @Override
    public synchronized void onDowngrade(SQLiteDatabaseWrapper databaseWrapper, int oldVersion, int newVersion) {
        this.a(databaseWrapper);
    }

    private void a(SQLiteDatabaseWrapper sQLiteDatabaseWrapper) {
        try {
            sQLiteDatabaseWrapper.execSQL("DROP TABLE IF EXISTS events");
            this.onCreate(sQLiteDatabaseWrapper);
        }
        catch (Throwable throwable) {
            this.d.onUnexpectedError(throwable);
        }
    }

    private void a() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d.openDatabase();
        if (sQLiteDatabaseWrapper != null) {
            sQLiteDatabaseWrapper.execSQL(this.b(this.a));
        }
        this.d.closeDatabase();
    }

    private boolean a(int n, StorageEntry storageEntry) {
        boolean bl = true;
        List<Map<String, Serializable>> list = storageEntry.getValuesList();
        for (Map<String, Serializable> map : list) {
            bl &= this.a(n, map, storageEntry.getTimestampFromValues(map));
        }
        return bl;
    }

    private boolean a(int n, Map<String, Serializable> map, long l) {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return false;
            }
            ContentValues contentValues = this.b(n, map, l);
            long l2 = sQLiteDatabaseWrapper.insert("events", contentValues);
            this.d.closeDatabase();
            return l2 > 0L;
        }
        catch (Throwable throwable) {
            this.d.onUnexpectedError(throwable);
            return false;
        }
    }

    private long b() {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return -1L;
            }
            long l = sQLiteDatabaseWrapper.queryNumEntries("events");
            this.d.closeDatabase();
            return l;
        }
        catch (Throwable throwable) {
            this.d.onUnexpectedError(throwable);
            return -1L;
        }
    }

    private ContentValues b(int n, Map<String, Serializable> map, long l) throws IOException {
        ContentValues contentValues = new ContentValues();
        contentValues.put("event_id", Integer.valueOf(n));
        contentValues.put("timestamp", Long.valueOf(l));
        byte[] byArray = BinaryUtils.toByteArray(map);
        contentValues.put("event_values", byArray);
        return contentValues;
    }

    private Cursor c() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d.openDatabase();
        if (sQLiteDatabaseWrapper == null) {
            return null;
        }
        Cursor cursor = sQLiteDatabaseWrapper.queryAll("events");
        this.d.closeDatabase();
        return cursor;
    }

    private void a(StorageOperation.Builder builder) {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            builder.setStorageName(sQLiteDatabaseWrapper.getDatabaseName()).setStorageVersion(sQLiteDatabaseWrapper.getDatabaseVersion()).setEntriesBefore(sQLiteDatabaseWrapper.queryNumEntries("events")).setSizeBefore(sQLiteDatabaseWrapper.getDatabaseSize());
            this.d.closeDatabase();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void b(StorageOperation.Builder builder) {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.d.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            builder.setEntriesAfter(sQLiteDatabaseWrapper.queryNumEntries("events")).setSizeAfter(sQLiteDatabaseWrapper.getDatabaseSize());
            this.d.closeDatabase();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @VisibleForTesting(otherwise=2)
    String a(long l) {
        String string = "SELECT ROWID FROM events ORDER BY timestamp ASC LIMIT " + l;
        String string2 = "DELETE FROM %s WHERE ROWID IN (" + string + ");";
        return String.format(string2, "events", "event_id");
    }

    @VisibleForTesting(otherwise=2)
    String b(long l) {
        return "DELETE FROM events WHERE timestamp < " + Long.toString(l) + ";";
    }

    public void setListener(Listener listener) {
        this.e = listener;
    }

    public static interface Listener {
        public void onOperationPerformed(StorageOperation var1);
    }
}

