/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core;

import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.util.SaltedDelayedTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class Environment {
    public static final String VERSION_NAME = "3.3.0";
    public static final int VERSION_CODE = 30300;
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_CRITICAL_ERROR = true;
    public static final boolean JSON_REFLECTION_DEBUG = false;
    public static final String SESSION_IDENTIFIER = UUID.randomUUID().toString();
    private static boolean a = true;
    private static Environment b = new Environment();

    private Environment() {
    }

    public static boolean isProductionEnvironment() {
        return b.isProductionEnvironmentInstance();
    }

    public boolean isProductionEnvironmentInstance() {
        return true;
    }

    public static void setDeveloperDebugEnabled(boolean enabled) {
        a = enabled;
    }

    public static boolean isCommunicationDebug() {
        return false;
    }

    public static boolean debugDeveloper() {
        return a;
    }

    @VisibleForTesting
    public static void setInstance(Environment instance) {
        b = instance;
    }

    @VisibleForTesting
    public static void reset() {
        b = new Environment();
        CoreModulesManager.reset();
    }

    static {
        switch (2) {
            case 0: {
                SaltedDelayedTask.setDebugEnabled(true);
            }
        }
    }

    public static class CoreModule
    extends Module<Object> {
        public CoreModule(String name) {
            super(name, new Module[0]);
        }

        @Override
        public boolean isValid() {
            if (this == CoreModulesManager.SDK) {
                return super.isValid();
            }
            return super.isValid() && CoreModulesManager.SDK.isValid();
        }

        @Override
        public boolean requiresInitialization() {
            return !this.equals(CoreModulesManager.PERMISSIONS);
        }
    }

    public static final class CoreModulesManager {
        public static final CoreModule SDK = new CoreModule("Sdk");
        public static final CoreModule ERROR_UPLOAD = new CoreModule("Error Upload");
        public static final CoreModule PERMISSIONS = new CoreModule("Permission");
        public static final CoreModule STORAGE = new CoreModule("Storage");
        public static final List<CoreModule> MODULES = new ArrayList<CoreModule>(Arrays.asList(SDK, ERROR_UPLOAD, PERMISSIONS, STORAGE));

        public static void reset() {
            for (CoreModule coreModule : MODULES) {
                coreModule.setValid();
                coreModule.setInactive();
            }
        }
    }
}

