/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.widget.ImageView;
import com.inlocomedia.android.core.log.Logger;

public final class ImageHelper {
    private static final String a = Logger.makeTag(ImageHelper.class);

    private ImageHelper() {
    }

    public static Bitmap decode(byte[] array, ImageView imageView, int width, int height) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (width > 0 || height > 0) {
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])array, (int)0, (int)array.length, (BitmapFactory.Options)options);
            if (imageView != null) {
                width = Math.min(imageView.getMeasuredWidth(), width);
                height = Math.min(imageView.getMeasuredHeight(), height);
            }
            options.inSampleSize = ImageHelper.a(options, width, height);
        }
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])array, (int)0, (int)array.length, (BitmapFactory.Options)options);
    }

    private static int a(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outHeight;
        int n4 = options.outWidth;
        int n5 = 1;
        if (n3 > n2 || n4 > n) {
            int n6 = n3 / 2;
            int n7 = n4 / 2;
            while (n6 / n5 >= n2 && n7 / n5 >= n) {
                if ((n5 <<= 1) != 0) continue;
                return 1;
            }
        }
        return n5;
    }

    public static int getDominantColor(Bitmap bitmap) {
        if (bitmap == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = bitmap.hasAlpha();
        int n5 = bitmap.getWidth() * bitmap.getHeight();
        int[] nArray = new int[n5];
        bitmap.getPixels(nArray, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        int n6 = bitmap.getHeight();
        for (int i = 0; i < n6; ++i) {
            int n7 = bitmap.getWidth();
            for (int j = 0; j < n7; ++j) {
                int n8 = nArray[j + i * n7];
                n += n8 >> 16 & 0xFF;
                n2 += n8 >> 8 & 0xFF;
                n3 += n8 & 0xFF;
                if (!bl) continue;
                n4 += n8 >>> 24;
            }
        }
        return Color.argb((int)(bl ? n4 / n5 : 255), (int)(n / n5), (int)(n2 / n5), (int)(n3 / n5));
    }

    @ColorInt
    public static int getContrastingColor(@ColorInt int color) {
        int n;
        int n2;
        int n3 = Color.red((int)color);
        int n4 = (n3 * 299 + (n2 = Color.green((int)color)) * 587 + (n = Color.blue((int)color)) * 114) / 1000;
        return n4 >= 172 ? -16777216 : -1;
    }
}

