/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.data.remote;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.SparseArray;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.communication.util.NetworkAccessTools;
import com.inlocomedia.android.core.config.CyclicReloader;
import com.inlocomedia.android.core.config.DataControllerConfig;
import com.inlocomedia.android.core.config.Reloader;
import com.inlocomedia.android.core.config.ReloaderListener;
import com.inlocomedia.android.core.data.local.Storage;
import com.inlocomedia.android.core.data.local.StorageEntry;
import com.inlocomedia.android.core.data.remote.Processor;
import com.inlocomedia.android.core.data.remote.Requestor;
import com.inlocomedia.android.core.data.remote.SerializedData;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class DataController
implements ReloaderListener {
    private static final String a = Logger.makeTag(DataController.class);
    private Context b;
    private DataControllerConfig c;
    private Storage d;
    private Processor e;
    private Requestor<byte[]> f;
    private Reloader g;
    private Thread.UncaughtExceptionHandler h;
    private boolean i;
    private AtomicBoolean j;

    @VisibleForTesting(otherwise=2)
    protected DataController(Builder builder) {
        this.b = builder.a;
        this.c = builder.b;
        this.d = builder.e;
        this.e = builder.c;
        this.f = builder.d;
        this.h = builder.f;
        this.i = false;
        this.j = new AtomicBoolean(false);
        this.g = new CyclicReloader(builder.a, this.c.getTentativeTransmissionsInterval(), this.c.getDataControllerId() + "DataController", this);
    }

    public void enableTransmissionsInterval(boolean turnOn) {
        if (!this.i && turnOn && this.c.isEnabled()) {
            this.i = true;
            this.g.start();
        } else if (this.i && !turnOn) {
            this.i = false;
            this.g.finish();
        }
        if (!this.c.isEnabled()) {
            this.d.clean();
        }
    }

    public void addEvent(int id, Map<String, Serializable> values) {
        this.addEvent(id, values, false, null);
    }

    public void addEvent(final int id, final Map<String, Serializable> values, final boolean uploadNow, final RequestListener<byte[]> listener) {
        if (!this.c.isEnabled()) {
            return;
        }
        ThreadPool.executeInBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean bl;
                    int n = DataController.this.d.insert(id, values);
                    boolean bl2 = bl = n != 1 || uploadNow;
                    if (bl) {
                        DataController.this.a(new RequestListener<byte[]>(){

                            public void a(byte[] byArray) {
                                DataController.this.d.clean();
                                if (listener != null) {
                                    listener.onRequestFinished(byArray);
                                }
                            }

                            @Override
                            public void onRequestFailed(InLocoMediaException error) {
                                DataController.this.d.trim();
                                if (listener != null) {
                                    listener.onRequestFailed(error);
                                }
                            }

                            @Override
                            public /* synthetic */ void onRequestFinished(Object object) {
                                this.a((byte[])object);
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    DataController.this.h.uncaughtException(Thread.currentThread(), throwable);
                }
                if (!uploadNow && listener != null) {
                    listener.onRequestFinished(null);
                }
            }
        });
    }

    private void a(final RequestListener<byte[]> requestListener) {
        if (this.j.compareAndSet(false, true)) {
            this.b(new RequestListener<byte[]>(){

                public void a(byte[] byArray) {
                    requestListener.onRequestFinished(byArray);
                    DataController.this.j.set(false);
                }

                @Override
                public void onRequestFailed(InLocoMediaException error) {
                    requestListener.onRequestFailed(error);
                    DataController.this.j.set(false);
                }

                @Override
                public /* synthetic */ void onRequestFinished(Object object) {
                    this.a((byte[])object);
                }
            });
        }
    }

    private void b(final @NonNull RequestListener<byte[]> requestListener) {
        ThreadPool.executeInBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!NetworkAccessTools.isNetworkAvailable(DataController.this.b)) {
                        requestListener.onRequestFailed(new InLocoMediaException("Error: Please check internet connection!"));
                        return;
                    }
                    SparseArray<StorageEntry> sparseArray = DataController.this.d.dump();
                    if (sparseArray == null || sparseArray.size() == 0) {
                        requestListener.onRequestFinished(null);
                        return;
                    }
                    SerializedData serializedData = DataController.this.e.process(sparseArray);
                    if (serializedData == null) {
                        requestListener.onRequestFailed(new InLocoMediaException("Error: Could not process storage dump data!"));
                        return;
                    }
                    if (serializedData.getData().length > DataController.this.c.getLimitWWANSize() && !NetworkAccessTools.isConnectedViaWifi(DataController.this.b)) {
                        requestListener.onRequestFailed(new InLocoMediaException("Error: Data is too big to be sent through mobile networks, try to connect to wifi!"));
                        return;
                    }
                    DataController.this.f.sendRequestWithData(serializedData, DataController.this.c.getService(), requestListener);
                }
                catch (Throwable throwable) {
                    DataController.this.uncaughtException(Thread.currentThread(), throwable);
                }
            }
        });
    }

    @Override
    public void onTimeToReload() {
        if (this.i) {
            this.a(new RequestListener<byte[]>(){

                public void a(byte[] byArray) {
                }

                @Override
                public void onRequestFailed(InLocoMediaException error) {
                }

                @Override
                public /* synthetic */ void onRequestFinished(Object object) {
                    this.a((byte[])object);
                }
            });
            if (!this.c.isEnabled()) {
                this.enableTransmissionsInterval(false);
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
    }

    public void uncaughtException(Thread t, Throwable e) {
        if (this.h != null) {
            this.h.uncaughtException(t, e);
        }
    }

    public static class Builder {
        private Context a;
        private DataControllerConfig b;
        private Processor c;
        private Requestor<byte[]> d;
        private Storage e;
        private Thread.UncaughtExceptionHandler f;

        public Builder setContext(Context context) {
            this.a = context;
            return this;
        }

        public Builder setDataControllerConfig(DataControllerConfig config) {
            this.b = config;
            return this;
        }

        public Builder setStorage(Storage storage) {
            this.e = storage;
            return this;
        }

        public Builder setProcessor(Processor processor) {
            this.c = processor;
            return this;
        }

        public Builder setRequestor(Requestor<byte[]> requestor) {
            this.d = requestor;
            return this;
        }

        public Builder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.f = uncaughtExceptionHandler;
            return this;
        }

        public DataController build() {
            Validator.notNull(this.a, "Context");
            Validator.notNull(this.b, "Data Controller Config");
            Validator.notNull(this.b.getDataControllerId(), "Id");
            Validator.notNull(this.e, "Storage");
            Validator.notNull(this.c, "Processor");
            Validator.notNull(this.d, "Requestor");
            Validator.notNull(this.f, "Uncaught Exception Handler");
            return new DataController(this);
        }
    }
}

