/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.LruCache;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.MessageHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class MemoryCache {
    private static final String a = Logger.makeTag(MemoryCache.class);
    private static int b = 7;
    private static AtomicReference<MemoryCache> c = new AtomicReference();
    private LruCache<String, Bitmap> d;
    private AtomicBoolean e;
    private MessageHandler f;
    private Long g;

    public static MemoryCache getInstance(Context context) {
        MemoryCache memoryCache = c.get();
        if (memoryCache == null) {
            c.compareAndSet(null, new MemoryCache(context));
            memoryCache = c.get();
        }
        return memoryCache;
    }

    private MemoryCache(Context context) {
        try {
            this.d = new a(context);
            this.e = new AtomicBoolean();
            this.f = new MessageHandler("InLocoMemoryCache");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Bitmap put(String key, Bitmap bitmap) {
        this.g = SystemClock.elapsedRealtime();
        if (this.e.compareAndSet(false, true)) {
            this.b();
        }
        return this.d != null ? (Bitmap)this.d.put((Object)key, (Object)bitmap) : null;
    }

    public Bitmap get(String key) {
        this.g = SystemClock.elapsedRealtime();
        return this.d != null ? (Bitmap)this.d.get((Object)key) : null;
    }

    private void b() {
        this.f.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (MemoryCache.this.g != null) {
                    Long l = SystemClock.elapsedRealtime() - MemoryCache.this.g;
                    if (MemoryCache.this.e.compareAndSet(120000L < l, false)) {
                        MemoryCache.clear();
                    } else {
                        MemoryCache.this.f.postDelayed(this, 240000L, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }, 240000L, TimeUnit.MILLISECONDS);
        this.f.start();
    }

    public static void clear() {
        MemoryCache memoryCache = c.get();
        if (memoryCache != null) {
            memoryCache.d.evictAll();
        }
    }

    @VisibleForTesting
    public static void reset() {
        MemoryCache memoryCache = c.get();
        if (memoryCache != null) {
            if (memoryCache.f != null) {
                Handler handler = memoryCache.f.getHandler();
                if (handler != null) {
                    handler.removeCallbacks(null);
                }
                memoryCache.f.stop();
            }
            MemoryCache.clear();
            c.set(null);
        }
    }

    public static void setMaxMemorySize(int maxMemory) {
        b = maxMemory;
    }

    private static class a
    extends LruCache<String, Bitmap> {
        a(Context context) {
            super(com.inlocomedia.android.core.util.MemoryCache$a.a(context));
        }

        protected int a(String string, Bitmap bitmap) {
            return bitmap.getByteCount();
        }

        private static int a(Context context) {
            int n = 0xA00000;
            if (context != null) {
                ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
                int n2 = activityManager.getMemoryClass();
                if (bl) {
                    n2 = activityManager.getLargeMemoryClass();
                }
                n = (int)((double)(0x100000L * (long)n2 * (long)b) / 100.0);
                n = Math.min(n, 0xA00000);
            }
            return n;
        }

        protected /* synthetic */ int sizeOf(Object object, Object object2) {
            return this.a((String)object, (Bitmap)object2);
        }
    }
}

