/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.config;

import android.content.Context;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.serialization.json.JsonableModel;
import com.inlocomedia.android.core.serialization.json.PersistentJsonableModel;
import java.util.concurrent.TimeUnit;

public abstract class ConfigurationModel
extends PersistentJsonableModel {
    public static final String TAG = Logger.makeTag(ConfigurationModel.class);
    protected static final long DEFAULT_SELF_UPDATE_TIME = TimeUnit.DAYS.toMillis(1L);
    @JsonableModel.JsonField(key="su_time")
    public long mSelfUpdateInterval = DEFAULT_SELF_UPDATE_TIME;
    @JsonableModel.JsonField(key="lst_up_ts")
    public long mLastUpdateTimestamp;

    public abstract void reset();

    public ConfigurationModel(Context context, int version) {
        super(version, true);
        this.reset();
        this.restore(context);
    }

    @Override
    public boolean clear(Context context) {
        boolean bl = super.clear(context);
        if (bl) {
            this.mLastUpdateTimestamp = 0L;
            this.reset();
        }
        return bl;
    }
}

